/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.scrap.command;

import com.els.base.core.entity.IExample;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.mould.common.AbstractMouldCommand;
import com.els.base.mould.common.MouldInvorker;
import com.els.base.mould.master.entity.Mould;
import com.els.base.mould.master.entity.MouldExample;
import com.els.base.mould.master.utils.MouldStatus;
import com.els.base.mould.scrap.entity.Scrap;
import com.els.base.mould.scrap.entity.ScrapExample;
import com.els.base.mould.scrap.utils.ConfirmStatus;
import com.els.base.mould.scrap.utils.ScrapBusinessEnum;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import java.util.Date;
import java.util.List;

public class ConfirmScrapCommand
extends AbstractMouldCommand<String> {
    private List<String> ids;
    private User user;

    public ConfirmScrapCommand(List<String> ids, User user) {
        this.ids = ids;
        this.user = user;
    }

    @Override
    public String execute(MouldInvorker mouldInvorker) {
        ScrapExample example = new ScrapExample();
        example.createCriteria().andIdIn((List)this.ids);
        List scrapList = mouldInvorker.getScrapService().queryAllObjByExample((IExample)example);
        for (Scrap scrap : scrapList) {
            Assert.isNotNull((Object)scrap, (String)"\u62a5\u5e9f\u5355\u4e0d\u80fd\u4e3a\u7a7a");
            if (scrap.getSendStatus().equals(Constant.NO_INT)) {
                throw new CommonException("\u672a\u53d1\u9001\u7684\u62a5\u5e9f\u5355\u4e0d\u80fd\u786e\u8ba4");
            }
            if (scrap.getIsEnable().equals(Constant.YES_INT)) {
                throw new CommonException("\u5df2\u5220\u9664\u7684\u62a5\u5e9f\u5355\u4e0d\u80fd\u786e\u8ba4");
            }
            if (scrap.getConfirmStatus().equals(ConfirmStatus.SCRAP_PUR_CONFIRM.getValue())) {
                throw new CommonException("\u5df2\u786e\u8ba4\u8fc7\u7684\u62a5\u5e9f\u5355\u4e0d\u80fd\u91cd\u590d\u786e\u8ba4");
            }
            scrap.setConfirmStatus(ConfirmStatus.SCRAP_PUR_CONFIRM.getValue());
            scrap.setConfirmTime(new Date());
            if (scrap.getScrapTime() == null) {
                scrap.setScrapTime(new Date());
            }
            scrap.setMouldStatus(MouldStatus.ABLOISH.getCode());
            mouldInvorker.getScrapService().modifyObj(scrap);
            MouldExample example2 = new MouldExample();
            example2.createCriteria().andMouldIdEqualTo(scrap.getMouldId());
            List moulds = this.mouldInvorker.getMouldService().queryAllObjByExample((IExample)example2);
            for (Mould mould : moulds) {
                mould.setId(mould.getId());
                mould.setMouldStatus(MouldStatus.ABLOISH.getCode());
                mould.setAbolishDate(scrap.getScrapTime());
                mouldInvorker.getMouldService().modifyObj(mould);
            }
            this.sendMessagesToConceiveSup(this.user, scrap, ScrapBusinessEnum.PUR_SCRAP_CONFIRM.getCode());
        }
        return null;
    }

    private void sendMessagesToConceiveSup(User loginUser, Scrap data, String businessType) {
        User supUser = this.mouldInvorker.getCompanyUserRefService().queryMainUserOfCompany(data.getConceiveSupCompanyId());
        Message message = Message.init((Object)data).setBusinessTypeCode(businessType).setCompanyCode(data.getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(loginUser.getId()).addReceiverId(supUser.getId());
        MessageSendUtils.sendMessage((Message)message);
    }
}

