/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.company.service.impl;

import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.RoleExample;
import com.els.base.auth.entity.UserRole;
import com.els.base.auth.service.RoleService;
import com.els.base.auth.service.UserRoleService;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.dao.CompanyMapper;
import com.els.base.company.dao.CompanyPartnerMapper;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.entity.CompanyPartner;
import com.els.base.company.entity.CompanyPartnerExample;
import com.els.base.company.event.CompanyCreatedSuccessEvent;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.company.utils.PartnerRoleEnum;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.project.Project;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.project.ProjectService;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Constant;
import com.els.base.utils.SpringContextHolder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultCompanyService")
public class CompanyServiceImpl
implements CompanyService {
    @Resource
    private CompanyMapper companyMapper;
    @Resource
    private CompanyPartnerMapper companyPartnerMapper;
    @Resource
    private UserService userService;
    @Resource
    private GenerateCodeService generateCodeService;
    @Resource
    private CompanyUserRefService companyUserRefService;
    @Resource
    private ProjectService projectService;
    @Resource
    private RoleService roleService;
    @Resource
    private UserRoleService userRoleService;

    @Override
    @Cacheable(value={"company"}, keyGenerator="redisKeyGenerator")
    public Integer isFinish(Company company) {
        if (!Constant.YES_INT.equals((company = this.queryObjById(company.getId())).getIsEnable())) {
            return Constant.NO_INT;
        }
        if (!Constant.YES_INT.equals(company.getFinishFlag())) {
            return Constant.NO_INT;
        }
        return Constant.YES_INT;
    }

    @Override
    @Transactional
    @CacheEvict(value={"company"}, allEntries=true)
    public void addObj(Company t) {
        if (StringUtils.isBlank((String)t.getCompanyFullName())) {
            throw new CommonException("CompanyFullNam\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "CompanyFullNam");
        }
        CompanyExample companyExample = new CompanyExample();
        CompanyExample.Criteria companyExampleCriteria = companyExample.createCriteria();
        companyExampleCriteria.andCompanyFullNameEqualTo(t.getCompanyFullName());
        int count = this.companyMapper.countByExample(companyExample);
        if (count > 0) {
            throw new CommonException("\u516c\u53f8\u540d\u79f0 " + t.getCompanyFullName() + "\u5df2\u5b58\u5728", "base_is_exists", "CompanyFullName");
        }
        t.setId(null);
        t.setCompanyCode(this.generateCodeService.getNextCompanyCode());
        this.companyMapper.insertSelective(t);
        SpringContextHolder.getApplicationContext().publishEvent((ApplicationEvent)new CompanyCreatedSuccessEvent(t));
    }

    @Override
    @Transactional
    @CacheEvict(value={"company"}, allEntries=true)
    public void deleteObjById(String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("id\u4e0d\u80fd\u4e3a\u7a7a", "id_is_blank");
        }
        Company company = this.companyMapper.selectByPrimaryKey(id);
        if (company == null) {
            throw new CommonException("companyId\u4e0d\u80fd\u4e3a\u7a7a", "id_is_blank");
        }
        company.setIsEnable(Constant.NO_INT);
        this.companyMapper.updateByPrimaryKey(company);
    }

    @Override
    @Transactional
    @CacheEvict(value={"company"}, allEntries=true)
    public void modifyObj(Company t) {
        t.setCompanyCode(null);
        if (StringUtils.isBlank((String)t.getId())) {
            throw new CommonException("companyId\u4e3a\u7a7a", "id_is_blank");
        }
        if (!(t.getCompanyFullName() == null || t.getCompanyFullName().length() <= 255 && t.getCompanyFullName().matches("[\\u4e00-\\u9fa5\\w\\-\\_\\(\uff08\\)\uff09]+"))) {
            throw new CommonException("\u683c\u5f0f\u4e0d\u6b63\u786e", "base_invaild_format", "\u4f01\u4e1a\u5168\u79f0");
        }
        if (!(t.getCompanyName() == null || t.getCompanyName().length() <= 255 && t.getCompanyName().matches("[\\u4e00-\\u9fa5\\w\\-\\_\\(\uff08\\)\uff09]+"))) {
            throw new CommonException("\u683c\u5f0f\u4e0d\u6b63\u786e", "base_invaild_format", "\u4f01\u4e1a\u7b80\u79f0");
        }
        this.companyMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"company"}, keyGenerator="redisKeyGenerator")
    public Company queryObjById(String id) {
        return this.companyMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"company"}, keyGenerator="redisKeyGenerator")
    public List<Company> queryAllObjByExample(CompanyExample example) {
        return this.companyMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"company"}, keyGenerator="redisKeyGenerator")
    public PageView<Company> queryObjByPage(CompanyExample example) {
        PageView<Company> pageView = example.getPageView();
        pageView.setQueryResult(this.companyMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"company"}, keyGenerator="redisKeyGenerator")
    public PageView<Company> querySupplerCompanies(String purCompanyId, CompanyExample companyExample) {
        PageView<Company> pageView = companyExample.getPageView();
        List<Company> companyList = this.companyMapper.selectSupCompanyByPage(companyExample, purCompanyId);
        pageView.setQueryResult(companyList);
        return pageView;
    }

    @Override
    @Cacheable(value={"company"}, keyGenerator="redisKeyGenerator")
    public PageView<Company> queryPurchaseCompaniesByPage(String companyId, CompanyExample companyExample) {
        CompanyPartnerExample partnerExample = new CompanyPartnerExample();
        partnerExample.createCriteria().andPartnerCompanyIdEqualTo(companyId);
        List<CompanyPartner> partnerList = this.companyPartnerMapper.selectByExample(partnerExample);
        if (CollectionUtils.isEmpty(partnerList)) {
            return companyExample.getPageView();
        }
        ArrayList<String> partnerIdList = new ArrayList<String>();
        for (CompanyPartner partner : partnerList) {
            partnerIdList.add(partner.getCompanyId());
        }
        if (CollectionUtils.isEmpty(companyExample.getOredCriteria())) {
            companyExample.createCriteria().andIdIn(partnerIdList).andIsEnableEqualTo(Constant.YES_INT);
        } else {
            for (int i = 0; i < companyExample.getOredCriteria().size(); ++i) {
                companyExample.getOredCriteria().get(i).andIdIn(partnerIdList).andIsEnableEqualTo(Constant.YES_INT);
            }
        }
        List<Company> companyList = this.companyMapper.selectByExampleByPage(companyExample);
        return companyExample.getPageView().setQueryResult(companyList);
    }

    @Override
    @Cacheable(value={"company"}, keyGenerator="redisKeyGenerator")
    public List<Company> queryPurchaseCompanies(String companyId, CompanyExample companyExample) {
        CompanyPartnerExample partnerExample = new CompanyPartnerExample();
        partnerExample.createCriteria().andPartnerCompanyIdEqualTo(companyId);
        List<CompanyPartner> partnerList = this.companyPartnerMapper.selectByExample(partnerExample);
        if (CollectionUtils.isEmpty(partnerList)) {
            return null;
        }
        ArrayList<String> partnerIdList = new ArrayList<String>();
        for (CompanyPartner partner : partnerList) {
            partnerIdList.add(partner.getCompanyId());
        }
        if (companyExample == null) {
            companyExample = new CompanyExample();
        }
        if (CollectionUtils.isEmpty(companyExample.getOredCriteria())) {
            companyExample.createCriteria().andIdIn(partnerIdList).andIsEnableEqualTo(Constant.YES_INT);
        } else {
            for (int i = 0; i < companyExample.getOredCriteria().size(); ++i) {
                companyExample.getOredCriteria().get(i).andIdIn(partnerIdList).andIsEnableEqualTo(Constant.YES_INT);
            }
        }
        return this.companyMapper.selectByExample(companyExample);
    }

    @Override
    @Cacheable(value={"company"}, keyGenerator="redisKeyGenerator")
    public Company queryPurchaseCompanies(String supCompanyId) {
        CompanyExample companyExample = new CompanyExample();
        companyExample.createCriteria().andIsEnableEqualTo(Constant.YES_INT);
        List<Company> list = this.queryPurchaseCompanies(supCompanyId, companyExample);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        if (list.size() > 1) {
            throw new CommonException("\u8be5\u4f9b\u5e94\u5546\u6709\u591a\u4e2a\u91c7\u8d2d\u5546");
        }
        return list.get(0);
    }

    @Override
    @Transactional
    @CacheEvict(value={"company"}, allEntries=true)
    public void addCompanyAsSupplier(CompanyPartner companyPartner) {
        if (StringUtils.isBlank((String)companyPartner.getCompanyId())) {
            throw new CommonException("\u91c7\u8d2d\u5546id\u4e0d\u80fd\u4e3a\u7a7a", "id_is_blank");
        }
        if (companyPartner.getPartner() == null) {
            throw new CommonException("\u4f9b\u5e94\u5546\u7684\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u4f9b\u5e94\u5546\u7684\u4fe1\u606f");
        }
        Company partner = companyPartner.getPartner();
        this.addObj(partner);
        companyPartner.setPartnerCompanyId(partner.getId());
        this.companyPartnerMapper.insertSelective(companyPartner);
    }

    @Override
    @CacheEvict(value={"company"}, allEntries=true)
    public void changeCompanyPartnerRole(String companyId, String supplierCompanyId, String roleCode) {
        CompanyPartnerExample partnerExample = new CompanyPartnerExample();
        partnerExample.createCriteria().andCompanyIdEqualTo(companyId).andPartnerCompanyIdEqualTo(supplierCompanyId);
        List<CompanyPartner> list = this.companyPartnerMapper.selectByExample(partnerExample);
        if (CollectionUtils.isEmpty(list)) {
            CompanyPartner partner = new CompanyPartner();
            partner.setCompanyId(companyId);
            partner.setPartnerCompanyId(supplierCompanyId);
            partner.setPartnerCompanyName(this.queryObjById(supplierCompanyId).getCompanyName());
            partner.setPartnerRoleCode(roleCode);
            this.companyPartnerMapper.insertSelective(partner);
        } else {
            CompanyPartner partner = new CompanyPartner();
            partner.setPartnerRoleCode(roleCode);
            this.companyPartnerMapper.updateByExampleSelective(partner, partnerExample);
        }
    }

    @Override
    @Cacheable(value={"company"}, keyGenerator="redisKeyGenerator")
    public int isEnable(String companyId, Integer isEnable) {
        Company company = new Company();
        company.setId(companyId);
        company.setIsEnable(isEnable);
        return this.companyMapper.updateByPrimaryKeySelective(company);
    }

    @Override
    @Cacheable(value={"company"}, keyGenerator="redisKeyGenerator")
    public List<Company> queryAllSupplerCompanies(String purCompanyId, CompanyExample companyExample) {
        if (CollectionUtils.isNotEmpty(companyExample.getOredCriteria())) {
            companyExample.getOredCriteria().get(0).andIsEnableEqualTo(Constant.YES_INT);
        }
        List<Company> companyList = this.companyMapper.selectSupCompany(companyExample, purCompanyId);
        return companyList;
    }

    @Override
    @Cacheable(value={"company"}, keyGenerator="redisKeyGenerator")
    public PageView<Company> querySupplerCompanies(String purCompanyId, CompanyExample companyExample, String roleEnum) {
        PageView<Company> pageView = companyExample.getPageView();
        List<Company> list = this.companyMapper.selectPartnerByExampleByPage(purCompanyId, companyExample, roleEnum);
        pageView.setQueryResult(list);
        return pageView;
    }

    @Override
    public PageView<Company> querySupplerCompaniesForApply(String purCompanyId, CompanyExample companyExample, String roleEnum) {
        PageView<Company> pageView = companyExample.getPageView();
        List<Company> list = this.companyMapper.selectPartnerByExampleForApplyByPage(purCompanyId, companyExample, roleEnum);
        pageView.setQueryResult(list);
        return pageView;
    }

    @Override
    @Cacheable(value={"company"}, keyGenerator="redisKeyGenerator")
    public Company queryCompanyByCode(String companyCode) {
        CompanyExample example = new CompanyExample();
        CompanyExample.Criteria criteria = example.createCriteria();
        criteria.andCompanyCodeEqualTo(companyCode);
        List<Company> companyList = this.companyMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(companyList)) {
            return null;
        }
        return companyList.get(0);
    }

    @Override
    @Transactional
    @CacheEvict(value={"company"}, allEntries=true)
    public void updatePartnerRole(CompanyPartner companyPartner, CompanyPartnerExample example) {
        companyPartner.setId(null);
        this.companyPartnerMapper.updateByExampleSelective(companyPartner, example);
    }

    @Override
    @Transactional
    @CacheEvict(value={"company"}, allEntries=true)
    public String register(Project project, Company company) {
        CompanyExample companyExample = new CompanyExample();
        CompanyExample.Criteria companyExampleCriteria = companyExample.createCriteria();
        companyExampleCriteria.andCompanyFullNameEqualTo(company.getCompanyFullName());
        int count = this.companyMapper.countByExample(companyExample);
        if (count > 0) {
            throw new CommonException("\u516c\u53f8\u540d\u79f0\u5df2\u5b58\u5728,\u4e0d\u80fd\u91cd\u590d", "base_is_exists", "\u516c\u53f8\u540d\u79f0");
        }
        companyExample.clear();
        companyExample.createCriteria().andMobilephoneEqualTo(company.getMobilephone());
        int count2 = this.companyMapper.countByExample(companyExample);
        if (count2 > 0) {
            throw new CommonException("\u624b\u673a\u53f7\u7801 \u5df2\u5b58\u5728,\u4e0d\u80fd\u91cd\u590d", "base_is_exists", "\u624b\u673a\u53f7\u7801 ");
        }
        company.setProjectId(project.getId());
        company.setIsEnable(Constant.YES_INT);
        company.setCreateTime(new Date());
        company.setId(null);
        company.setCompanyCode(this.generateCodeService.getNextCompanyCode());
        this.companyMapper.insertSelective(company);
        User user = new User();
        user.setLoginName(company.getCompanyCode());
        user.setMobilePhone(company.getMobilephone());
        user.setPassword(company.getPassword());
        user.setEmail(company.getEmail());
        user.setIsEnable(Constant.YES_INT);
        if (project != null) {
            user.setProjectCode(project.getProjectCode());
        }
        this.userService.addObj(user);
        this.companyUserRefService.addUserIntoCompany(user.getId(), company.getId());
        RoleExample roleExample = new RoleExample();
        RoleExample.Criteria roleExampleCriteria = roleExample.createCriteria();
        roleExampleCriteria.andRoleCodeEqualTo(PartnerRoleEnum.STRANGER.getUserRoleCode());
        List list = this.roleService.queryAllObjByExample((IExample)roleExample);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (Role role : list) {
                UserRole t = new UserRole();
                t.setUserId(user.getId());
                t.setRoleId(role.getId());
                t.setCreateTime(new Date());
                this.userRoleService.addObj((Serializable)t);
            }
        }
        CompanyPartner companyPartner = new CompanyPartner();
        companyPartner.setProjectId(project.getId());
        companyPartner.setCompanyId(project.getCompanyId());
        companyPartner.setPartnerCompanyId(company.getId());
        companyPartner.setPartnerCompanyName(company.getCompanyFullName());
        companyPartner.setPartnerRoleCode(PartnerRoleEnum.STRANGER.getCode());
        companyPartner.setPartnerRoleName(PartnerRoleEnum.STRANGER.getName());
        this.companyPartnerMapper.insertSelective(companyPartner);
        return company.getCompanyCode();
    }

    @Override
    @Cacheable(value={"company"}, keyGenerator="redisKeyGenerator")
    public List<Company> queryChildCompany(String parentId) {
        CompanyExample example = new CompanyExample();
        example.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andParentIdEqualTo(parentId);
        return this.queryAllObjByExample(example);
    }

    @Override
    public PageView<Company> querySupplerCompaniesAndRoleInfo(String purCompanyId, CompanyExample companyExample, List<String> list) {
        PageView<Company> pageView = companyExample.getPageView();
        List<Company> selectPartner = this.companyMapper.selectPartnerByPage(purCompanyId, companyExample, list);
        pageView.setQueryResult(selectPartner);
        return pageView;
    }
}

