/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.core.web.controller;

import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.ResponseCode;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.messaging.handler.annotation.support.MethodArgumentNotValidException;
import org.springframework.validation.ObjectError;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class ExceptionAdvice {
    private static Logger logger = LoggerFactory.getLogger(ExceptionAdvice.class);

    @ExceptionHandler(value={DataAccessException.class})
    @ResponseBody
    public ResponseResult<String> handleSQLException(DataAccessException e) {
        logger.error("\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
        ResponseResult<String> responseResult = ResponseResult.fail(ResponseCode.ERROR);
        responseResult.setMsg("\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38,\u8bf7\u68c0\u67e5\u662f\u5426\u662f\u7531\u4e8e\u66f4\u6539\u8d85\u8fc7\u9884\u671f\u7684\u8bb0\u5f55\u6570\uff0c\u6216\u8005\u6570\u636e\u5e93\u4e2d\u7f3a\u5931\u8be5\u5b57\u6bb5\uff0c\u6216\u8005\u5b57\u6bb5\u503c\u592a\u957f\u4e86\uff01");
        responseResult.setI18nCode(ResponseCode.ERROR.getKey());
        return responseResult;
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    @ResponseBody
    public ResponseResult<String> handleHttpMessageNotReadableException(HttpMessageNotReadableException e) {
        logger.error("\u53c2\u6570\u89e3\u6790\u5931\u8d25", (Throwable)e);
        return ResponseResult.fail(ResponseCode.DATABASE_PARSE_ERROR);
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseBody
    public ResponseResult<String> handleHttpRequestMethodNotSupportedException(HttpRequestMethodNotSupportedException e) {
        logger.error("\u4e0d\u652f\u6301\u5f53\u524d\u8bf7\u6c42\u65b9\u6cd5", (Throwable)e);
        return ResponseResult.fail(ResponseCode.METHOD_NO_SUPPORT);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseBody
    public ResponseResult<String> validateErrorHandler(HttpServletRequest req, MethodArgumentNotValidException e) {
        logger.error(String.format("\u53d1\u751f\u9a8c\u8bc1\u9519\u8bef\uff1a\u8bbf\u95eeURL\u5730\u5740=%s", req.getRequestURL()), (Throwable)e);
        List errors = e.getBindingResult().getAllErrors();
        ArrayList<String> errorMsgs = new ArrayList<String>();
        Iterator iterator = errors.iterator();
        if (iterator.hasNext()) {
            ObjectError objectError = (ObjectError)iterator.next();
            errorMsgs.add(objectError.getDefaultMessage());
        }
        String errorInfo = Joiner.on((String)";").join(errorMsgs);
        ResponseResult<Object> res = new ResponseResult<Object>("400", errorInfo, null);
        return res;
    }

    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    @ResponseBody
    public ResponseResult<String> handleHttpMediaTypeNotSupportedException(HttpMediaTypeNotSupportedException e) {
        logger.error("\u4e0d\u652f\u6301\u5f53\u524d\u5a92\u4f53\u7c7b\u578b", (Throwable)e);
        return ResponseResult.fail(ResponseCode.Format_Error);
    }

    @ExceptionHandler(value={CommonException.class})
    @ResponseBody
    public ResponseResult<String> handleCmException(CommonException e) {
        logger.debug("\u4e1a\u52a1\u5f02\u5e38:" + e.getMessage());
        ResponseResult<String> responseResult = ResponseResult.fail(ResponseCode.Fail);
        responseResult.setMsg(e.getMessage());
        responseResult.setI18nCode(e.getI18nCode());
        responseResult.setI18nArgs(e.getI18nArgs());
        return responseResult;
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ResponseResult<String> handleException(Exception e) {
        CommonException newException = CommonException.matchCommonException(e.getMessage());
        if (newException != null) {
            return this.handleCmException(newException);
        }
        logger.error("\u7cfb\u7edf\u5f02\u5e38", (Throwable)e);
        ResponseResult<String> responseResult = ResponseResult.fail(ResponseCode.ERROR);
        responseResult.setMsg("\u7cfb\u7edf\u5185\u90e8\u5f02\u5e38");
        responseResult.setI18nCode(ResponseCode.ERROR.getKey());
        return responseResult;
    }
}

