/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.core.web.interceptor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class HttpLogInterceptor
extends HandlerInterceptorAdapter {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ThreadLocal<Long> threadTime = new ThreadLocal();

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String schemem = request.getScheme();
        String serverName = request.getServerName();
        int serverPort = request.getServerPort();
        String requestPath = request.getRequestURI();
        String targetUrl = schemem + "://" + serverName + ":" + serverPort + requestPath;
        String paramStr = this.getParams(request);
        if (StringUtils.isNotBlank((String)paramStr)) {
            targetUrl = targetUrl + "?" + paramStr;
        }
        this.logger.debug("start handle, url:" + targetUrl);
        long l1 = System.currentTimeMillis();
        this.threadTime.set(l1);
        return super.preHandle(request, response, handler);
    }

    private String getParams(HttpServletRequest request) {
        Map params = request.getParameterMap();
        ArrayList<String> paramList = new ArrayList<String>(params.size());
        Iterator iterator = params.keySet().iterator();
        while (iterator.hasNext()) {
            String key = ((String)iterator.next()).toString();
            String[] values = (String[])params.get(key);
            if (values == null || values.length <= 0) continue;
            paramList.add(key + "=" + values[0]);
        }
        return StringUtils.join(paramList, (String)"&");
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        String schemem = request.getScheme();
        String serverName = request.getServerName();
        int serverPort = request.getServerPort();
        String requestPath = request.getRequestURI();
        String targetUrl = schemem + "://" + serverName + ":" + serverPort + requestPath;
        String queryStr = this.getParams(request);
        if (StringUtils.isNotBlank((String)queryStr)) {
            targetUrl = targetUrl + "?" + queryStr;
        }
        long l1 = this.threadTime.get();
        this.logger.debug("end handle, cost[" + (System.currentTimeMillis() - l1) + "ms] url:" + targetUrl);
        super.afterCompletion(request, response, handler, ex);
    }
}

