/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command.delivery;

import com.els.base.company.entity.FriendGroup;
import com.els.base.company.service.CompanyPurRefService;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.purchase.command.AbstractOrderCommand;
import com.els.base.purchase.command.OrderComandInvoker;
import com.els.base.purchase.command.order.ModifyOrderItemForDeliveryCmd;
import com.els.base.purchase.entity.DeliveryOrder;
import com.els.base.purchase.entity.DeliveryOrderItem;
import com.els.base.purchase.entity.DeliveryPackage;
import com.els.base.purchase.utils.DeliverOrderComparator;
import com.els.base.purchase.utils.DeliveryStatusEnum;
import com.els.base.purchase.utils.DeliveryTypeEnum;
import com.els.base.purchase.utils.HKStatusEnum;
import com.els.base.utils.SpringContextHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class CreateCommand
extends AbstractOrderCommand<String> {
    private DeliveryOrder deliveryOrder;

    public CreateCommand(DeliveryOrder deliveryOrder) {
        this.deliveryOrder = deliveryOrder;
    }

    @Override
    public String execute(OrderComandInvoker context) {
        this.valid(this.deliveryOrder);
        this.init(this.deliveryOrder);
        for (DeliveryOrderItem currentItem : this.deliveryOrder.getItems()) {
            context.invoke(new ModifyOrderItemForDeliveryCmd(currentItem.getPurOrderItemId(), "DO_ADD", currentItem.getDeliveryQuantity()));
        }
        FriendGroup friendGroup = this.getCompanyPurRefService().queryPurchaseFriendGroup(this.deliveryOrder.getCompanyId(), this.deliveryOrder.getPurCompanyId());
        if (friendGroup != null && CollectionUtils.isNotEmpty(friendGroup.getUserList())) {
            this.deliveryOrder.setPurUserId(friendGroup.getUserList().get(0).getId());
            this.deliveryOrder.setPurUserName(friendGroup.getUserList().get(0).getNickName());
        }
        context.getDeliveryOrderService().addObj(this.deliveryOrder);
        List<DeliveryOrderItem> items = this.deliveryOrder.getItems();
        Collections.sort(items, new DeliverOrderComparator());
        for (DeliveryOrderItem deliveryOrderItem : items) {
            deliveryOrderItem.setDeliveryOrderId(this.deliveryOrder.getId());
            context.getDeliveryOrderItemService().addObj(deliveryOrderItem);
            this.filtePackageList(deliveryOrderItem);
            List<DeliveryPackage> deliveryPackageTempList = deliveryOrderItem.getDeliveryPackageLists();
            if (!CollectionUtils.isNotEmpty(deliveryPackageTempList)) continue;
            context.getDeliveryPackageService().save(deliveryPackageTempList);
        }
        return null;
    }

    private void filtePackageList(DeliveryOrderItem deliveryOrderItem) {
        if (CollectionUtils.isEmpty(deliveryOrderItem.getDeliveryPackageLists())) {
            return;
        }
        ArrayList<DeliveryPackage> removedPackageList = new ArrayList<DeliveryPackage>();
        for (DeliveryPackage deliveryPackage : deliveryOrderItem.getDeliveryPackageLists()) {
            deliveryPackage.setUserId(this.deliveryOrder.getUserId());
            deliveryPackage.setUserName(this.deliveryOrder.getUserName());
            deliveryPackage.setProjectId(this.deliveryOrder.getProjectId());
            deliveryPackage.setCompanyId(this.deliveryOrder.getCompanyId());
            deliveryPackage.setCompanyCode(this.deliveryOrder.getCompanyCode());
            deliveryPackage.setCompanyName(this.deliveryOrder.getCompanyName());
            deliveryPackage.setDeliveryOrderId(this.deliveryOrder.getId());
            deliveryPackage.setDeliveryOrderNo(this.deliveryOrder.getDeliveryOrderNo());
            deliveryPackage.setDeliveryOrderItemId(deliveryOrderItem.getId());
            deliveryPackage.setDeliveryOrderItemNo(deliveryOrderItem.getDeliveryOrderItemNo());
            deliveryPackage.setMaterialId(deliveryOrderItem.getMaterialId());
            deliveryPackage.setMaterialNo(deliveryOrderItem.getMaterialNo());
            deliveryPackage.setMaterialDesc(deliveryOrderItem.getMaterialDesc());
            if (deliveryPackage.getTotalQuantity() != null && deliveryPackage.getTotalQuantity() != 0) continue;
            removedPackageList.add(deliveryPackage);
        }
        deliveryOrderItem.getDeliveryPackageLists().removeAll(removedPackageList);
    }

    private void init(DeliveryOrder deliveryOrder) {
        if (this.getSupCompany() != null) {
            deliveryOrder.setCompanyCode(this.getSupCompany().getCompanySapCode());
            deliveryOrder.setProjectId(this.getSupCompany().getProjectId());
            deliveryOrder.setCompanyId(this.getSupCompany().getId());
            deliveryOrder.setCompanyName(this.getSupCompany().getCompanyFullName());
        }
        if (this.getPurCompany() != null) {
            deliveryOrder.setPurCompanyId(this.getPurCompany().getId());
            deliveryOrder.setPurCompanyName(this.getPurCompany().getCompanyFullName());
            deliveryOrder.setPurCompanyCode(this.getPurCompany().getCompanyCode());
        }
        if (this.getSupUser() != null) {
            deliveryOrder.setUserId(this.getSupUser().getId());
            deliveryOrder.setUserName(this.getSupUser().getLoginName());
        }
        if (this.getPurUser() != null) {
            deliveryOrder.setPurUserId(this.getPurUser().getId());
            deliveryOrder.setPurUserName(this.getPurUser().getNickName());
        }
        deliveryOrder.setCreateTime(new Date());
        deliveryOrder.setIsEnable(Constant.YES_INT);
        deliveryOrder.setDeliveryStatus(DeliveryStatusEnum.UN_RECEIVED.getValue());
        if (StringUtils.isBlank((String)deliveryOrder.getType())) {
            deliveryOrder.setType(DeliveryTypeEnum.DELIVERY.getValue());
        }
        deliveryOrder.setIsHk(HKStatusEnum.UN_HK.getValue());
        HashSet<String> purOrderNoList = new HashSet<String>();
        int deliveryOrderItemNo = 1;
        for (DeliveryOrderItem deliveryOrderItem : deliveryOrder.getItems()) {
            if (StringUtils.isBlank((String)deliveryOrderItem.getPackQuantity())) {
                deliveryOrderItem.setPackQuantity("0");
            }
            deliveryOrderItem.setId(null);
            deliveryOrderItem.setDeliveryOrderItemNo(String.valueOf(deliveryOrderItemNo++));
            deliveryOrderItem.setDeliveryOrderNo(deliveryOrder.getDeliveryOrderNo());
            deliveryOrderItem.setType(deliveryOrder.getType());
            deliveryOrderItem.setDeliveryStatus(DeliveryStatusEnum.UN_RECEIVED.getValue());
            deliveryOrderItem.setDeliveryOrderId(deliveryOrder.getId());
            deliveryOrderItem.setProjectId(deliveryOrder.getProjectId());
            deliveryOrderItem.setCompanyId(deliveryOrder.getCompanyId());
            deliveryOrderItem.setUserId(deliveryOrder.getUserId());
            deliveryOrderItem.setUserName(deliveryOrder.getUserName());
            deliveryOrderItem.setPurUserId(deliveryOrder.getPurUserId());
            deliveryOrderItem.setPurUserName(deliveryOrder.getPurUserName());
            deliveryOrderItem.setReceiptQuantity("0");
            deliveryOrderItem.setCreateTime(new Date());
            if (StringUtils.isBlank((String)deliveryOrderItem.getPackQuantity())) {
                deliveryOrderItem.setPackQuantity("0");
            }
            purOrderNoList.add(deliveryOrderItem.getPurOrderNo());
        }
        String purOrderNoStr = StringUtils.join(purOrderNoList, (String)",");
        if (StringUtils.isNotBlank((String)purOrderNoStr) && purOrderNoStr.getBytes().length > 1000) {
            throw new CommonException("\u9001\u8d27\u5355\u66f4\u65b0\u5931\u8d25\uff0c\u8be5\u5355\u5173\u8054\u8fc7\u591a\u7684\u91c7\u8d2d\u8ba2\u5355\u53f7\uff0c\u6700\u591a100\u4e2a\u4e0d\u540c\u7684\u7684\u91c7\u8d2d\u8ba2\u5355");
        }
        deliveryOrder.setPurchaseOrderNo(purOrderNoStr);
    }

    private void valid(DeliveryOrder deliveryOrder) {
        Assert.isNotNull(deliveryOrder, "\u53d1\u8d27\u5355\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(deliveryOrder.getItems(), "\u884c\u6570\u636e\u4e0d\u5b58\u5728");
        if (deliveryOrder.getInvoiceNo() != null && deliveryOrder.getInvoiceNo().length() > 255 || deliveryOrder.getDriverName() != null && deliveryOrder.getDriverName().length() > 255 || deliveryOrder.getIdCard() != null && deliveryOrder.getIdCard().length() > 255 || deliveryOrder.getCar() != null && deliveryOrder.getCar().length() > 255) {
            throw new CommonException("\u9001\u8d27\u5355\u5934\u53c2\u6570\u957f\u5ea6\u8d85\u6807", "database_length_error");
        }
        for (DeliveryOrderItem deliveryOrderItem : deliveryOrder.getItems()) {
            Assert.isNotBlank(deliveryOrderItem.getPurOrderItemId(), "\u53c2\u6570\u5f02\u5e38\uff0c\u9001\u8d27\u5355\u884c\u4e2d\uff0c\u7f3a\u5c11\u91c7\u8d2d\u8ba2\u5355\u884cid");
            if (deliveryOrderItem.getChineseName() != null && deliveryOrderItem.getChineseName().length() > 255 || deliveryOrderItem.getRemark() != null && deliveryOrderItem.getRemark().length() > 255 || deliveryOrderItem.getBrand() != null && deliveryOrderItem.getBrand().length() > 255 || deliveryOrderItem.getSourceArea() != null && deliveryOrderItem.getSourceArea().length() > 255 || deliveryOrderItem.getModel() != null && deliveryOrderItem.getModel().length() > 255 || deliveryOrderItem.getCaseNo() != null && deliveryOrderItem.getCaseNo().length() > 30) {
                throw new CommonException("\u9001\u8d27\u5355\u884c\u53c2\u6570\u957f\u5ea6\u8d85\u6807", "database_length_error");
            }
            if (deliveryOrderItem.getDeliveryQuantity().compareTo(deliveryOrderItem.getCanDeliveryQuantity()) != 1) continue;
            throw new CommonException("\u53d1\u8d27\u6570\u91cf\u5927\u4e8e\u53ef\u53d1\u8d27\u6570\u91cf\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u53ef\u53d1\u8d27\u6570\u91cf\uff08\u6709\u53ef\u80fd\u662f\u8be5\u91c7\u8d2d\u8ba2\u5355\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u754c\u9762\u91cd\u65b0\u8fdb\u5165\uff09\uff01", "delivery_gt_candelivery", "\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u53ef\u53d1\u8d27\u6570\u91cf\uff08\u6709\u53ef\u80fd\u662f\u8be5\u91c7\u8d2d\u8ba2\u5355\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u754c\u9762\u91cd\u65b0\u8fdb\u5165\uff09\uff01");
        }
    }

    private CompanyPurRefService getCompanyPurRefService() {
        return (CompanyPurRefService)SpringContextHolder.getOneBean(CompanyPurRefService.class);
    }
}

