/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command.delivery;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.purchase.command.AbstractOrderCommand;
import com.els.base.purchase.command.OrderComandInvoker;
import com.els.base.purchase.command.order.ModifyOrderItemForDeliveryCmd;
import com.els.base.purchase.entity.DeliveryOrder;
import com.els.base.purchase.entity.DeliveryOrderItem;
import com.els.base.purchase.entity.DeliveryOrderItemExample;
import com.els.base.purchase.utils.DeliveryStatusEnum;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Date;
import java.util.List;

public class DeleteCommand
extends AbstractOrderCommand<String> {
    private List<String> deliveryOrderIdList;

    public DeleteCommand(List<String> deliveryOrderIdList) {
        Assert.isNotEmpty(deliveryOrderIdList, "\u9001\u8d27id\u4e0d\u80fd\u4e3a\u7a7a");
        this.deliveryOrderIdList = deliveryOrderIdList;
    }

    @Override
    public String execute(OrderComandInvoker context) {
        for (String id : this.deliveryOrderIdList) {
            DeliveryOrder deliveryOrder = (DeliveryOrder)context.getDeliveryOrderService().queryObjById(id);
            Assert.isNotNull(deliveryOrder, "\u6ca1\u6709\u627e\u5230\u8be5\u9001\u8d27\u5355");
            if (!DeliveryStatusEnum.ALL_RECEIVED.getValue().equals(deliveryOrder.getDeliveryStatus()) && !DeliveryStatusEnum.HK_RECEIVED.getValue().equals(deliveryOrder.getDeliveryStatus())) continue;
            throw new CommonException("\u8be5\u72b6\u6001\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        for (int i = 0; i < this.deliveryOrderIdList.size(); ++i) {
            this.context.getDeliveryOrderService().deleteAndAddHis(this.deliveryOrderIdList.get(i), "\u5220\u9664\u9001\u8d27\u5355");
        }
        this.deleteDeliveryItem(this.deliveryOrderIdList, "\u5220\u9664\u53d1\u8d27\u5355_\u5220\u9664\u53d1\u8d27\u5355\u884c");
        return null;
    }

    private void deleteDeliveryItem(List<String> deliveryOrderIdList, String remark) {
        DeliveryOrderItemExample exampleItemQuery = new DeliveryOrderItemExample();
        DeliveryOrderItemExample.Criteria criteriaItemQuery = exampleItemQuery.createCriteria();
        criteriaItemQuery.andDeliveryOrderIdIn((List)deliveryOrderIdList);
        List itemList = this.context.getDeliveryOrderItemService().queryAllObjByExample(exampleItemQuery);
        for (DeliveryOrderItem deliveryOrderItem : itemList) {
            this.context.invoke(new ModifyOrderItemForDeliveryCmd(deliveryOrderItem.getPurOrderItemId(), "DO_DELETE", deliveryOrderItem.getDeliveryQuantity()));
            String hisItemId = UUIDGenerator.generateUUID();
            this.context.getDeliveryOrderItemService().insertHis(hisItemId, deliveryOrderItem.getId(), "\u5220\u9664\u53d1\u8d27\u5355\u5934_\u5220\u9664\u53d1\u8d27\u5355\u884c", new Date());
        }
        DeliveryOrderItemExample exampleItem = new DeliveryOrderItemExample();
        DeliveryOrderItemExample.Criteria criteriaItem = exampleItem.createCriteria();
        criteriaItem.andDeliveryOrderIdIn((List)deliveryOrderIdList);
        this.context.getDeliveryOrderItemService().deleteByExample(exampleItem);
    }
}

