/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command.delivery;

import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.purchase.command.AbstractOrderCommand;
import com.els.base.purchase.command.OrderComandInvoker;
import com.els.base.purchase.command.delivery.PreviewDeliveryOrderItemCommand;
import com.els.base.purchase.entity.DeliveryOrder;
import com.els.base.purchase.entity.DeliveryOrderItem;
import com.els.base.purchase.entity.SupplierOrder;
import com.els.base.purchase.entity.SupplierOrderExample;
import com.els.base.purchase.utils.DeliveryStatusEnum;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class PreviewDeliveryOrderCommand
extends AbstractOrderCommand<DeliveryOrder> {
    private List<String> orderItemIdList;

    public PreviewDeliveryOrderCommand(List<String> orderItemIdList) {
        Assert.isNotEmpty(orderItemIdList, "\u8ba2\u8d27\u5355\u884c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        this.orderItemIdList = orderItemIdList;
    }

    @Override
    public DeliveryOrder execute(OrderComandInvoker context) {
        PreviewDeliveryOrderItemCommand previewItemCmd = new PreviewDeliveryOrderItemCommand(this.orderItemIdList);
        previewItemCmd.copyProperties(this);
        List<DeliveryOrderItem> items = context.invoke(previewItemCmd);
        GenerateCodeService generateCodeService = context.getGenerateCodeService();
        String deliveryOrderNo = generateCodeService.getNextCode("DELIVERY_NO_GENERATOR");
        HashSet<String> orderNos = new HashSet<String>();
        for (DeliveryOrderItem item : items) {
            orderNos.add(item.getPurOrderNo());
            item.setDeliveryOrderNo(deliveryOrderNo);
        }
        DeliveryOrder deliveryOrder = new DeliveryOrder();
        deliveryOrder.setDeliveryOrderNo(deliveryOrderNo);
        deliveryOrder.setItems(items);
        deliveryOrder.setCompanyId(items.get(0).getCompanyId());
        deliveryOrder.setCompanyName(items.get(0).getCompanyName());
        deliveryOrder.setPurUserId(items.get(0).getPurUserId());
        deliveryOrder.setPurUserName(items.get(0).getPurUserName());
        deliveryOrder.setPurCompanyId(items.get(0).getPurCompanyId());
        deliveryOrder.setPurCompanyCode(items.get(0).getPurCompanyCode());
        deliveryOrder.setPurCompanyName(items.get(0).getPurCompanyName());
        deliveryOrder.setVoucherType(this.getVoucherType(orderNos));
        deliveryOrder.setPurchaseOrderNo(StringUtils.abbreviate((String)StringUtils.join(orderNos, (String)","), (int)1000));
        deliveryOrder.setDeliveryStatus(DeliveryStatusEnum.UN_RECEIVED.getValue());
        if (this.getSupUser() != null) {
            deliveryOrder.setUserId(this.getSupUser().getId());
            deliveryOrder.setUserName(this.getSupUser().getNickName());
        }
        if (this.getPurUser() != null) {
            deliveryOrder.setPurUserId(this.getPurUser().getId());
            deliveryOrder.setPurUserName(this.getPurUser().getNickName());
        }
        if (this.getSupCompany() != null) {
            deliveryOrder.setCompanyCode(this.getSupCompany().getCompanyCode());
        }
        return deliveryOrder;
    }

    private String getVoucherType(Set<String> orderNos) {
        ArrayList orderNoList = new ArrayList(orderNos.size());
        CollectionUtils.addAll(orderNoList, orderNos.iterator());
        SupplierOrderExample example = new SupplierOrderExample();
        example.createCriteria().andOrderNoIn((List)orderNoList).andVoucherTypeIsNotNull();
        example.setPageView(new PageView<SupplierOrder>(1, 1));
        example.setOrderByClause("VOUCHER_TYPE DESC");
        PageView pageView = this.context.getSupplierOrderService().queryObjByPage(example);
        if (CollectionUtils.isEmpty(pageView.getQueryResult())) {
            return null;
        }
        return ((SupplierOrder)pageView.getQueryResult().get(0)).getVoucherType();
    }
}

