/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command.delivery;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.material.entity.Material;
import com.els.base.material.entity.MaterialExample;
import com.els.base.material.entity.SupplierMaterial;
import com.els.base.material.entity.SupplierMaterialExample;
import com.els.base.purchase.command.AbstractOrderCommand;
import com.els.base.purchase.command.OrderComandInvoker;
import com.els.base.purchase.entity.DeliveryOrderItem;
import com.els.base.purchase.entity.DeliveryPackage;
import com.els.base.purchase.entity.SupplierOrder;
import com.els.base.purchase.entity.SupplierOrderItem;
import com.els.base.purchase.entity.SupplierOrderItemExample;
import com.els.base.purchase.utils.DeliveryStatusEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;

public class PreviewDeliveryOrderItemCommand
extends AbstractOrderCommand<List<DeliveryOrderItem>> {
    private List<String> orderItemIdList;

    public PreviewDeliveryOrderItemCommand(List<String> orderItemIdList) {
        Assert.isNotEmpty(orderItemIdList, "\u6ca1\u6709\u8ba2\u8d27\u5355\u884c\u6570\u636e");
        this.orderItemIdList = orderItemIdList;
    }

    @Override
    public List<DeliveryOrderItem> execute(OrderComandInvoker context) {
        List<SupplierOrderItem> supplierOrderItemList = this.valid(this.orderItemIdList);
        ArrayList<DeliveryOrderItem> items = new ArrayList<DeliveryOrderItem>();
        for (SupplierOrderItem supplierOrderItem : supplierOrderItemList) {
            SupplierOrder supplierOrderTemp = (SupplierOrder)context.getSupplierOrderService().queryObjById(supplierOrderItem.getOrderId());
            DeliveryOrderItem deliveryOrderItem = this.convertDeliveryOrderItem(supplierOrderItem, supplierOrderTemp);
            deliveryOrderItem = this.setSupplierMaterial(deliveryOrderItem, supplierOrderItem.getVersion());
            items.add(deliveryOrderItem);
        }
        return items;
    }

    private List<SupplierOrderItem> valid(List<String> orderItemIdList) {
        Assert.isNotEmpty(orderItemIdList, "\u6ca1\u6709\u67e5\u8be2\u5230\u6570\u636e", "not_query_to_data");
        List<SupplierOrderItem> supplierOrderItemList = this.getSupplierOrderItem(orderItemIdList);
        Assert.isNotEmpty(orderItemIdList, "\u6ca1\u6709\u627e\u5230\u91c7\u8d2d\u8ba2\u5355", "not_found");
        this.checkInterType(supplierOrderItemList);
        this.checkInterTrade(supplierOrderItemList);
        this.isSameType(supplierOrderItemList);
        for (SupplierOrderItem supplierOrderItem : supplierOrderItemList) {
            if (supplierOrderItem.getDeliveryAmount() > 0L) continue;
            throw new CommonException("\u5df2\u7ecf\u5168\u90e8\u53d1\u8d27\uff0c\u4e0d\u80fd\u91cd\u590d\u53d1\u8d27", "cannot_repeat_shipment");
        }
        return supplierOrderItemList;
    }

    private List<SupplierOrderItem> getSupplierOrderItem(List<String> orderItemIdList) {
        SupplierOrderItemExample example = new SupplierOrderItemExample();
        SupplierOrderItemExample.Criteria criteria = example.createCriteria();
        criteria.andFinishFlagEqualTo("N").andIdIn((List)orderItemIdList);
        example.setOrderByClause("MATERIAL_CODE ASC");
        List<SupplierOrderItem> supplierOrderItemList = this.context.getSupplierOrderItemService().queryAllObjByExample(example);
        return supplierOrderItemList;
    }

    private void isSameType(List<SupplierOrderItem> supplierOrderItemList) {
        HashSet<String> orderIdList = new HashSet<String>();
        for (SupplierOrderItem item : supplierOrderItemList) {
            orderIdList.add(item.getOrderId());
        }
        if (!this.context.getSupplierOrderService().isSameType(orderIdList)) {
            throw new CommonException("\u5355\u636e\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u521b\u5efa\u5230\u540c\u4e00\u4e2a\u9001\u8d27\u5355");
        }
    }

    private void checkInterType(List<SupplierOrderItem> supplierOrderItemList) {
        String interType = null;
        for (int i = 0; CollectionUtils.isNotEmpty(supplierOrderItemList) && i < supplierOrderItemList.size(); ++i) {
            SupplierOrderItem supplierOrderItem = supplierOrderItemList.get(i);
            if (interType == null) {
                interType = supplierOrderItem.getInterType();
                continue;
            }
            if (supplierOrderItem.getInterType() == null || interType.equals(supplierOrderItem.getInterType())) continue;
            throw new CommonException("\u8f6c\u5382\u8ba2\u5355\u4e0e\u975e\u8f6c\u5382\u8ba2\u5355\u4e0d\u53ef\u521b\u5efa\u5728\u540c\u4e00\u5f20\u9001\u8d27\u5355\u4e2d", "cannot_create_the_same_deliveryOrder");
        }
    }

    private void checkInterTrade(List<SupplierOrderItem> supplierOrderItemList) {
        String interTradeCode = null;
        for (int i = 0; CollectionUtils.isNotEmpty(supplierOrderItemList) && i < supplierOrderItemList.size(); ++i) {
            SupplierOrderItem supplierOrderItem = supplierOrderItemList.get(i);
            if (interTradeCode == null) {
                interTradeCode = supplierOrderItem.getInterTradeCode();
                continue;
            }
            if (supplierOrderItem.getInterTradeCode() == null || interTradeCode.equals(supplierOrderItem.getInterTradeCode())) continue;
            throw new CommonException("\u56fd\u9645\u8d38\u6613\u6761\u6b3e\u4e0d\u4e00\u81f4\u7684\uff0c\u4e0d\u80fd\u4e00\u8d77\u9001\u8d27");
        }
    }

    private DeliveryOrderItem convertDeliveryOrderItem(SupplierOrderItem supplierOrderItem, SupplierOrder supplierOrder) {
        Assert.isNotNull(supplierOrder, "\u8ba2\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull(supplierOrderItem, "\u8ba2\u5355\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        DeliveryOrderItem deliveryOrderItem = new DeliveryOrderItem();
        BeanUtils.copyProperties((Object)supplierOrderItem, (Object)deliveryOrderItem);
        deliveryOrderItem.setId(null);
        if (!"Y".equals(supplierOrderItem.getFinishFlag())) {
            deliveryOrderItem.setCanDeliveryQuantity(new BigDecimal(supplierOrderItem.getDeliveryAmount()));
        } else {
            deliveryOrderItem.setCanDeliveryQuantity(BigDecimal.ZERO);
        }
        deliveryOrderItem.setPurCompanyId(supplierOrderItem.getPurCompanyId());
        deliveryOrderItem.setPurCompanyName(supplierOrderItem.getPurCompanyName());
        deliveryOrderItem.setPurCompanyCode(supplierOrderItem.getPurCompanyOcde());
        deliveryOrderItem.setCompanyId(supplierOrderItem.getCompanyId());
        deliveryOrderItem.setCompanyName(supplierOrderItem.getCompanyName());
        deliveryOrderItem.setCompanyCode(supplierOrder.getCompanySapCode());
        deliveryOrderItem.setPurOrderId(supplierOrder.getId());
        deliveryOrderItem.setPurOrderNo(supplierOrder.getOrderNo());
        deliveryOrderItem.setPurOrderItemId(supplierOrderItem.getId());
        deliveryOrderItem.setPurOrderItemNo(supplierOrderItem.getOrderItemNo());
        deliveryOrderItem.setExchangeRate(supplierOrder.getExchangeRate());
        deliveryOrderItem.setFactoryCode(supplierOrderItem.getFactory());
        deliveryOrderItem.setDeliveryDate(supplierOrderItem.getDeliveredDate());
        deliveryOrderItem.setOnwayQuantity(supplierOrderItem.getOnwayQuantity());
        deliveryOrderItem.setDeliveredQuantity(supplierOrderItem.getDeliveredQuantity());
        deliveryOrderItem.setTaxCode(supplierOrderItem.getSaleTaxCode());
        deliveryOrderItem.setTaxAmount(new BigDecimal(supplierOrderItem.getOrderValue()));
        deliveryOrderItem.setNoTaxAmount(supplierOrderItem.getNonTaxAmount());
        deliveryOrderItem.setTaxPrice(supplierOrderItem.getPrice());
        deliveryOrderItem.setMaterialDesc(supplierOrderItem.getMaterialName());
        deliveryOrderItem.setMaterialNo(supplierOrderItem.getMaterialCode());
        deliveryOrderItem.setSupplierMaterialNumber(supplierOrderItem.getSupMaterialCode());
        deliveryOrderItem.setDeliveryMaterialName(supplierOrderItem.getIndustryStandard());
        deliveryOrderItem.setDepartmentId(supplierOrderItem.getMaterialCategoryId());
        deliveryOrderItem.setDepartmentName(supplierOrderItem.getMaterialCategoryName());
        deliveryOrderItem.setWarehouseCode(supplierOrderItem.getWarehouseLocation());
        deliveryOrderItem.setWarehouseName(supplierOrderItem.getWarehouseName());
        deliveryOrderItem.setChineseName(supplierOrderItem.getIndustryStandard());
        deliveryOrderItem.setDeliveryStatus(DeliveryStatusEnum.UN_RECEIVED.getValue());
        deliveryOrderItem.setInterTradeCode(supplierOrderItem.getInterTradeCode());
        deliveryOrderItem.setInterTradeDesc(supplierOrderItem.getInterTradeDesc());
        BigDecimal receivedQuantity = supplierOrderItem.getReceivedQuantity();
        if (receivedQuantity != null) {
            deliveryOrderItem.setReceiptQuantity(receivedQuantity.toString());
        }
        return deliveryOrderItem;
    }

    private DeliveryOrderItem setSupplierMaterial(DeliveryOrderItem deliveryOrderItem, String materialVersion) {
        SupplierMaterialExample supplierMaterialExample = new SupplierMaterialExample();
        SupplierMaterialExample.Criteria cri = supplierMaterialExample.createCriteria().andProjectIdEqualTo(deliveryOrderItem.getProjectId()).andCompanySapCodeEqualTo(deliveryOrderItem.getCompanyCode()).andMaterialCodeEqualTo(deliveryOrderItem.getMaterialNo());
        if (StringUtils.isNotBlank((String)materialVersion)) {
            cri.andMaterialVersionEqualTo(materialVersion);
        }
        SupplierMaterial supplierMaterial = null;
        DeliveryPackage deliveryPackage = new DeliveryPackage();
        List supplierMaterialList = this.context.getSupplierMaterialService().queryAllObjByExample(supplierMaterialExample);
        if (CollectionUtils.isNotEmpty(supplierMaterialList)) {
            supplierMaterial = (SupplierMaterial)supplierMaterialList.get(0);
            deliveryOrderItem.setSupplierMaterialName(supplierMaterial.getSupplierMaterialDesc());
            deliveryOrderItem.setSupplierMaterialNumber(supplierMaterial.getSupplierMaterial());
            deliveryOrderItem.setBrand(supplierMaterial.getBrand());
            deliveryOrderItem.setModel(supplierMaterial.getSupModel());
            deliveryOrderItem.setSourceArea(supplierMaterial.getProductArea());
            deliveryPackage.setHeight(supplierMaterial.getHeight() == null ? BigDecimal.ZERO : supplierMaterial.getHeight());
            deliveryPackage.setWidth(supplierMaterial.getWidth() == null ? BigDecimal.ZERO : supplierMaterial.getWidth());
            deliveryPackage.setLength(supplierMaterial.getLength() == null ? BigDecimal.ZERO : supplierMaterial.getLength());
            deliveryPackage.setGrossWeight(supplierMaterial.getGrossWeight() == null ? BigDecimal.ZERO : supplierMaterial.getGrossWeight());
            String volume = deliveryPackage.getHeight().multiply(deliveryPackage.getWidth()).multiply(deliveryPackage.getLength()).divide(new BigDecimal("1000000")).toString();
            deliveryPackage.setVolume(volume);
        } else {
            deliveryPackage.setHeight(BigDecimal.ZERO);
            deliveryPackage.setWidth(BigDecimal.ZERO);
            deliveryPackage.setLength(BigDecimal.ZERO);
            deliveryPackage.setGrossWeight(BigDecimal.ZERO);
            deliveryPackage.setVolume("0");
        }
        MaterialExample materialExample = new MaterialExample();
        materialExample.createCriteria().andMaterialCodeEqualTo(deliveryOrderItem.getMaterialNo());
        List materialList = this.context.getMaterialService().queryAllObjByExample(materialExample);
        if (CollectionUtils.isNotEmpty(materialList) && StringUtils.isNotBlank((String)((Material)materialList.get(0)).getWeight())) {
            deliveryOrderItem.setSingleWeight(new BigDecimal(((Material)materialList.get(0)).getWeight()));
        }
        ArrayList<DeliveryPackage> list = new ArrayList<DeliveryPackage>(1);
        list.add(deliveryPackage);
        deliveryOrderItem.setDeliveryPackageLists(list);
        if (this.context.getMaterialService().isJTL(deliveryOrderItem.getMaterialNo())) {
            deliveryOrderItem.setRemark("JIT");
        }
        return deliveryOrderItem;
    }
}

