/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command.delivery;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.purchase.command.AbstractOrderCommand;
import com.els.base.purchase.command.OrderComandInvoker;
import com.els.base.purchase.command.delivery.CreateCommand;
import com.els.base.purchase.command.delivery.ModifyCommand;
import com.els.base.purchase.entity.DeliveryOrder;
import com.els.base.purchase.entity.DeliveryOrderItem;
import com.els.base.purchase.utils.DeliverOrderComparator;
import com.els.base.purchase.utils.DeliveryTypeEnum;
import com.els.base.purchase.utils.HKStatusEnum;
import java.util.Collections;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class SaveCommand
extends AbstractOrderCommand<String> {
    private DeliveryOrder deliveryOrder;

    public SaveCommand(DeliveryOrder deliveryOrder) {
        this.deliveryOrder = deliveryOrder;
    }

    @Override
    public String execute(OrderComandInvoker context) {
        this.context = context;
        this.valid(this.deliveryOrder);
        Collections.sort(this.deliveryOrder.getItems(), new DeliverOrderComparator());
        this.deliveryOrder.setIsEnable(Constant.YES_INT);
        this.deliveryOrder.setIsHk(HKStatusEnum.UN_HK.getValue());
        this.deliveryOrder.setType(DeliveryTypeEnum.DELIVERY.getValue());
        if (StringUtils.isNotBlank((String)this.deliveryOrder.getId())) {
            context.invoke(new ModifyCommand(this.deliveryOrder));
        } else {
            context.invoke(new CreateCommand(this.deliveryOrder));
        }
        return null;
    }

    private void valid(DeliveryOrder deliveryOrder) {
        if (deliveryOrder == null) {
            throw new CommonException("\u53d1\u8d27\u5355\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "do_not_exists", "\u53d1\u8d27\u5355\u6570\u636e");
        }
        if (CollectionUtils.isEmpty(deliveryOrder.getItems())) {
            throw new CommonException("\u884c\u6570\u636e\u4e0d\u5b58\u5728", "do_not_exists", "\u884c\u6570\u636e");
        }
        for (DeliveryOrderItem deliveryOrderItem : deliveryOrder.getItems()) {
            String purchaseOrderItemId = deliveryOrderItem.getPurOrderItemId();
            if (StringUtils.isBlank((String)purchaseOrderItemId)) {
                throw new CommonException("\u53c2\u6570\u5f02\u5e38\uff0c\u9001\u8d27\u5355\u884c\u4e2d\uff0c\u7f3a\u5c11\u91c7\u8d2d\u8ba2\u5355\u884cid");
            }
            if (StringUtils.isBlank((String)deliveryOrderItem.getPackQuantity())) {
                deliveryOrderItem.setPackQuantity("0");
            }
            if (!(deliveryOrderItem.getChineseName() != null && deliveryOrderItem.getChineseName().length() > 255 || deliveryOrderItem.getRemark() != null && deliveryOrderItem.getRemark().length() > 255 || deliveryOrderItem.getBrand() != null && deliveryOrderItem.getBrand().length() > 255 || deliveryOrderItem.getSourceArea() != null && deliveryOrderItem.getSourceArea().length() > 255 || deliveryOrderItem.getModel() != null && deliveryOrderItem.getModel().length() > 255) && (deliveryOrderItem.getCaseNo() == null || deliveryOrderItem.getCaseNo().length() <= 30)) continue;
            throw new CommonException("\u53c2\u6570\u957f\u5ea6\u8d85\u6807", "database_length_error");
        }
    }
}

