/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command.delivery;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.purchase.command.AbstractOrderCommand;
import com.els.base.purchase.command.OrderComandInvoker;
import com.els.base.purchase.command.delivery.CreateCommand;
import com.els.base.purchase.entity.DeliveryOrder;
import com.els.base.purchase.entity.DeliveryOrderItem;
import com.els.base.purchase.entity.DeliveryOrderItemExample;
import com.els.base.purchase.entity.SupplierOrderItem;
import com.els.base.purchase.utils.DeliveryStatusEnum;
import com.els.base.purchase.utils.HKStatusEnum;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class SendCommand
extends AbstractOrderCommand<String> {
    private DeliveryOrder deliveryOrder;

    public SendCommand(DeliveryOrder deliveryOrder) {
        this.deliveryOrder = deliveryOrder;
    }

    @Override
    public String execute(OrderComandInvoker context) {
        this.valid();
        this.init();
        if (StringUtils.isBlank((String)this.deliveryOrder.getId())) {
            context.invoke(new CreateCommand(this.deliveryOrder));
        }
        DeliveryOrderItemExample deliveryOrderItemExample = new DeliveryOrderItemExample();
        deliveryOrderItemExample.createCriteria().andDeliveryOrderIdEqualTo(this.deliveryOrder.getId());
        DeliveryOrderItem tmpItem = new DeliveryOrderItem();
        tmpItem.setDeliveryStatus(DeliveryStatusEnum.ONWAY.getValue());
        context.getDeliveryOrderItemService().updateDeliveryOrderItem(tmpItem, deliveryOrderItemExample);
        this.deliveryOrder.setDeliveryDate(new Date());
        this.deliveryOrder.setDeliveryStatus(DeliveryStatusEnum.ONWAY.getValue());
        context.getDeliveryOrderService().modifyAndAddHis(this.deliveryOrder, "\u53d1\u9001\u53d1\u8d27\u5355");
        return null;
    }

    private void init() {
        if (this.getSupCompany() != null) {
            this.deliveryOrder.setCompanyCode(this.getSupCompany().getCompanySapCode());
            this.deliveryOrder.setProjectId(this.getSupCompany().getProjectId());
            this.deliveryOrder.setCompanyId(this.getSupCompany().getId());
        }
        if (this.getSupUser() != null) {
            this.deliveryOrder.setUserId(this.getSupUser().getId());
            this.deliveryOrder.setUserName(this.getSupUser().getLoginName());
        }
        this.deliveryOrder.setIsHk(HKStatusEnum.UN_HK.getValue());
        this.deliveryOrder.setIsEnable(Constant.YES_INT);
    }

    private void valid() {
        if (this.deliveryOrder.getDeliveryStatus() != null && !DeliveryStatusEnum.UN_RECEIVED.getValue().equals(this.deliveryOrder.getDeliveryStatus())) {
            throw new CommonException("\u8be5\u53d1\u8d27\u5355\u5df2\u7ecf\u53d1\u8d27\uff0c\u4e0d\u80fd\u91cd\u590d\u53d1\u8d27", "cannot_repeat_shipment");
        }
        List<DeliveryOrderItem> items = this.deliveryOrder.getItems();
        if (CollectionUtils.isEmpty(items)) {
            items = this.context.getDeliveryOrderItemService().queryByDeliveryOrderId(this.deliveryOrder.getId());
            Assert.isNotEmpty(items, String.format("\u9001\u8d27\u5355[%s]\u7f3a\u5c11\u884c\u6570\u636e", this.deliveryOrder.getDeliveryOrderNo()));
            this.deliveryOrder.setItems(items);
        }
        for (DeliveryOrderItem item : this.deliveryOrder.getItems()) {
            SupplierOrderItem orderItem = (SupplierOrderItem)this.context.getSupplierOrderItemService().queryObjById(item.getPurOrderItemId());
            if (orderItem.getDeliveryAmount() >= 0L) continue;
            throw new CommonException("\u53d1\u8d27\u6570\u91cf\u5927\u4e8e\u53ef\u53d1\u8d27\u6570\u91cf\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u53ef\u53d1\u8d27\u6570\u91cf\uff08\u6709\u53ef\u80fd\u662f\u8be5\u91c7\u8d2d\u8ba2\u5355\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u754c\u9762\u91cd\u65b0\u8fdb\u5165\uff09\uff01", "delivery_gt_candelivery", "\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u53ef\u53d1\u8d27\u6570\u91cf\uff08\u6709\u53ef\u80fd\u662f\u8be5\u91c7\u8d2d\u8ba2\u5355\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u754c\u9762\u91cd\u65b0\u8fdb\u5165\uff09\uff01");
        }
    }
}

