/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command.order;

import com.els.base.core.utils.Assert;
import com.els.base.purchase.command.AbstractOrderCommand;
import com.els.base.purchase.command.OrderComandInvoker;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.SupplierOrderItem;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyOrderItemForDeliveryCmd
extends AbstractOrderCommand<String> {
    public static Logger logger = LoggerFactory.getLogger(ModifyOrderItemForDeliveryCmd.class);
    public static final String DELIVERY_ORDER_CANCEL = "DO_CANCEL";
    public static final String DELIVERY_ORDER_DELETE = "DO_DELETE";
    public static final String DELIVERY_ORDER_ADD = "DO_ADD";
    public static final String DELIVERY_ORDER_MODIFY = "DO_MODIFY";
    private String orderItemId;
    private String type;
    private BigDecimal quantity;

    public ModifyOrderItemForDeliveryCmd(String orderItemId, String type, BigDecimal quantity) {
        Assert.isNotBlank(orderItemId, "\u8ba2\u5355\u884cid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(type, "\u4fee\u6539\u8ba2\u5355\u7684\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull(quantity, "\u4fee\u6539\u8ba2\u5355\u7684\u7684\u6570\u91cf");
        this.orderItemId = orderItemId;
        this.type = type;
        this.quantity = quantity;
    }

    @Override
    public String execute(OrderComandInvoker context) {
        logger.info("\u4fee\u6539\u8ba2\u5355\u7684\u53ef\u53d1\u8d27\u6570\u91cf\uff0c\u64cd\u4f5c[{}], orderItemId[{}], \u53d8\u66f4\u6570\u91cf[{}]", new Object[]{this.type, this.orderItemId, this.quantity});
        PurchaseOrderItem purchaseOrderItem = (PurchaseOrderItem)context.getPurchaseOrderItemService().queryObjById(this.orderItemId);
        SupplierOrderItem supplierOrderItem = (SupplierOrderItem)context.getSupplierOrderItemService().queryObjById(this.orderItemId);
        switch (this.type) {
            case "DO_CANCEL": 
            case "DO_DELETE": {
                this.subtractQuantity(purchaseOrderItem, supplierOrderItem, this.quantity.multiply(new BigDecimal(-1)));
                return null;
            }
            case "DO_ADD": 
            case "DO_MODIFY": {
                this.subtractQuantity(purchaseOrderItem, supplierOrderItem, this.quantity);
                return null;
            }
        }
        if (BigDecimal.ZERO.compareTo(this.quantity) == 0) {
            return null;
        }
        return null;
    }

    private void subtractQuantity(PurchaseOrderItem purchaseOrderItem, SupplierOrderItem supplierOrderItem, BigDecimal quantity) {
        BigDecimal onwayQuantity = supplierOrderItem.getOnwayQuantity().add(quantity);
        BigDecimal deliveriedQuantity = supplierOrderItem.getDeliveredQuantity().add(quantity);
        BigDecimal freezeQuantity = supplierOrderItem.getFreezeQuantity();
        if (freezeQuantity == null) {
            freezeQuantity = BigDecimal.ZERO;
        }
        BigDecimal canDeliveryQuantity = supplierOrderItem.getQuantity().subtract(onwayQuantity).subtract(supplierOrderItem.getReceivedQuantity()).subtract(freezeQuantity);
        SupplierOrderItem tmp = new SupplierOrderItem();
        tmp.setId(this.orderItemId);
        tmp.setDeliveryAmount(canDeliveryQuantity.longValue());
        tmp.setOnwayQuantity(onwayQuantity);
        tmp.setDeliveredQuantity(deliveriedQuantity);
        tmp.setFinishFlag(canDeliveryQuantity.compareTo(BigDecimal.ZERO) <= 0 ? "Y" : "N");
        this.context.getSupplierOrderItemService().modifyObj(tmp);
        onwayQuantity = purchaseOrderItem.getOnwayQuantity().add(quantity);
        deliveriedQuantity = purchaseOrderItem.getDeliveredQuantity().add(quantity);
        freezeQuantity = purchaseOrderItem.getFreezeQuantity();
        if (freezeQuantity == null) {
            freezeQuantity = BigDecimal.ZERO;
        }
        canDeliveryQuantity = purchaseOrderItem.getQuantity().subtract(onwayQuantity).subtract(purchaseOrderItem.getReceivedQuantity()).subtract(freezeQuantity);
        PurchaseOrderItem tmpPurchaseOrderItem = new PurchaseOrderItem();
        tmpPurchaseOrderItem.setId(this.orderItemId);
        tmpPurchaseOrderItem.setDeliveryAmount(canDeliveryQuantity.longValue());
        tmpPurchaseOrderItem.setOnwayQuantity(onwayQuantity);
        tmpPurchaseOrderItem.setDeliveredQuantity(deliveriedQuantity);
        tmpPurchaseOrderItem.setFinishFlag(canDeliveryQuantity.compareTo(BigDecimal.ZERO) <= 0 ? "Y" : "N");
        this.context.getPurchaseOrderItemService().modifyObj(tmpPurchaseOrderItem);
    }
}

