/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command.order;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.purchase.command.AbstractOrderCommand;
import com.els.base.purchase.command.OrderComandInvoker;
import com.els.base.purchase.command.order.ConfirmTheWholeOrderCommand;
import com.els.base.purchase.command.order.RefuseTheWholeOrderCommand;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.SupplierOrder;
import com.els.base.purchase.entity.SupplierOrderItem;
import com.els.base.purchase.entity.SupplierOrderItemExample;
import com.els.base.purchase.utils.OrderBusinessTypeEnum;
import com.els.base.purchase.utils.PurchaseOrderStatusEnum;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class RefusePartOfOrderCommand
extends AbstractOrderCommand<String> {
    private SupplierOrder supplierOrder;

    public RefusePartOfOrderCommand(SupplierOrder order) {
        this.supplierOrder = order;
    }

    @Override
    public String execute(OrderComandInvoker context) {
        this.valid(this.supplierOrder);
        this.completeOrder(this.supplierOrder);
        if (PurchaseOrderStatusEnum.CONFIRM.getValue().equals(this.supplierOrder.getOrderStatus())) {
            ConfirmTheWholeOrderCommand cmd = new ConfirmTheWholeOrderCommand(this.supplierOrder);
            cmd.copyProperties(this);
            context.invoke(cmd);
        } else if (PurchaseOrderStatusEnum.BACK.getValue().equals(this.supplierOrder.getOrderStatus())) {
            RefuseTheWholeOrderCommand cmd = new RefuseTheWholeOrderCommand(this.supplierOrder);
            cmd.copyProperties(this);
            context.invoke(cmd);
        } else if (PurchaseOrderStatusEnum.PART_BACK.getValue().equals(this.supplierOrder.getOrderStatus())) {
            this.handlerPartRefuseOrder(this.supplierOrder);
        }
        return null;
    }

    private void completeOrder(SupplierOrder supplierOrder) {
        int confirmItemCount = 0;
        Integer orderStatus = null;
        for (SupplierOrderItem item : supplierOrder.getItems()) {
            if (PurchaseOrderStatusEnum.CONFIRM.getValue().equals(item.getOrderStatus())) {
                ++confirmItemCount;
            }
            item.setUpdateTime(new Date());
            item.setUserId(this.getSupUser().getId());
            item.setUserName(this.getSupUser().getNickName());
        }
        if (confirmItemCount == 0) {
            orderStatus = PurchaseOrderStatusEnum.BACK.getValue();
        } else if (confirmItemCount == supplierOrder.getItems().size()) {
            orderStatus = PurchaseOrderStatusEnum.CONFIRM.getValue();
        } else if (confirmItemCount < supplierOrder.getItems().size()) {
            orderStatus = PurchaseOrderStatusEnum.PART_BACK.getValue();
        }
        supplierOrder.setOrderStatus(orderStatus);
        supplierOrder.setUserId(this.getSupUser().getId());
        supplierOrder.setUserName(this.getSupUser().getNickName());
        supplierOrder.setLastUpdateTime(new Date());
    }

    private void handlerPartRefuseOrder(SupplierOrder supplierOrder) {
        String orderHisId = this.context.getPurchaseOrderService().insertHis(supplierOrder.getId(), "\u8ba2\u5355\u5934\u90e8\u5206\u62d2\u7edd");
        this.context.getPurchaseOrderItemService().insertHisByOrderId(orderHisId, supplierOrder.getId(), "\u8ba2\u5355\u5934\u90e8\u5206\u62d2\u7edd");
        for (SupplierOrderItem supplierOrderItem : supplierOrder.getItems()) {
            if (PurchaseOrderStatusEnum.CONFIRM.getValue().equals(supplierOrderItem.getOrderStatus())) {
                this.context.getSupplierOrderItemService().modifyObj(supplierOrderItem);
                continue;
            }
            SupplierOrderItem hisItem = this.queryHisItem(supplierOrderItem.getId());
            if (hisItem != null) {
                hisItem.setSupRemark(supplierOrderItem.getSupRemark());
                hisItem.setPurRemark(supplierOrderItem.getPurRemark());
                supplierOrderItem = hisItem;
            }
            supplierOrderItem.setUpdateTime(new Date());
            supplierOrderItem.setUserId(this.getSupUser().getId());
            supplierOrderItem.setUserName(this.getSupUser().getNickName());
            supplierOrderItem.setUpdateTime(new Date());
            this.context.getSupplierOrderItemService().modifyObj(supplierOrderItem);
        }
        supplierOrder.setUserId(this.getSupUser().getId());
        supplierOrder.setUserName(this.getSupUser().getNickName());
        supplierOrder.setLastUpdateTime(new Date());
        supplierOrder.setOrderStatus(PurchaseOrderStatusEnum.PART_BACK.getValue());
        this.context.getSupplierOrderService().modifyObj(supplierOrder);
        this.modifyPurchaseOrderAndItemsStatus(supplierOrder);
        this.sendMessage();
    }

    private void sendMessage() {
        Message message = Message.init((Object)this.supplierOrder).setCompanyCode(this.supplierOrder.getCompanySapCode()).setSenderId(this.supplierOrder.getUserId()).addReceiverId(this.supplierOrder.getPurUserId()).setMsgLevel(MessageLevelEnum.HIGH).setBusinessTypeCode(OrderBusinessTypeEnum.PO_PART_BACK.getCode());
        MessageSendUtils.sendMessage((Message)message);
    }

    private SupplierOrderItem queryHisItem(String id) {
        SupplierOrderItemExample example = new SupplierOrderItemExample();
        example.createCriteria().andIdEqualTo(id).andOrderStatusEqualTo(PurchaseOrderStatusEnum.CONFIRM.getValue());
        example.setOrderByClause("UPDATE_TIME DESC");
        PageView<SupplierOrderItem> pageView = this.context.getSupplierOrderItemService().queryAllHisOrderItemByExample(example);
        if (pageView == null || CollectionUtils.isEmpty(pageView.getQueryResult())) {
            return null;
        }
        return pageView.getQueryResult().get(0);
    }

    private void modifyPurchaseOrderAndItemsStatus(SupplierOrder supplierOrder) {
        String orderHisId = this.context.getPurchaseOrderService().insertHis(supplierOrder.getId(), "\u8ba2\u5355\u5934\u90e8\u5206\u62d2\u7edd");
        this.context.getPurchaseOrderItemService().insertHisByOrderId(orderHisId, supplierOrder.getId(), "\u8ba2\u5355\u5934\u90e8\u5206\u62d2\u7edd");
        PurchaseOrder record = new PurchaseOrder();
        record.setId(supplierOrder.getId());
        record.setSupRemark(supplierOrder.getSupRemark());
        record.setOrderStatus(PurchaseOrderStatusEnum.PART_BACK.getValue());
        record.setSupUserId(this.getSupUser().getId());
        record.setSupUserName(this.getSupUser().getNickName());
        record.setLastUpdateTime(new Date());
        this.context.getPurchaseOrderService().modifyObj(record);
        List<SupplierOrderItem> supplierOrderItems = supplierOrder.getItems();
        for (SupplierOrderItem supplierOrderItem : supplierOrderItems) {
            PurchaseOrderItem recordItem = new PurchaseOrderItem();
            recordItem.setId(supplierOrderItem.getId());
            recordItem.setSupRemark(supplierOrderItem.getSupRemark());
            recordItem.setOrderStatus(supplierOrderItem.getOrderStatus());
            recordItem.setSupUserId(this.getSupUser().getId());
            recordItem.setSupUserName(this.getSupUser().getNickName());
            recordItem.setUpdateTime(new Date());
            this.context.getPurchaseOrderItemService().modifyObj(recordItem);
        }
    }

    private void valid(SupplierOrder order) {
        Assert.isNotNull(order, "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        if (order.getSupRemark() != null && order.getSupRemark().length() > 255) {
            throw new CommonException("\u8f93\u5165\u7684\u53c2\u6570\u957f\u5ea6\u8d85\u6807", "database_length_error");
        }
        if (CollectionUtils.isEmpty(this.supplierOrder.getItems())) {
            throw new CommonException("\u884c\u6570\u636e\u4e0d\u5b58\u5728", "do_not_exists", "\u884c\u6570\u636e");
        }
        for (SupplierOrderItem item : order.getItems()) {
            Assert.isNotBlank(item.getId(), "\u8ba2\u5355\u884cid\u4e0d\u80fd\u4e3a\u7a7a");
            if (PurchaseOrderStatusEnum.CONFIRM.getValue().equals(item.getOrderStatus()) || PurchaseOrderStatusEnum.BACK.getValue().equals(item.getOrderStatus())) continue;
            throw new CommonException("\u8ba2\u5355\u884c\u7684\u786e\u8ba4\u5f02\u5e38\uff0c\u65e2\u4e0d\u662f\u786e\u8ba4\uff0c\u4e5f\u4e0d\u662f\u62d2\u7edd");
        }
        this.context.getSupplierOrderService().isHaveNewOrder(order);
    }
}

