/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command.order;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.purchase.command.AbstractOrderCommand;
import com.els.base.purchase.command.OrderComandInvoker;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.PurchaseOrderItemExample;
import com.els.base.purchase.entity.SupplierOrder;
import com.els.base.purchase.entity.SupplierOrderExample;
import com.els.base.purchase.entity.SupplierOrderItem;
import com.els.base.purchase.entity.SupplierOrderItemExample;
import com.els.base.purchase.utils.OrderBusinessTypeEnum;
import com.els.base.purchase.utils.PurchaseOrderStatusEnum;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class RefuseTheWholeOrderCommand
extends AbstractOrderCommand<String> {
    private SupplierOrder supplierOrder;

    public RefuseTheWholeOrderCommand(SupplierOrder order) {
        this.supplierOrder = order;
    }

    @Override
    public String execute(OrderComandInvoker context) {
        this.valid(this.supplierOrder);
        try {
            this.modifySupplierOrder(this.supplierOrder);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new CommonException(e);
        }
        this.modifyPurchaseOrderAndItemsStatus(this.supplierOrder);
        this.sendMessage();
        return null;
    }

    private void sendMessage() {
        Message message = Message.init((Object)this.supplierOrder).setCompanyCode(this.supplierOrder.getCompanySapCode()).setSenderId(this.supplierOrder.getUserId()).addReceiverId(this.supplierOrder.getPurUserId()).setMsgLevel(MessageLevelEnum.HIGH).setBusinessTypeCode(OrderBusinessTypeEnum.PO_ALL_BACK.getCode());
        MessageSendUtils.sendMessage((Message)message);
    }

    private void modifySupplierOrder(SupplierOrder supplierOrder) throws IllegalAccessException, InvocationTargetException {
        SupplierOrderItemExample exampleItem = new SupplierOrderItemExample();
        exampleItem.createCriteria().andCompanyIdEqualTo(supplierOrder.getCompanyId()).andOrderIdEqualTo(supplierOrder.getId());
        List<SupplierOrderItem> supplierOrderItems = supplierOrder.getItems();
        if (CollectionUtils.isEmpty(supplierOrderItems)) {
            supplierOrderItems = this.context.getSupplierOrderItemService().queryAllObjByExample(exampleItem);
        }
        for (SupplierOrderItem supplierOrderItem : supplierOrderItems) {
            SupplierOrderItem tempItem = new SupplierOrderItem();
            SupplierOrderItem hisItem = this.queryHisItem(supplierOrderItem.getId());
            if (hisItem != null) {
                tempItem = hisItem;
            }
            tempItem.setId(supplierOrderItem.getId());
            tempItem.setUserId(this.getSupUser().getId());
            tempItem.setUserName(this.getSupUser().getNickName());
            tempItem.setUpdateTime(new Date());
            tempItem.setSupRemark(supplierOrderItem.getSupRemark());
            this.context.getSupplierOrderItemService().modifyObj(tempItem);
        }
        SupplierOrder record = new SupplierOrder();
        SupplierOrder hisOrder = this.queryHisOrder(supplierOrder.getId());
        if (hisOrder != null) {
            record = hisOrder;
        }
        record.setId(supplierOrder.getId());
        record.setSupRemark(supplierOrder.getSupRemark());
        record.setOrderStatus(PurchaseOrderStatusEnum.BACK.getValue());
        record.setUserId(this.getSupUser().getId());
        record.setUserName(this.getSupUser().getNickName());
        record.setLastUpdateTime(new Date());
        this.context.getSupplierOrderService().modifyObj(record);
    }

    private SupplierOrder queryHisOrder(String id) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        values.add(PurchaseOrderStatusEnum.CONFIRM.getValue());
        values.add(PurchaseOrderStatusEnum.PART_BACK.getValue());
        SupplierOrderExample example = new SupplierOrderExample();
        example.createCriteria().andIdEqualTo(id).andOrderStatusIn(values);
        example.setOrderByClause("LAST_UPDATE_TIME DESC");
        PageView<SupplierOrder> pageView = this.context.getSupplierOrderService().queryAllHisOrderByExample(example);
        if (pageView == null || CollectionUtils.isEmpty(pageView.getQueryResult())) {
            return null;
        }
        return pageView.getQueryResult().get(0);
    }

    private SupplierOrderItem queryHisItem(String id) {
        SupplierOrderItemExample example = new SupplierOrderItemExample();
        example.createCriteria().andIdEqualTo(id).andOrderStatusEqualTo(PurchaseOrderStatusEnum.CONFIRM.getValue());
        example.setOrderByClause("UPDATE_TIME DESC");
        PageView<SupplierOrderItem> pageView = this.context.getSupplierOrderItemService().queryAllHisOrderItemByExample(example);
        if (pageView == null || CollectionUtils.isEmpty(pageView.getQueryResult())) {
            return null;
        }
        return pageView.getQueryResult().get(0);
    }

    private void modifyPurchaseOrderAndItemsStatus(SupplierOrder supplierOrder) {
        String orderHisId = this.context.getPurchaseOrderService().insertHis(supplierOrder.getId(), "\u8ba2\u5355\u5934\u62d2\u7edd");
        this.context.getPurchaseOrderItemService().insertHisByOrderId(orderHisId, supplierOrder.getId(), "\u8ba2\u5355\u5934\u62d2\u7edd");
        PurchaseOrder record = new PurchaseOrder();
        record.setId(supplierOrder.getId());
        record.setSupRemark(supplierOrder.getSupRemark());
        record.setOrderStatus(PurchaseOrderStatusEnum.BACK.getValue());
        record.setLastUpdateTime(new Date());
        record.setSupUserId(this.getSupUser().getId());
        record.setSupUserName(this.getSupUser().getNickName());
        this.context.getPurchaseOrderService().modifyObj(record);
        if (CollectionUtils.isEmpty(supplierOrder.getItems())) {
            PurchaseOrderItem recordItem = new PurchaseOrderItem();
            recordItem.setSupRemark(supplierOrder.getSupRemark());
            recordItem.setOrderStatus(PurchaseOrderStatusEnum.BACK.getValue());
            recordItem.setSupUserId(this.getSupUser().getId());
            recordItem.setSupUserName(this.getSupUser().getNickName());
            recordItem.setUpdateTime(new Date());
            PurchaseOrderItemExample example = new PurchaseOrderItemExample();
            example.createCriteria().andOrderIdEqualTo(supplierOrder.getId());
            this.context.getPurchaseOrderItemService().updateByPurcahseOrder(recordItem, example);
            return;
        }
        for (SupplierOrderItem item : supplierOrder.getItems()) {
            PurchaseOrderItem recordItem = new PurchaseOrderItem();
            recordItem.setSupRemark(item.getSupRemark());
            recordItem.setOrderStatus(PurchaseOrderStatusEnum.BACK.getValue());
            recordItem.setSupUserId(this.getSupUser().getId());
            recordItem.setSupUserName(this.getSupUser().getNickName());
            recordItem.setUpdateTime(new Date());
            recordItem.setId(item.getId());
            this.context.getPurchaseOrderItemService().modifyObj(recordItem);
        }
    }

    private void valid(SupplierOrder order) {
        if (order.getSupRemark() != null && order.getSupRemark().length() > 255) {
            throw new CommonException("\u8f93\u5165\u7684\u53c2\u6570\u957f\u5ea6\u8d85\u6807", "database_length_error");
        }
        if (CollectionUtils.isNotEmpty(order.getItems())) {
            for (SupplierOrderItem item : order.getItems()) {
                Assert.isNotBlank(item.getId(), "\u8ba2\u5355\u884cID\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        this.context.getSupplierOrderService().isHaveNewOrder(order);
    }
}

