/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command.order;

import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.purchase.command.AbstractOrderCommand;
import com.els.base.purchase.command.OrderComandInvoker;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.PurchaseOrderItemExample;
import com.els.base.purchase.entity.SupplierOrder;
import com.els.base.purchase.entity.SupplierOrderItem;
import com.els.base.purchase.utils.OrderBusinessTypeEnum;
import com.els.base.purchase.utils.PurchaseOrderSendStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderStatusEnum;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;

public class SendOrderCommand
extends AbstractOrderCommand<String> {
    private PurchaseOrder order;

    public SendOrderCommand(PurchaseOrder order) {
        this.order = order;
    }

    @Override
    public String execute(OrderComandInvoker context) {
        this.valid(this.order);
        this.init(this.order);
        this.updateOrder(this.order);
        this.sendToSupCompany(this.order);
        this.sendMsg(this.order);
        return null;
    }

    private void sendToSupCompany(PurchaseOrder order) {
        SupplierOrder supOrder = (SupplierOrder)this.context.getSupplierOrderService().queryObjById(order.getId());
        if (supOrder == null) {
            this.addNewSupplierOrder(order);
        } else {
            this.modifyOldSupplierOrder(order);
        }
    }

    private void modifyOldSupplierOrder(PurchaseOrder order) {
        String orderHisId = this.context.getSupplierOrderService().insertHis(order.getId(), "\u53d1\u9001\u53d8\u66f4\u7684\u91c7\u8d2d\u8ba2\u5355");
        this.context.getSupplierOrderItemService().insertHisByOrderId(orderHisId, order.getId(), "\u53d1\u9001\u53d8\u66f4\u7684\u91c7\u8d2d\u8ba2\u5355");
        SupplierOrder supOrder = this.createSupplierOrder(order);
        this.context.getSupplierOrderService().modifyObj(supOrder);
        for (PurchaseOrderItem purOrderItem : order.getItems()) {
            SupplierOrderItem supplierOrderItem = this.createSupplierOrderItem(purOrderItem, supOrder);
            SupplierOrderItem temp = (SupplierOrderItem)this.context.getSupplierOrderItemService().queryObjById(supplierOrderItem.getId());
            if (temp == null) {
                this.context.getSupplierOrderItemService().addObj(supplierOrderItem);
                continue;
            }
            this.context.getSupplierOrderItemService().modifyObj(supplierOrderItem);
        }
    }

    private void addNewSupplierOrder(PurchaseOrder order) {
        SupplierOrder supOrder = this.createSupplierOrder(order);
        this.context.getSupplierOrderService().addObj(supOrder);
        for (PurchaseOrderItem purOrderItem : order.getItems()) {
            SupplierOrderItem supplierOrderItem = this.createSupplierOrderItem(purOrderItem, supOrder);
            this.context.getSupplierOrderItemService().addObj(supplierOrderItem);
        }
    }

    private void sendMsg(PurchaseOrder purchaseOrder) {
        Message msg = Message.init((Object)purchaseOrder).setCompanyCode(purchaseOrder.getCompanyCode()).setBusinessTypeCode(OrderBusinessTypeEnum.PO_NEW_SEND.getCode()).setSenderId(purchaseOrder.getUserId()).addReceiverId(purchaseOrder.getSupUserId()).setMsgLevel(MessageLevelEnum.HIGH);
        MessageSendUtils.sendMessage((Message)msg);
    }

    private SupplierOrder createSupplierOrder(PurchaseOrder purOrder) {
        SupplierOrder supOrder = new SupplierOrder();
        Date now = new Date();
        BeanUtils.copyProperties((Object)purOrder, (Object)supOrder);
        supOrder.setUserId(purOrder.getSupUserId());
        supOrder.setUserName(purOrder.getSupUserName());
        supOrder.setCompanyId(purOrder.getSupCompanyId());
        supOrder.setCompanySapCode(purOrder.getSupCompanySapCode());
        supOrder.setCompanyName(purOrder.getSupCompanyName());
        supOrder.setPurUserId(purOrder.getUserId());
        supOrder.setPurUserName(purOrder.getUserName());
        supOrder.setPurCompanyId(purOrder.getCompanyId());
        supOrder.setPurCompanyCode(purOrder.getCompanyCode());
        supOrder.setPurCompanyName(purOrder.getCompanyName());
        supOrder.setCreateTime(now);
        supOrder.setLastUpdateTime(now);
        return supOrder;
    }

    private SupplierOrderItem createSupplierOrderItem(PurchaseOrderItem purOrderItem, SupplierOrder supOrder) {
        SupplierOrderItem supplierOrderItem = new SupplierOrderItem();
        BeanUtils.copyProperties((Object)purOrderItem, (Object)supplierOrderItem);
        supplierOrderItem.setUserId(supOrder.getUserId());
        supplierOrderItem.setUserName(supOrder.getUserName());
        supplierOrderItem.setCompanyId(supOrder.getCompanyId());
        supplierOrderItem.setCompanyName(supOrder.getCompanyName());
        supplierOrderItem.setPurUserId(supOrder.getPurUserId());
        supplierOrderItem.setPurUserName(supOrder.getPurUserName());
        supplierOrderItem.setPurCompanyId(supOrder.getPurCompanyId());
        supplierOrderItem.setPurCompanyName(supOrder.getPurCompanyName());
        supplierOrderItem.setSapSupCompanyCode(supOrder.getCompanySapCode());
        supplierOrderItem.setUpdateTime(supOrder.getLastUpdateTime());
        return supplierOrderItem;
    }

    private void updateOrder(PurchaseOrder order) {
        this.context.getPurchaseOrderService().modifyObj(order);
        for (PurchaseOrderItem orderItem : order.getItems()) {
            this.context.getPurchaseOrderItemService().modifyObj(orderItem);
        }
    }

    private void init(PurchaseOrder order) {
        order.setUserId(this.getPurUser().getId());
        order.setUserName(this.getPurUser().getNickName());
        order.setSendTime(new Date());
        order.setOrderStatus(PurchaseOrderStatusEnum.UNCONFIRM.getValue());
        if (StringUtils.isNotBlank((String)order.getSupCompanyId())) {
            User user = this.context.getCompanyUserRefService().queryMainUserOfCompany(order.getSupCompanyId());
            order.setSupUserId(user != null ? user.getId() : null);
            order.setSupUserName(user != null ? user.getNickName() : null);
        }
        if (PurchaseOrderSendStatusEnum.UPDATE_NOTSEND.getValue().equals(order.getOrderSendStatus()) || PurchaseOrderSendStatusEnum.UPDATE_SENDED.getValue().equals(order.getOrderSendStatus())) {
            order.setOrderSendStatus(PurchaseOrderSendStatusEnum.UPDATE_SENDED.getValue());
        } else {
            order.setOrderSendStatus(PurchaseOrderSendStatusEnum.SENDED.getValue());
        }
        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        example.createCriteria().andOrderNoEqualTo(order.getOrderNo()).andSupCompanyIdEqualTo(order.getSupCompanyId());
        List<PurchaseOrderItem> items = this.context.getPurchaseOrderItemService().queryAllObjByExample(example);
        Assert.isNotEmpty(items, String.format("\u8ba2\u5355[%s]\u884c\u4e0d\u5b58\u5728", order.getOrderNo()));
        for (PurchaseOrderItem purchaseOrderItem : items) {
            purchaseOrderItem.setPurUserId(order.getUserId());
            purchaseOrderItem.setPurUserName(order.getUserName());
            purchaseOrderItem.setSupUserId(order.getSupUserId());
            purchaseOrderItem.setSupUserName(order.getSupUserName());
            purchaseOrderItem.setOrderStatus(PurchaseOrderStatusEnum.UNCONFIRM.getValue());
        }
        order.setItems(items);
    }

    private void valid(PurchaseOrder order) {
        if ((PurchaseOrderSendStatusEnum.UPDATE_SENDED.getValue().equals(order.getOrderSendStatus()) || PurchaseOrderSendStatusEnum.SENDED.getValue().equals(order.getOrderSendStatus())) && !PurchaseOrderStatusEnum.BACK.getValue().equals(order.getOrderStatus()) && !PurchaseOrderStatusEnum.PART_BACK.getValue().equals(order.getOrderStatus())) {
            String errorMsg = String.format("\u91c7\u8d2d\u65b9\u8ba2\u5355[%s]\u5df2\u7ecf\u53d1\u9001,\u8bf7\u52ff\u91cd\u590d\u53d1\u9001", order.getOrderNo());
            throw new CommonException(errorMsg);
        }
    }
}

