/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.service.impl;

import com.els.base.company.service.CompanyAddressService;
import com.els.base.company.service.CompanyPurRefService;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.material.entity.SupplierMaterial;
import com.els.base.material.service.MaterialCodeService;
import com.els.base.material.service.MaterialSealService;
import com.els.base.material.service.MaterialService;
import com.els.base.material.service.SupplierMaterialService;
import com.els.base.material.utils.MaterailUtils;
import com.els.base.purchase.dao.DeliveryOrderMapper;
import com.els.base.purchase.entity.DeliveryOrder;
import com.els.base.purchase.entity.DeliveryOrderExample;
import com.els.base.purchase.entity.DeliveryOrderItem;
import com.els.base.purchase.entity.DeliveryOrderItemExample;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderExample;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.SupplierOrder;
import com.els.base.purchase.entity.SupplierOrderItem;
import com.els.base.purchase.service.DeliveryOrderItemService;
import com.els.base.purchase.service.DeliveryOrderService;
import com.els.base.purchase.service.DeliveryPackageService;
import com.els.base.purchase.service.PurchaseOrderItemService;
import com.els.base.purchase.service.PurchaseOrderService;
import com.els.base.purchase.service.SupplierOrderItemService;
import com.els.base.purchase.service.SupplierOrderService;
import com.els.base.purchase.utils.PurchaseOrderSendStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderStatusEnum;
import com.els.base.purchase.utils.SysUtil;
import com.els.base.utils.uuid.UUIDGenerator;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="deliveryOrderService")
public class DeliveryOrderServiceImpl
implements DeliveryOrderService {
    @Resource
    protected SupplierMaterialService supplierMaterialService;
    @Resource
    protected MaterialCodeService materialCodeService;
    @Resource
    protected DeliveryOrderMapper deliveryOrderMapper;
    @Resource
    protected DeliveryOrderItemService deliveryOrderItemService;
    @Resource
    protected SupplierOrderService supplierOrderService;
    @Resource
    protected PurchaseOrderService purchaseOrderHeaderService;
    @Resource
    protected SupplierOrderItemService supplierOrderItemService;
    @Resource
    protected PurchaseOrderItemService purchaseOrderItemService;
    @Resource
    protected MaterialSealService materialSealService;
    @Resource
    protected MaterialService materialService;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected CompanyPurRefService companyPurRefService;
    @Resource
    protected DeliveryPackageService deliveryPackageService;
    @Resource
    protected CompanyAddressService companyAddressService;

    @Override
    @CacheEvict(value={"deliveryOrder", "deliveryOrderItem"}, allEntries=true)
    public void addObj(DeliveryOrder deliveryOrder) {
        this.deliveryOrderMapper.insertSelective(deliveryOrder);
    }

    @Override
    @CacheEvict(value={"deliveryOrder"}, allEntries=true)
    public void deleteObjById(String id) {
        this.deliveryOrderMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"deliveryOrder"}, allEntries=true)
    public void modifyObj(DeliveryOrder t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.deliveryOrderMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    public DeliveryOrder queryObjById(String id) {
        return this.deliveryOrderMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"deliveryOrder"}, keyGenerator="redisKeyGenerator")
    public List<DeliveryOrder> queryAllObjByExample(DeliveryOrderExample example) {
        return this.deliveryOrderMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"deliveryOrder"}, keyGenerator="redisKeyGenerator")
    public PageView<DeliveryOrder> queryObjByPage(DeliveryOrderExample example) {
        PageView<DeliveryOrder> pageView = example.getPageView();
        pageView.setQueryResult(this.deliveryOrderMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"deliveryOrder"}, keyGenerator="redisKeyGenerator")
    public PageView<DeliveryOrder> queryHisObjByPage(DeliveryOrderExample example) {
        PageView<DeliveryOrder> pageView = example.getPageView();
        pageView.setQueryResult(this.deliveryOrderMapper.selectHisByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"deliveryOrder"}, keyGenerator="redisKeyGenerator")
    public PageView<DeliveryOrder> queryDeliveryOrderByPage(DeliveryOrderExample example) {
        PageView<DeliveryOrder> pageView = example.getPageView();
        List<DeliveryOrder> list = this.deliveryOrderMapper.selectByExampleByPage(example);
        if (CollectionUtils.isEmpty(list)) {
            return new PageView<DeliveryOrder>(1, pageView.getPageSize());
        }
        for (DeliveryOrder deliveryOrder : list) {
            DeliveryOrderItemExample exampleItem = new DeliveryOrderItemExample();
            DeliveryOrderItemExample.Criteria criteriaItem = exampleItem.createCriteria();
            criteriaItem.andDeliveryOrderIdEqualTo(deliveryOrder.getId());
            exampleItem.setOrderByClause("DELIVERY_ORDER_ITEM_NO ASC,MATERIAL_NO ASC ,DELIVERY_DATE DESC");
            List<DeliveryOrderItem> itemList = this.deliveryOrderItemService.queryAllObjByExample(exampleItem);
            if (CollectionUtils.isEmpty(itemList)) continue;
            for (DeliveryOrderItem deliveryOrderItem : itemList) {
                if (StringUtils.isNotBlank((String)deliveryOrderItem.getSupplierMaterialNumber()) && StringUtils.isNotBlank((String)deliveryOrderItem.getSupplierMaterialName())) continue;
                this.setSupplierMaterialCode(deliveryOrderItem);
            }
            deliveryOrder.setItems(itemList);
        }
        pageView.setQueryResult(list);
        return pageView;
    }

    private void setSupplierMaterialCode(DeliveryOrderItem deliveryOrderItem) {
        SupplierMaterial supplierMaterial = MaterailUtils.querySupplierMaterial(deliveryOrderItem.getCompanyId(), deliveryOrderItem.getCompanyCode(), deliveryOrderItem.getMaterialNo(), null);
        if (supplierMaterial == null) {
            return;
        }
        deliveryOrderItem.setSupplierMaterialName(supplierMaterial.getSupplierMaterialDesc());
        deliveryOrderItem.setSupplierMaterialNumber(supplierMaterial.getSupplierMaterial());
    }

    public void updatePurchaseOrderForDelivery(SupplierOrder supplierOrder) {
        List<SupplierOrderItem> items = supplierOrder.getItems();
        for (SupplierOrderItem supplierOrderItem : items) {
            PurchaseOrderItem purchaseOrderItemTemp = (PurchaseOrderItem)this.purchaseOrderItemService.queryObjById(supplierOrderItem.getId());
            PurchaseOrderItem record = new PurchaseOrderItem();
            record.setDeliveredQuantity(supplierOrderItem.getDeliveredQuantity());
            record.setOnwayQuantity(supplierOrderItem.getOnwayQuantity());
            record.setId(purchaseOrderItemTemp.getId());
            long deliveryAmount = SysUtil.getCanDeliveryAmount(purchaseOrderItemTemp.getQuantity(), supplierOrderItem.getOnwayQuantity(), supplierOrderItem.getReceivedQuantity(), supplierOrderItem.getFreezeQuantity());
            record.setDeliveryAmount(deliveryAmount);
            this.purchaseOrderItemService.modifyObj(record);
        }
    }

    public void isHaveNewOrder(String purchaseOrderNo, String supCompanyId) {
        PurchaseOrderExample example = new PurchaseOrderExample();
        PurchaseOrderExample.Criteria criteria = example.createCriteria();
        criteria.andOrderNoEqualTo(purchaseOrderNo);
        criteria.andSupCompanyIdEqualTo(supCompanyId);
        List purchaseOrders = this.purchaseOrderHeaderService.queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(purchaseOrders)) {
            throw new CommonException("\u6570\u636e\u5f02\u5e38\uff0c\u91c7\u8d2d\u8ba2\u5355[" + purchaseOrderNo + "]\uff0c\u5728\u91c7\u8d2d\u65b9\u4e0d\u5b58\u5728");
        }
        PurchaseOrder purchaseOrder = (PurchaseOrder)purchaseOrders.get(0);
        if (purchaseOrder != null && purchaseOrder.getOrderStatus() == PurchaseOrderStatusEnum.UNCONFIRM.getValue() && purchaseOrder.getOrderSendStatus() == PurchaseOrderSendStatusEnum.UPDATE_SENDED.getValue()) {
            throw new CommonException("\u91c7\u8d2d\u8ba2\u5355[" + purchaseOrderNo + "],\u5df2\u53d1\u5e03\u65b0\u8ba2\u5355\uff0c\u65e7\u8ba2\u5355\u4e0d\u53ef\u521b\u5efa\u9001\u8d27\u5355\uff0c\u8c22\u8c22");
        }
    }

    @Override
    public DeliveryOrder queryDeliveryOrderId(String deliveryOrderId) {
        DeliveryOrder deliveryOrder = this.deliveryOrderMapper.selectByPrimaryKey(deliveryOrderId);
        List<DeliveryOrderItem> items = this.deliveryOrderItemService.queryByDeliveryOrderId(deliveryOrderId);
        for (DeliveryOrderItem deliveryOrderItem : items) {
            SupplierOrderItem supplierOrderItem = (SupplierOrderItem)this.supplierOrderItemService.queryObjById(deliveryOrderItem.getPurOrderItemId());
            if (supplierOrderItem != null) {
                deliveryOrderItem.setQuantity(supplierOrderItem.getQuantity() == null ? BigDecimal.ZERO : supplierOrderItem.getQuantity());
                if (supplierOrderItem.getDeliveryAmount() != null) {
                    deliveryOrderItem.setCanDeliveryQuantity(new BigDecimal(supplierOrderItem.getDeliveryAmount()));
                }
                if (supplierOrderItem.getReceivedQuantity() != null) {
                    deliveryOrderItem.setReceiptQuantity(supplierOrderItem.getReceivedQuantity().toString());
                }
                if (supplierOrderItem.getOnwayQuantity() != null) {
                    deliveryOrderItem.setOnwayQuantity(supplierOrderItem.getOnwayQuantity());
                }
                deliveryOrderItem.setFreezeQuantity(supplierOrderItem.getFreezeQuantity() == null ? BigDecimal.ZERO : supplierOrderItem.getFreezeQuantity());
            }
            deliveryOrderItem.setDeliveryPackageLists(this.deliveryPackageService.queryByDeliveryOrderItemId(deliveryOrderItem.getId()));
        }
        deliveryOrder.setItems(items);
        return deliveryOrder;
    }

    @Override
    public void modifyAndAddHis(DeliveryOrder deliveryOrder, String string) {
        Assert.isNotNull(deliveryOrder, "\u9001\u8d27\u5355\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull(deliveryOrder.getId(), "\u9001\u8d27\u5355id\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Date date = new Date();
        this.deliveryOrderMapper.insertHis(UUIDGenerator.generateUUID(), deliveryOrder.getId(), "\u53d1\u9001\u53d1\u8d27\u5355", date);
        this.modifyObj(deliveryOrder);
    }

    @Override
    @Transactional
    public void deleteAndAddHis(String deliveryOrderId, String string) {
        Assert.isNotBlank(deliveryOrderId, "\u9001\u8d27\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        Date date = new Date();
        this.deliveryOrderMapper.insertHis(UUIDGenerator.generateUUID(), deliveryOrderId, "\u53d1\u9001\u53d1\u8d27\u5355", date);
        this.deliveryOrderMapper.deleteByPrimaryKey(deliveryOrderId);
    }
}

