/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.purchase.dao.DeliveryPackageMapper;
import com.els.base.purchase.entity.DeliveryOrderItem;
import com.els.base.purchase.entity.DeliveryPackage;
import com.els.base.purchase.entity.DeliveryPackageExample;
import com.els.base.purchase.service.DeliveryOrderItemService;
import com.els.base.purchase.service.DeliveryOrderService;
import com.els.base.purchase.service.DeliveryPackageService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="deliveryPackageService")
public class DeliveryPackageServiceImpl
implements DeliveryPackageService {
    @Resource
    protected DeliveryPackageMapper deliveryPackageMapper;
    @Resource
    protected DeliveryOrderService deliveryOrderService;
    @Resource
    protected DeliveryOrderItemService deliveryOrderItemService;

    @Override
    @CacheEvict(value={"deliveryPackage"}, allEntries=true)
    public void addObj(DeliveryPackage t) {
        this.deliveryPackageMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"deliveryPackage"}, allEntries=true)
    public void deleteObjById(String id) {
        this.deliveryPackageMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"deliveryPackage"}, allEntries=true)
    public void modifyObj(DeliveryPackage t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.deliveryPackageMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"deliveryPackage"}, keyGenerator="redisKeyGenerator")
    public DeliveryPackage queryObjById(String id) {
        return this.deliveryPackageMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<DeliveryPackage> queryAllObjByExample(DeliveryPackageExample example) {
        return this.deliveryPackageMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"deliveryPackage"}, keyGenerator="redisKeyGenerator")
    public PageView<DeliveryPackage> queryObjByPage(DeliveryPackageExample example) {
        PageView<DeliveryPackage> pageView = example.getPageView();
        pageView.setQueryResult(this.deliveryPackageMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"deliveryPackage"}, allEntries=true)
    @Transactional
    public void save(List<DeliveryPackage> deliveryPackageList) {
        if (CollectionUtils.isEmpty(deliveryPackageList)) {
            throw new CommonException("\u6ca1\u6709\u67e5\u8be2\u5230\u6570\u636e", "not_query_to_data");
        }
        DeliveryOrderItem temp = (DeliveryOrderItem)this.deliveryOrderItemService.queryObjById(deliveryPackageList.get(0).getDeliveryOrderItemId());
        if (temp == null) {
            throw new CommonException("\u884c\u6570\u636e\u4e0d\u5b58\u5728", "do_not_exists", "\u884c\u6570\u636e");
        }
        int packQuantity = 0;
        int totalQuantity = 0;
        for (DeliveryPackage deliveryPackage : deliveryPackageList) {
            String id = UUIDGenerator.generateUUID();
            deliveryPackage.setId(id);
            deliveryPackage.setCreateTime(new Date());
            if (deliveryPackage.getPackageQuantity() != null) {
                packQuantity += deliveryPackage.getPackageQuantity().intValue();
            }
            if (deliveryPackage.getTotalQuantity() == null) continue;
            totalQuantity += deliveryPackage.getTotalQuantity().intValue();
        }
        DeliveryPackageExample example = new DeliveryPackageExample();
        example.createCriteria().andDeliveryOrderItemIdEqualTo(deliveryPackageList.get(0).getDeliveryOrderItemId());
        this.deliveryPackageMapper.deleteByExample(example);
        DeliveryOrderItem deliveryOrderItem = new DeliveryOrderItem();
        deliveryOrderItem.setId(deliveryPackageList.get(0).getDeliveryOrderItemId());
        deliveryOrderItem.setPackQuantity(String.valueOf(packQuantity));
        this.deliveryOrderItemService.modifyObj(deliveryOrderItem);
        for (DeliveryPackage deliveryPackage : deliveryPackageList) {
            deliveryPackage.setId(null);
            this.deliveryPackageMapper.insert(deliveryPackage);
        }
    }

    @Override
    @CacheEvict(value={"deliveryPackage"}, allEntries=true)
    public void deleteByExample(DeliveryPackageExample deliveryPackageExample) {
        if (deliveryPackageExample == null || CollectionUtils.isEmpty(deliveryPackageExample.getOredCriteria())) {
            return;
        }
        this.deliveryPackageMapper.deleteByExample(deliveryPackageExample);
    }

    @Override
    @Cacheable(value={"deliveryPackage"}, keyGenerator="redisKeyGenerator")
    public List<DeliveryPackage> queryByDeliveryOrderItemId(String deliveryOrderItemId) {
        DeliveryPackageExample example = new DeliveryPackageExample();
        example.createCriteria().andDeliveryOrderItemIdEqualTo(deliveryOrderItemId);
        return this.deliveryPackageMapper.selectByExample(example);
    }
}

