/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.service.impl;

import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.material.entity.SupplierMaterial;
import com.els.base.material.entity.SupplierMaterialExample;
import com.els.base.material.service.SupplierMaterialService;
import com.els.base.purchase.dao.PurchaseOrderItemMapper;
import com.els.base.purchase.entity.PurchaseOrderExample;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.PurchaseOrderItemExample;
import com.els.base.purchase.service.PurchaseOrderItemService;
import com.els.base.purchase.utils.PurchaseOrderIsEnableEnum;
import com.els.base.purchase.utils.SysUtil;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="purchaseOrderItemService")
public class PurchaseOrderItemServiceImpl
implements PurchaseOrderItemService {
    @Resource
    protected SupplierMaterialService supplierMaterialService;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected PurchaseOrderItemMapper purchaseOrderItemMapper;

    @Override
    @CacheEvict(value={"purchaseOrderItem"}, allEntries=true)
    public void addObj(PurchaseOrderItem t) {
        this.purchaseOrderItemMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"purchaseOrderItem"}, allEntries=true)
    public void deleteObjById(String id) {
        PurchaseOrderItem item = new PurchaseOrderItem();
        item.setId(id);
        item.setIsEnable(PurchaseOrderIsEnableEnum.DELETED.getValue());
        this.purchaseOrderItemMapper.updateByPrimaryKeySelective(item);
    }

    @Override
    @CacheEvict(value={"purchaseOrderItem"}, allEntries=true)
    public void modifyObj(PurchaseOrderItem t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.purchaseOrderItemMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"purchaseOrderItem"}, keyGenerator="redisKeyGenerator")
    public PurchaseOrderItem queryObjById(String id) {
        return this.purchaseOrderItemMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"purchaseOrderItem"}, keyGenerator="redisKeyGenerator")
    public List<PurchaseOrderItem> queryAllObjByExample(PurchaseOrderItemExample example) {
        return this.purchaseOrderItemMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"purchaseOrderItem"}, keyGenerator="redisKeyGenerator")
    public PageView<PurchaseOrderItem> queryObjByPage(PurchaseOrderItemExample example) {
        PageView<PurchaseOrderItem> pageView = example.getPageView();
        List<PurchaseOrderItem> items = this.purchaseOrderItemMapper.selectByExampleByPage(example);
        for (PurchaseOrderItem purchaseOrderItem : items) {
            if ("Y".equals(purchaseOrderItem.getFinishFlag())) {
                purchaseOrderItem.setDeliveryAmount(0L);
                continue;
            }
            if (purchaseOrderItem.getDeliveryAmount() != null) continue;
            purchaseOrderItem.setDeliveryAmount(SysUtil.getCanDeliveryAmount(purchaseOrderItem.getQuantity(), purchaseOrderItem.getOnwayQuantity(), purchaseOrderItem.getReceivedQuantity(), purchaseOrderItem.getFreezeQuantity()));
        }
        pageView.setQueryResult(items);
        return pageView;
    }

    @Override
    @Cacheable(value={"purchaseOrderItem"}, keyGenerator="redisKeyGenerator")
    public PageView<PurchaseOrderItem> queryHisAllObjByExample(PurchaseOrderItemExample example) {
        PageView<PurchaseOrderItem> pageView = example.getPageView();
        pageView.setQueryResult(this.purchaseOrderItemMapper.selectHisByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"purchaseOrderItem"}, allEntries=true)
    public void deleteByOrderId(String orderId) {
        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        example.createCriteria().andOrderIdEqualTo(orderId);
        this.purchaseOrderItemMapper.deleteByExample(example);
    }

    @Override
    @CacheEvict(value={"purchaseOrderItem"}, allEntries=true)
    @Transactional
    public void insertHisByOrderId(String orderHisId, String orderId, String cause) {
        this.purchaseOrderItemMapper.insertHisByOrderId(orderHisId, orderId, cause);
    }

    @Override
    public PageView<PurchaseOrderItem> queryPurchaseOrderItemByPage(Map<String, Object> map) {
        PageView pageView = (PageView)map.get("pageView");
        List<PurchaseOrderItem> items = this.purchaseOrderItemMapper.selectPurchaseOrderItemByPage(map);
        pageView.setQueryResult(items);
        return pageView;
    }

    @Override
    public String selectMaxVersion() {
        return this.purchaseOrderItemMapper.selectMaxVersion();
    }

    @Override
    @CacheEvict(value={"purchaseOrderItem"}, allEntries=true)
    public void updateByPurcahseOrder(PurchaseOrderItem record, PurchaseOrderItemExample example) {
        this.purchaseOrderItemMapper.updateByExampleSelective(record, example);
    }

    @Override
    public PurchaseOrderItem queryByMaterialCode(String materialCode, String supCompanyCode) {
        PurchaseOrderItem purchaseOrderItem = new PurchaseOrderItem();
        SupplierMaterialExample supplierMaterialExample = new SupplierMaterialExample();
        supplierMaterialExample.createCriteria().andCompanySapCodeEqualTo(supCompanyCode).andMaterialCodeEqualTo(materialCode);
        List supplierMaterialList = this.supplierMaterialService.queryAllObjByExample(supplierMaterialExample);
        if (!CollectionUtils.isEmpty(supplierMaterialList)) {
            for (SupplierMaterial sm : supplierMaterialList) {
                if (!StringUtils.isNotBlank((String)sm.getSupplierMaterial())) continue;
                purchaseOrderItem.setSupMaterialCode(sm.getSupplierMaterial());
                break;
            }
        }
        double onwayQuantity = this.purchaseOrderItemMapper.calculateOnwayQuantity(materialCode, supCompanyCode);
        purchaseOrderItem.setOnwayQuantity(new BigDecimal(onwayQuantity));
        return purchaseOrderItem;
    }

    @Override
    public List<PurchaseOrderItem> selectForExcel(PurchaseOrderExample purchaseOrder) {
        return this.purchaseOrderItemMapper.selectForExcel(purchaseOrder);
    }

    @Override
    @Cacheable(value={"purchaseOrderItem"}, keyGenerator="redisKeyGenerator")
    public PurchaseOrderItem queryByOrderItemNo(String orderNo, String orderItemNo) {
        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        example.createCriteria().andOrderNoEqualTo(orderNo).andOrderItemNoEqualTo(orderItemNo);
        List<PurchaseOrderItem> list = this.queryAllObjByExample(example);
        if (list != null && list.size() > 1) {
            throw new CommonException("\u51fa\u73b0\u91cd\u590d\u8ba2\u5355\u53f7\u7684\u95ee\u9898");
        }
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }
}

