/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.service.impl;

import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.material.service.MaterialService;
import com.els.base.material.service.SupplierMaterialService;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.purchase.dao.PurchaseOrderMapper;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderExample;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.PurchaseOrderItemExample;
import com.els.base.purchase.entity.SupplierOrder;
import com.els.base.purchase.service.DeliveryOrderItemService;
import com.els.base.purchase.service.DeliveryOrderService;
import com.els.base.purchase.service.PurchaseOrderItemService;
import com.els.base.purchase.service.PurchaseOrderService;
import com.els.base.purchase.service.SupplierOrderService;
import com.els.base.purchase.service.interceptor.UpdatePurchaseOrderInterceptor;
import com.els.base.purchase.utils.OrderBusinessTypeEnum;
import com.els.base.purchase.utils.PurchaseOrderSendStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderStatusEnum;
import com.els.base.purchase.utils.SysUtil;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.uuid.UUIDGenerator;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="purchaseOrderService")
public class PurchaseOrderServiceImpl
implements PurchaseOrderService {
    @Resource
    protected PurchaseOrderMapper purchaseOrderMapper;
    @Resource
    protected MaterialService materialService;
    @Resource
    protected PurchaseOrderItemService purchaseOrderItemService;
    @Resource
    protected DeliveryOrderService deliveryOrderService;
    @Resource
    protected DeliveryOrderItemService deliveryOrderItemService;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected CompanyUserRefService companyUserRefService;
    @Resource
    protected SupplierMaterialService supplierMaterialService;
    @Resource
    protected SupplierOrderService supplierOrderService;

    @Override
    @Transactional
    @CacheEvict(value={"purchaseOrder", "purchaseOrderItem"}, allEntries=true)
    public void addObj(PurchaseOrder purchaseOrder) {
        this.purchaseOrderMapper.insertSelective(purchaseOrder);
    }

    @Override
    @CacheEvict(value={"purchaseOrder"}, allEntries=true)
    public void deleteObjById(String id) {
        this.purchaseOrderMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"purchaseOrder"}, allEntries=true)
    public void modifyObj(PurchaseOrder t) {
        Assert.isNotBlank(t.getId(), "id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        this.purchaseOrderMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"purchaseOrder"}, keyGenerator="redisKeyGenerator")
    public PurchaseOrder queryObjById(String id) {
        return this.purchaseOrderMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"purchaseOrder"}, keyGenerator="redisKeyGenerator")
    public List<PurchaseOrder> queryAllObjByExample(PurchaseOrderExample example) {
        return this.purchaseOrderMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"purchaseOrder"}, keyGenerator="redisKeyGenerator")
    public PageView<PurchaseOrder> queryObjByPage(PurchaseOrderExample example) {
        PageView<PurchaseOrder> pageView = example.getPageView();
        List<PurchaseOrder> list = this.purchaseOrderMapper.selectByExampleByPage(example);
        for (PurchaseOrder purchaseOrder : list) {
            Company company = (Company)this.companyService.queryObjById(purchaseOrder.getSupCompanyId());
            if (company == null) continue;
            purchaseOrder.setSupShortName(company.getCompanyName());
        }
        pageView.setQueryResult(list);
        return pageView;
    }

    @Override
    @Cacheable(value={"purchaseOrder"}, keyGenerator="redisKeyGenerator")
    public PageView<PurchaseOrder> queryHisObjByPage(PurchaseOrderExample example) {
        PageView<PurchaseOrder> pageView = example.getPageView();
        pageView.setQueryResult(this.purchaseOrderMapper.selectHisByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"purchaseOrder"}, allEntries=true)
    public void setIsEnable(String id, boolean isEnable) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("id\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25", "id_is_blank");
        }
        PurchaseOrder order = new PurchaseOrder();
        order.setId(id);
        if (isEnable) {
            order.setIsEnable(Constant.YES_INT);
        } else {
            order.setIsEnable(Constant.NO_INT);
        }
        this.purchaseOrderMapper.updateByPrimaryKeySelective(order);
    }

    @Override
    public String selectMaxVersion() {
        return this.purchaseOrderMapper.selectMaxVersion();
    }

    @Override
    @CacheEvict(value={"purchaseOrder"}, allEntries=true)
    public void updateForSap(PurchaseOrder purchaseOrder) {
        Map interceptors;
        if (purchaseOrder == null) {
            throw new CommonException("\u91c7\u8d2d\u65b9\u8ba2\u5355\u5934\u6570\u636e\u4e3a\u7a7a\uff0c\u521b\u5efa\u91c7\u8d2d\u65b9\u8ba2\u5355\u5934\u5931\u8d25", "base_fail");
        }
        if (StringUtils.isBlank((String)purchaseOrder.getId())) {
            throw new NullPointerException("id\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(purchaseOrder.getItems())) {
            throw new CommonException("\u884c\u6570\u636e\u4e0d\u5b58\u5728", "do_not_exists", "\u884c\u6570\u636e");
        }
        ArrayList<PurchaseOrderItem> itemTemps = new ArrayList<PurchaseOrderItem>();
        for (PurchaseOrderItem purchaseOrderItem : purchaseOrder.getItems()) {
            long changeAmount = 0L;
            BigDecimal onwayQuantity = BigDecimal.ZERO;
            BigDecimal receivedQuantity = BigDecimal.ZERO;
            BigDecimal deliveredQuantity = BigDecimal.ZERO;
            if (purchaseOrderItem.getChangeAmount() != null && purchaseOrderItem.getQuantity().longValue() - purchaseOrderItem.getChangeAmount() != 0L) {
                itemTemps.add(purchaseOrderItem);
                if (purchaseOrderItem.getReceivedQuantity() != null) {
                    receivedQuantity = purchaseOrderItem.getReceivedQuantity();
                }
                if (purchaseOrderItem.getOnwayQuantity() != null) {
                    onwayQuantity = purchaseOrderItem.getOnwayQuantity();
                }
                if ((deliveredQuantity = onwayQuantity.add(receivedQuantity)).compareTo(BigDecimal.valueOf(changeAmount)) == -1) {
                    throw new CommonException("\u7269\u6599" + purchaseOrderItem.getMaterialCode() + "\u5df2\u7ecf\u6536\u8d27" + receivedQuantity + ",\u5728\u9014" + onwayQuantity + ",\u66f4\u6539\u8ba2\u5355\u6570\u91cf\u4e0d\u80fd\u4f4e\u4e8e" + deliveredQuantity);
                }
            } else {
                changeAmount = 0L;
            }
            if (purchaseOrderItem.getChangeAmount() == null) continue;
            changeAmount = purchaseOrderItem.getChangeAmount();
        }
        if (CollectionUtils.isNotEmpty(itemTemps) && itemTemps.size() != 0 && (interceptors = SpringContextHolder.getBeans(UpdatePurchaseOrderInterceptor.class)) != null && interceptors.size() != 0) {
            Iterator keyIterator = interceptors.keySet().iterator();
            while (keyIterator.hasNext()) {
                UpdatePurchaseOrderInterceptor interceptor = (UpdatePurchaseOrderInterceptor)interceptors.get(keyIterator.next());
                String message = interceptor.preHandle(itemTemps);
                if (!StringUtils.isNotBlank((String)message)) continue;
                throw new CommonException(message);
            }
        }
    }

    @Override
    @CacheEvict(value={"purchaseOrder"}, allEntries=true)
    public void updateByPurcahseOrder(PurchaseOrder record, PurchaseOrderExample example) {
        this.purchaseOrderMapper.updateByExampleSelective(record, example);
    }

    @Override
    @Cacheable(value={"purchaseOrder"}, keyGenerator="redisKeyGenerator")
    public PageView<PurchaseOrder> queryObjNoItemsByPage(PurchaseOrderExample example, String purUserId, String materialCode, String brand) {
        PageView<PurchaseOrder> pageView = example.getPageView();
        List<PurchaseOrder> list = this.purchaseOrderMapper.selectForPurUserByExampleByPage(example, pageView, purUserId, materialCode, brand);
        pageView.setQueryResult(list);
        return pageView;
    }

    @Override
    @Transactional
    @CacheEvict(value={"purchaseOrder"}, allEntries=true)
    public void sendOrder(PurchaseOrder purchaseOrder) {
        purchaseOrder.setSendTime(new Date());
        if (purchaseOrder.getOrderSendStatus() == PurchaseOrderSendStatusEnum.UPDATE_NOTSEND.getValue() || purchaseOrder.getOrderSendStatus() == PurchaseOrderSendStatusEnum.UPDATE_SENDED.getValue()) {
            purchaseOrder.setOrderSendStatus(PurchaseOrderSendStatusEnum.UPDATE_SENDED.getValue());
        } else {
            purchaseOrder.setOrderSendStatus(PurchaseOrderSendStatusEnum.SENDED.getValue());
        }
        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        example.createCriteria().andOrderNoEqualTo(purchaseOrder.getOrderNo()).andSupCompanyIdEqualTo(purchaseOrder.getSupCompanyId());
        List<PurchaseOrderItem> items = this.purchaseOrderItemService.queryAllObjByExample(example);
        if (CollectionUtils.isNotEmpty(items)) {
            for (PurchaseOrderItem purchaseOrderItem : items) {
                long canDeliveryAmount = SysUtil.getCanDeliveryAmount(purchaseOrderItem.getQuantity(), purchaseOrderItem.getOnwayQuantity(), purchaseOrderItem.getReceivedQuantity(), purchaseOrderItem.getFreezeQuantity());
                purchaseOrderItem.setDeliveryAmount(canDeliveryAmount);
                purchaseOrderItem.setPurUserId(purchaseOrder.getUserId());
                purchaseOrderItem.setPurUserName(purchaseOrder.getUserName());
                purchaseOrderItem.setOrderStatus(PurchaseOrderStatusEnum.UNCONFIRM.getValue());
            }
        }
        purchaseOrder.setItems(items);
        SupplierOrder supplierOrder = new SupplierOrder();
        SysUtil.purhcaseTosSupplier(purchaseOrder, supplierOrder);
        this.supplierOrderService.saveSupplierOrder(supplierOrder);
        User user = this.companyUserRefService.queryMainUserOfCompany(purchaseOrder.getSupCompanyId());
        if (user != null) {
            supplierOrder.setUserId(user.getId());
            supplierOrder.setUserName(user.getNickName());
            purchaseOrder.setSupUserId(user.getId());
            purchaseOrder.setSupUserName(user.getNickName());
            Message message = new Message(purchaseOrder.getCompanyCode(), purchaseOrder.getUserId(), user.getId(), OrderBusinessTypeEnum.PO_NEW_SEND.getCode(), MessageLevelEnum.MIDDLE, (Object)purchaseOrder);
            MessageSendUtils.sendMessage((Message)message);
        }
        this.purchaseOrderMapper.updateByPrimaryKeySelective(purchaseOrder);
    }

    @Override
    @CacheEvict(value={"purchaseOrder"}, allEntries=true)
    public void modifyObjByKey(PurchaseOrder purchaseOrder) {
        this.purchaseOrderMapper.updateByPrimaryKeySelective(purchaseOrder);
    }

    @CacheEvict(value={"purchaseOrder"}, allEntries=true)
    public PurchaseOrder updateOrderHeaderStatus(PurchaseOrder purchaseOrder, int isDeleteNum, int isFrozenNum, int finishFlagDeleteNum, int finishFlagNoDeleteNum) {
        PurchaseOrder purchaseOrderTemp;
        int finishFlagNum = isDeleteNum + finishFlagNoDeleteNum;
        System.out.println(purchaseOrder.getOrderNo() + "------------finishFlagNoDeleteNum---" + finishFlagNoDeleteNum + "------------isDeleteNum--- " + isDeleteNum + "------------------------finishFlagNum---" + finishFlagNum + "--------------------------purchaseOrder.getItems().size()--" + purchaseOrder.getItems().size());
        if (isDeleteNum == purchaseOrder.getItems().size()) {
            purchaseOrder.setIsEnable(0);
        } else if (isFrozenNum == purchaseOrder.getItems().size() || isFrozenNum + isDeleteNum == purchaseOrder.getItems().size()) {
            purchaseOrder.setIsEnable(2);
        }
        if (finishFlagNum == purchaseOrder.getItems().size()) {
            purchaseOrder.setDeliveryStatus(2);
        }
        System.out.println(purchaseOrder.getOrderNo() + "------------------------finishFlagNum---" + finishFlagNum + "--------------------------purchaseOrder.getItems().size()--" + purchaseOrder.getItems().size());
        if (StringUtils.isNotBlank((String)purchaseOrder.getId()) && (purchaseOrderTemp = this.purchaseOrderMapper.selectByPrimaryKey(purchaseOrder.getId())) != null) {
            if (purchaseOrderTemp.getIsEnable() != null && purchaseOrderTemp.getIsEnable() == 0) {
                System.out.println(purchaseOrder.getOrderNo() + "------------------------isDeleteNum---" + isDeleteNum + "-----------isFrozenNum---" + isFrozenNum + "------------purchaseOrder.getItems().size()--" + purchaseOrder.getItems().size());
                if (isDeleteNum < purchaseOrder.getItems().size()) {
                    purchaseOrder.setIsEnable(1);
                }
            }
            if (purchaseOrderTemp.getIsEnable() != null && purchaseOrderTemp.getIsEnable() == 2 && isFrozenNum + isDeleteNum < purchaseOrder.getItems().size()) {
                purchaseOrder.setIsEnable(1);
            }
            if (purchaseOrderTemp.getDeliveryStatus() != null && purchaseOrderTemp.getDeliveryStatus() == 2 && finishFlagNum < purchaseOrder.getItems().size()) {
                purchaseOrder.setDeliveryStatus(1);
            }
        }
        return purchaseOrder;
    }

    private void setOldPurchaseOrderItem(PurchaseOrderItem item) {
        PurchaseOrderItemExample purchaseOrderItemExample = new PurchaseOrderItemExample();
        purchaseOrderItemExample.createCriteria().andOrderNoEqualTo(item.getOrderNo()).andOrderItemNoEqualTo(item.getOrderItemNo());
        List purchaseOrderItemList = this.purchaseOrderItemService.queryAllObjByExample(purchaseOrderItemExample);
        if (CollectionUtils.isEmpty(purchaseOrderItemList)) {
            return;
        }
        PurchaseOrderItem purchaseOrderItem = (PurchaseOrderItem)purchaseOrderItemList.get(0);
        item.setId(purchaseOrderItem.getId());
        purchaseOrderItem.setPurUserName(null);
        purchaseOrderItem.setPurUserId(null);
        purchaseOrderItem.setSupUserName(null);
        purchaseOrderItem.setSupUserId(null);
        item.setOrderStatus(null);
        item.setOnwayQuantity(null);
        item.setDeliveredQuantity(null);
        item.setReceivedQuantity(null);
        item.setReturnQuantity(null);
        item.setQuaWarehouseQuantity(null);
        item.setWarehouseLocation(null);
        BigDecimal nonTaxAmount = purchaseOrderItem.getNonTaxAmount() == null ? BigDecimal.ZERO : purchaseOrderItem.getNonTaxAmount();
        item.setNonTaxAmount(nonTaxAmount);
        long canDeliveryAmount = SysUtil.getCanDeliveryAmount(item.getQuantity(), purchaseOrderItem.getOnwayQuantity(), purchaseOrderItem.getReceivedQuantity(), purchaseOrderItem.getFreezeQuantity());
        item.setDeliveryAmount(canDeliveryAmount);
    }

    @Override
    @Cacheable(value={"purchaseOrder"}, keyGenerator="redisKeyGenerator")
    public PurchaseOrder queryByOrderNo(String projectId, String orderNo) {
        PurchaseOrderExample example = new PurchaseOrderExample();
        example.createCriteria().andProjectIdEqualTo(projectId).andOrderNoEqualTo(orderNo);
        List<PurchaseOrder> list = this.queryAllObjByExample(example);
        if (list != null && list.size() > 1) {
            throw new CommonException("\u51fa\u73b0\u91cd\u590d\u8ba2\u5355\u53f7\u7684\u95ee\u9898");
        }
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    @Override
    @CacheEvict(value={"purchaseOrder"}, allEntries=true)
    public String insertHis(String orderId, String cause) {
        String uuid = UUIDGenerator.generateUUID();
        this.purchaseOrderMapper.insertHis(uuid, orderId, cause);
        return uuid;
    }
}

