/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.service.CompanyAddressService;
import com.els.base.company.service.CompanyPurRefService;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.purchase.command.AbstractOrderCommand;
import com.els.base.purchase.command.OrderComandInvoker;
import com.els.base.purchase.command.delivery.BatchCancelCommand;
import com.els.base.purchase.command.delivery.BatchSendCommand;
import com.els.base.purchase.command.delivery.CreateCommand;
import com.els.base.purchase.command.delivery.DeleteCommand;
import com.els.base.purchase.command.delivery.ModifyCommand;
import com.els.base.purchase.command.delivery.PreviewDeliveryOrderCommand;
import com.els.base.purchase.command.delivery.PreviewDeliveryOrderItemCommand;
import com.els.base.purchase.command.delivery.SendCommand;
import com.els.base.purchase.entity.DeliveryOrder;
import com.els.base.purchase.entity.DeliveryOrderExample;
import com.els.base.purchase.entity.DeliveryOrderItem;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderExample;
import com.els.base.purchase.service.DeliveryOrderService;
import com.els.base.purchase.service.PurchaseOrderService;
import com.els.base.purchase.utils.DeliveryStatusEnum;
import com.els.base.purchase.utils.DeliveryTypeEnum;
import com.els.base.purchase.utils.PurchaseOrderSendStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderStatusEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u53d1\u8d27\u5355\u5934")
@Controller
@RequestMapping(value={"deliveryOrder"})
public class DeliveryOrderController {
    @Resource
    protected OrderComandInvoker orderComandInvoker;
    @Resource
    protected CompanyPurRefService companyPurRefService;
    @Resource
    protected DeliveryOrderService deliveryOrderService;
    @Resource
    protected PurchaseOrderService purchaseOrderService;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected CompanyAddressService companyAddressService;
    @Resource
    protected UserService userService;

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u53d1\u8d27\uff0c\u65b0\u5efa\u9001\u8d27\u5355\uff0c\u53d1\u8d27\u3002\u53d1\u8d27\u5355\u53d1\u8d27\uff1a\u5165\u53c2\uff08\u6574\u4e2a\u53d1\u8d27\u5355\u5b9e\u4f53\u7c7b\uff09")
    @RequestMapping(value={"service/sendDelivery"})
    @ResponseBody
    public ResponseResult<String> sendDelivery(@RequestBody DeliveryOrder deliveryOrder) {
        if (deliveryOrder == null) {
            throw new CommonException("\u53d1\u8d27\u5355\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u53d1\u8d27\u5355\u6570\u636e");
        }
        SendCommand command = new SendCommand(deliveryOrder);
        command.setSupCompany(CompanyUtils.currentCompany());
        command.setSupUser((User)SpringSecurityUtils.getLoginUser());
        command.setPurCompany(CompanyUtils.getPurCompanyOfCurrentCompany());
        this.orderComandInvoker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u9001\u8d27\u5355\u7ba1\u7406-\u6279\u91cf\u53d1\u8d27\u3002\u53d1\u8d27\u5355\u6279\u91cf\u53d1\u8d27\uff1a\u5165\u53c2\uff08\u53d1\u8d27\u5355\u5934id\u6570\u7ec4\uff09")
    @RequestMapping(value={"service/sendDeliveryForBatch"})
    @ResponseBody
    public ResponseResult<String> sendDeliveryForBatch(@RequestBody List<String> deliveryOrderIdList) {
        if (CollectionUtils.isEmpty(deliveryOrderIdList)) {
            throw new CommonException("\u53d1\u8d27\u5355\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u53d1\u8d27\u5355");
        }
        BatchSendCommand command = new BatchSendCommand(deliveryOrderIdList);
        command.setSupCompany(CompanyUtils.currentCompany());
        command.setSupUser((User)SpringSecurityUtils.getLoginUser());
        command.setPurCompany(CompanyUtils.getPurCompanyOfCurrentCompany());
        this.orderComandInvoker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u9001\u8d27\u5355\u7ba1\u7406-\u6279\u91cf\u4f5c\u5e9f\u53d1\u8d27\u3002\u6279\u91cf\u64a4\u9500\u53d1\u8d27\u5355\uff1a\u5165\u53c2\uff08\u53d1\u8d27\u5355\u5934id\u6570\u7ec4\uff09")
    @RequestMapping(value={"service/cancellationDeliveryForBatch"})
    @ResponseBody
    public ResponseResult<String> cancellationDeliveryForBatch(@RequestBody List<String> deliveryOrderIdList) {
        if (CollectionUtils.isEmpty(deliveryOrderIdList)) {
            throw new CommonException("\u63d0\u4ea4\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "not_query_to_data");
        }
        BatchCancelCommand command = new BatchCancelCommand(deliveryOrderIdList);
        command.setSupCompany(CompanyUtils.currentCompany());
        command.setSupUser((User)SpringSecurityUtils.getLoginUser());
        this.orderComandInvoker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u53d1\u8d27\uff0c\u65b0\u5efa\u9001\u8d27\u5355\uff0c\u4fdd\u5b58\u64cd\u4f5c\u3002\u53d1\u8d27\u5355\u4fdd\u5b58\uff1a\u5165\u53c2\uff08\u6574\u4e2a\u53d1\u8d27\u5355\u5b9e\u4f53\u7c7b\uff09")
    @RequestMapping(value={"service/saveDelivery"})
    @ResponseBody
    public ResponseResult<String> saveDelivery(@RequestBody DeliveryOrder deliveryOrder) {
        Assert.isNotNull(deliveryOrder, "\u53d1\u8d27\u5355\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(deliveryOrder.getItems(), "\u884c\u6570\u636e\u4e0d\u5b58\u5728");
        this.isHaverNewOrder(deliveryOrder);
        AbstractOrderCommand command = null;
        command = StringUtils.isNotBlank((String)deliveryOrder.getId()) ? new ModifyCommand(deliveryOrder) : new CreateCommand(deliveryOrder);
        command.setSupCompany(CompanyUtils.currentCompany());
        command.setSupUser((User)SpringSecurityUtils.getLoginUser());
        command.setPurCompany(CompanyUtils.getPurCompanyOfCurrentCompany());
        this.orderComandInvoker.invoke(command);
        return ResponseResult.success();
    }

    private void isHaverNewOrder(DeliveryOrder deliveryOrder) {
        HashSet<String> orderNoList = new HashSet<String>();
        for (DeliveryOrderItem item : deliveryOrder.getItems()) {
            orderNoList.add(item.getPurOrderNo());
        }
        for (String purchaseOrderNo : orderNoList) {
            PurchaseOrderExample example = new PurchaseOrderExample();
            PurchaseOrderExample.Criteria criteria = example.createCriteria();
            criteria.andOrderNoEqualTo(purchaseOrderNo);
            criteria.andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId());
            List purchaseOrders = this.purchaseOrderService.queryAllObjByExample(example);
            if (CollectionUtils.isEmpty(purchaseOrders)) {
                throw new CommonException("\u6570\u636e\u5f02\u5e38\uff0c\u91c7\u8d2d\u8ba2\u5355[" + purchaseOrderNo + "]\uff0c\u5728\u91c7\u8d2d\u65b9\u4e0d\u5b58\u5728");
            }
            PurchaseOrder purchaseOrder = (PurchaseOrder)purchaseOrders.get(0);
            if (purchaseOrder == null || purchaseOrder.getOrderStatus() != PurchaseOrderStatusEnum.UNCONFIRM.getValue() || purchaseOrder.getOrderSendStatus() != PurchaseOrderSendStatusEnum.UPDATE_SENDED.getValue()) continue;
            throw new CommonException("\u91c7\u8d2d\u8ba2\u5355[" + purchaseOrderNo + "],\u5df2\u53d1\u5e03\u65b0\u8ba2\u5355\uff0c\u65e7\u8ba2\u5355\u4e0d\u53ef\u521b\u5efa\u9001\u8d27\u5355\uff0c\u8c22\u8c22");
        }
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u53d1\u8d27\u5355\uff1a\u5165\u53c2\uff08\u53d1\u8d27\u5355\u5934id\u6570\u7ec4\uff09")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestBody List<String> deliveryOrderIdList) {
        if (CollectionUtils.isEmpty(deliveryOrderIdList)) {
            throw new CommonException("\u6ca1\u6709\u67e5\u8be2\u5230\u6570\u636e", "not_query_to_data");
        }
        DeleteCommand command = new DeleteCommand(deliveryOrderIdList);
        this.orderComandInvoker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u9001\u8d27\u5355\u7ba1\u7406-\u5217\u8868\u3002\u67e5\u8be2\u53d1\u8d27\u5934")
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<DeliveryOrder>> findByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 DeliveryOrder") @RequestBody(required=false) QueryParamWapper wapper) {
        DeliveryOrderExample example = new DeliveryOrderExample();
        example.setPageView(new PageView<DeliveryOrder>(pageNo, pageSize));
        String companyId = CompanyUtils.currentCompanyId();
        String projectId = ProjectUtils.getProjectId();
        DeliveryOrderExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(projectId);
        criteria.andCompanyIdEqualTo(companyId);
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        criteria.andTypeEqualTo(DeliveryTypeEnum.DELIVERY.getValue());
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        example.setOrderByClause("CREATE_TIME DESC,LAST_UPDATE_TIME DESC");
        PageView<DeliveryOrder> pageData = this.deliveryOrderService.queryDeliveryOrderByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u65b0\u5efa\u9001\u8d27\u5355\u3002\u751f\u6210\u53d1\u8d27\u5355\u6570\u636e\uff1a\u5165\u53c2\uff08\u91c7\u8d2d\u8ba2\u5355\u884cid\u6570\u7ec4\uff09")
    @RequestMapping(value={"service/createDeliveryData"})
    @ResponseBody
    public ResponseResult<DeliveryOrder> createDeliveryData(@RequestBody List<String> orderItemIdList) {
        Assert.isNotEmpty(orderItemIdList, "\u6ca1\u6709\u8ba2\u8d27\u5355\u884c\u6570\u636e");
        PreviewDeliveryOrderCommand command = new PreviewDeliveryOrderCommand(orderItemIdList);
        command.setSupCompany(CompanyUtils.currentCompany());
        command.setSupUser((User)SpringSecurityUtils.getLoginUser());
        DeliveryOrder deliveryOrder = this.orderComandInvoker.invoke(command);
        return ResponseResult.success(deliveryOrder);
    }

    @ApiOperation(httpMethod="POST", value="\u65b0\u5efa\u9001\u8d27\u5355\u9884\u89c8\uff1a\u5165\u53c2\uff08\u91c7\u8d2d\u8ba2\u5355\u884cid\u6570\u7ec4\uff09")
    @RequestMapping(value={"service/orderItemToDeliveryData"})
    @ResponseBody
    public ResponseResult<List<DeliveryOrderItem>> orderItemToDeliveryData(@RequestBody List<String> orderItemIdList) {
        Assert.isNotEmpty(orderItemIdList, "\u6ca1\u6709\u8ba2\u8d27\u5355\u884c\u6570\u636e");
        PreviewDeliveryOrderItemCommand command = new PreviewDeliveryOrderItemCommand(orderItemIdList);
        command.setSupCompany(CompanyUtils.currentCompany());
        command.setSupUser((User)SpringSecurityUtils.getLoginUser());
        List<DeliveryOrderItem> items = this.orderComandInvoker.invoke(command);
        return ResponseResult.success(items);
    }

    @ApiOperation(httpMethod="GET", value="\u901a\u8fc7id\u67e5\u8be2\u53d1\u8d27\u5355\u5934\u5386\u53f2")
    @RequestMapping(value={"service/findHisById"})
    @ResponseBody
    public ResponseResult<PageView<DeliveryOrder>> findHisById(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u53d1\u8d27\u5355\u5934id") String id) {
        DeliveryOrderExample example = new DeliveryOrderExample();
        example.setPageView(new PageView<DeliveryOrder>(pageNo, pageSize));
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("id\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25", "id_is_blank");
        }
        DeliveryOrderExample.Criteria criteria = example.createCriteria();
        criteria.andIdEqualTo(id);
        example.setOrderByClause("last_update_time DESC");
        PageView<DeliveryOrder> pageData = this.deliveryOrderService.queryHisObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5458\u67e5\u8be2\u53d1\u8d27\u5934")
    @RequestMapping(value={"service/findByPageForPurchase"})
    @ResponseBody
    public ResponseResult<PageView<DeliveryOrder>> findByPageForPurchase(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 DeliveryOrder") @RequestBody(required=false) QueryParamWapper wapper) {
        DeliveryOrderExample example = new DeliveryOrderExample();
        example.setPageView(new PageView<DeliveryOrder>(pageNo, pageSize));
        String companyId = CompanyUtils.currentCompanyId();
        String projectId = ProjectUtils.getProjectId();
        DeliveryOrderExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(projectId);
        criteria.andPurCompanyIdEqualTo(companyId);
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        example.setOrderByClause("CREATE_TIME DESC,LAST_UPDATE_TIME DESC");
        PageView<DeliveryOrder> pageData = this.deliveryOrderService.queryDeliveryOrderByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4ed3\u5e93\u9001\u8d27\u5355/\u8d28\u68c0\u9001\u8d27\u5355")
    @RequestMapping(value={"service/findByPageForWarehouse"})
    @ResponseBody
    public ResponseResult<PageView<DeliveryOrder>> findByPageForWarehouse(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 DeliveryOrder") @RequestBody(required=false) QueryParamWapper wapper) {
        DeliveryOrderExample example = new DeliveryOrderExample();
        example.setPageView(new PageView<DeliveryOrder>(pageNo, pageSize));
        String projectId = ProjectUtils.getProjectId();
        DeliveryOrderExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(projectId);
        ArrayList<Integer> values = new ArrayList<Integer>();
        values.add(DeliveryStatusEnum.ONWAY.getValue());
        values.add(DeliveryStatusEnum.ALL_RECEIVED.getValue());
        criteria.andDeliveryStatusIn(values);
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        example.setOrderByClause("CREATE_TIME DESC,LAST_UPDATE_TIME DESC");
        PageView<DeliveryOrder> pageData = this.deliveryOrderService.queryDeliveryOrderByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u9001\u8d27\u5355\u7ba1\u7406-\u4fee\u6539-\u901a\u8fc7\u53d1\u8d27id\u67e5\u8be2\u53d1\u8d27\u884c:")
    @RequestMapping(value={"service/findByDeliveryOrderId"})
    @ResponseBody
    public ResponseResult<DeliveryOrder> findByDeliveryOrderId(@ApiParam(value="\u53d1\u8d27\u5355\u53f7Id") String deliveryOrderId) {
        if (StringUtils.isBlank((String)deliveryOrderId)) {
            throw new CommonException("\u67e5\u8be2\u5931\u8d25,\u53d1\u8d27\u53f7\u4e0d\u5b58\u5728", "do_not_exists", "\u53d1\u8d27\u53f7");
        }
        DeliveryOrder deliveryOrder = this.deliveryOrderService.queryDeliveryOrderId(deliveryOrderId);
        return ResponseResult.success(deliveryOrder);
    }
}

