/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.web.controller;

import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import com.els.base.file.service.IFileManager;
import com.els.base.purchase.entity.DeliveryOrderItem;
import com.els.base.purchase.entity.DeliveryOrderItemExample;
import com.els.base.purchase.service.DeliveryOrderItemService;
import com.els.base.purchase.service.DeliveryOrderService;
import com.els.base.utils.excel.DateConverter;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.ObjToStrConverter;
import com.els.base.utils.excel.StrToObjConverter;
import com.els.base.utils.excel.TitleAndModelKey;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u53d1\u8d27\u884c")
@Controller
@RequestMapping(value={"deliveryOrderItem"})
public class DeliveryOrderItemController {
    Logger logger = LoggerFactory.getLogger(DeliveryOrderItemController.class);
    @Resource
    protected DeliveryOrderItemService deliveryOrderItemService;
    @Resource
    protected DeliveryOrderService deliveryOrderService;

    @ApiOperation(httpMethod="POST", value="\u901a\u8fc7\u53d1\u8d27\u53f7\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u884c:")
    @RequestMapping(value={"service/findByDeliveryOrder"})
    @ResponseBody
    public ResponseResult<PageView<DeliveryOrderItem>> findByDeliveryOrder(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u53d1\u8d27\u5355\u53f7Id") String deliveryOrderId) {
        if (StringUtils.isBlank((String)deliveryOrderId)) {
            throw new CommonException("\u67e5\u8be2\u5931\u8d25,\u53d1\u8d27\u53f7\u4e0d\u5b58\u5728", "do_not_exists", "\u53d1\u8d27\u53f7");
        }
        DeliveryOrderItemExample example = new DeliveryOrderItemExample();
        example.setPageView(new PageView<DeliveryOrderItem>(pageNo, pageSize));
        DeliveryOrderItemExample.Criteria criteria = example.createCriteria();
        criteria.andDeliveryOrderIdEqualTo(deliveryOrderId);
        PageView pageData = this.deliveryOrderItemService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="GET", value="\u901a\u8fc7id\u67e5\u8be2\u53d1\u8d27\u5355\u884c\u5386\u53f2")
    @RequestMapping(value={"service/findHisById"})
    @ResponseBody
    public ResponseResult<PageView<DeliveryOrderItem>> findHisById(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u53d1\u8d27\u5355\u884cid") String id) {
        DeliveryOrderItemExample example = new DeliveryOrderItemExample();
        example.setPageView(new PageView<DeliveryOrderItem>(pageNo, pageSize));
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("id\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25", "id_is_blank");
        }
        DeliveryOrderItemExample.Criteria criteria = example.createCriteria();
        criteria.andIdEqualTo(id);
        example.setOrderByClause("last_update_time DESC");
        PageView<DeliveryOrderItem> pageData = this.deliveryOrderItemService.queryHisObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u7269\u6d41\u8fdb\u5ea6\u62a5\u8868")
    @RequestMapping(value={"service/queryDeliveryOrderItemForLogisticByPage"})
    @ResponseBody
    public ResponseResult<PageView<DeliveryOrderItem>> queryDeliveryOrderItemForLogisticByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 DeliveryOrderItem,\u539f\u578b\u56fe") @RequestBody(required=false) QueryParamWapper wapper) {
        this.logger.info("\u8fdb\u5165\u7269\u6d41\u8fdb\u5ea6\u62a5\u8868");
        DeliveryOrderItemExample example = new DeliveryOrderItemExample();
        example.setPageView(new PageView<DeliveryOrderItem>(pageNo, pageSize));
        String companyId = CompanyUtils.currentCompanyId();
        String projectId = ProjectUtils.getProjectId();
        DeliveryOrderItemExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(projectId);
        criteria.andCompanyIdEqualTo(companyId);
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        PageView pageData = this.deliveryOrderItemService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u7269\u6d41\u8fdb\u5ea6\u62a5\u8868\uff08\u91c7\u8d2d\u65b9\uff09")
    @RequestMapping(value={"service/queryDeliveryOrderItemForPurchaseByPage"})
    @ResponseBody
    public ResponseResult<PageView<DeliveryOrderItem>> queryDeliveryOrderItemForPurchaseByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 DeliveryOrderItem,\u539f\u578b\u56fe") @RequestBody(required=false) QueryParamWapper wapper) {
        DeliveryOrderItemExample example = new DeliveryOrderItemExample();
        example.setPageView(new PageView<DeliveryOrderItem>(pageNo, pageSize));
        String projectId = ProjectUtils.getProjectId();
        DeliveryOrderItemExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(projectId);
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        PageView pageData = this.deliveryOrderItemService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u7269\u6d41\u8fdb\u5ea6\u62a5\u8868\uff08\u91c7\u8d2d\u65b9\uff09")
    @RequestMapping(value={"service/exportDeliveryOrderItemForPurchase"})
    @ResponseBody
    public ResponseResult<FileData> exportDeliveryOrderItemForPurchase(@ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 DeliveryOrderItem") @RequestBody(required=false) QueryParamWapper wapper) throws IOException, RowsExceededException, WriteException, ParseException {
        DeliveryOrderItemExample example = new DeliveryOrderItemExample();
        String projectId = ProjectUtils.getProjectId();
        DeliveryOrderItemExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(projectId);
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        List list = this.deliveryOrderItemService.queryAllObjByExample(example);
        IFileManager fileManager = FileManagerFactory.getFileManager();
        FileData excelFile = new FileData();
        excelFile.setProjectId(projectId);
        excelFile.setCompanyId(CompanyUtils.currentCompanyId());
        excelFile.setFileName("\u7269\u6d41\u8fdb\u5ea6\u62a5\u8868-%s.xls");
        excelFile.setFileSuffix("xls");
        excelFile.setIsEncrypt(String.valueOf(Constant.NO_INT));
        excelFile.setExpiryDay(DateUtils.addDays((Date)new Date(), (int)2));
        OutputStream outputStream = fileManager.createOutputStream(excelFile);
        List<TitleAndModelKey> titleAndModelKeys = this.createExcelHeader();
        WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, list, (String)"\u7269\u6d41\u8fdb\u5ea6\u62a5\u8868", (String)"", (int)0);
        writableWorkbook.write();
        outputStream.flush();
        writableWorkbook.close();
        outputStream.close();
        return ResponseResult.success(excelFile);
    }

    private void setDownLoadHeader(HttpServletResponse response, String fileName) throws UnsupportedEncodingException {
        response.reset();
        StringBuffer header = new StringBuffer("attachment;");
        header.append("filename=\"" + URLEncoder.encode(fileName, "UTF-8") + "\";");
        response.setHeader("Content-Disposition", header.toString());
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/x-msdownload;");
    }

    private List<TitleAndModelKey> createExcelHeader() {
        DateConverter dateConverter = new DateConverter("yyyy-MM-dd");
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u9001\u8d27\u5355\u53f7", (String)"deliveryOrderNo", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u9879\u76ee", (String)"deliveryOrderItemNo", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5305\u88c5\u4ef6\u6570\t", (String)"packQuantity", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u7f16\u7801", (String)"companyCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546", (String)"companyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u91c7\u8d2d\u8ba2\u5355", (String)"purOrderNo", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8ba2\u5355\u9879", (String)"purOrderItemNo", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u7f16\u7801", (String)"materialNo", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u63cf\u8ff0", (String)"materialDesc", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u6599\u53f7", (String)"supplierMaterialNumber", (boolean)true));
        TitleAndModelKey deliveryDate = ExcelUtils.createTitleAndModelKey((String)"\u4ea4\u8d27\u65e5\u671f", (String)"deliveryDate", (boolean)true);
        deliveryDate.setToStrConverter((ObjToStrConverter)dateConverter);
        deliveryDate.setToObjConverter((StrToObjConverter)dateConverter);
        titleAndModelKeys.add(deliveryDate);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u9001\u8d27\u6570\u91cf", (String)"deliveryQuantity", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5e01\u522b", (String)"currency", (boolean)true));
        TitleAndModelKey createTime = ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u65b9\u51fa\u5382\u65f6\u95f4\t", (String)"createTime", (boolean)true);
        createTime.setToStrConverter((ObjToStrConverter)dateConverter);
        createTime.setToObjConverter((StrToObjConverter)dateConverter);
        titleAndModelKeys.add(createTime);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"FGE\u95e8\u5c97\u65f6\u95f4", (String)"gateScan", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ed3\u5e93\u6536\u8d27\u65f6\u95f4", (String)"warehouseScan", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u91c7\u8d2d\u65b9\u6536\u8d27\u5de5\u5382", (String)"factoryName", (boolean)true));
        return titleAndModelKeys;
    }
}

