/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyPurRefService;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.purchase.command.OrderComandInvoker;
import com.els.base.purchase.command.order.BatchSendOrderCommand;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderExample;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.service.PurchaseOrderItemService;
import com.els.base.purchase.service.PurchaseOrderService;
import com.els.base.purchase.utils.PurchaseOrderSendStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderStatusEnum;
import com.els.base.utils.excel.DateConverter;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.ObjToStrConverter;
import com.els.base.utils.excel.StrToObjConverter;
import com.els.base.utils.excel.TitleAndModelKey;
import com.qqt.message.client.JsonUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jxl.write.WritableWorkbook;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Api(value="\u91c7\u8d2d\u65b9\u8ba2\u5355\u5934")
@Controller
@RequestMapping(value={"purchaseOrderHeader"})
public class PurchaseOrderHeaderController {
    @Resource
    protected OrderComandInvoker invoker;
    @Resource
    protected CompanyPurRefService companyPurRefService;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected PurchaseOrderService purchaseOrderHeaderService;
    @Resource
    protected PurchaseOrderItemService purchaseOrderItemService;

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u53d1\u9001\u91c7\u8d2d\u65b9\u8ba2\u5355\uff1a\u5165\u53c2\uff08\u8ba2\u5355id\u6570\u7ec4\uff09")
    @RequestMapping(value={"service/send"})
    @ResponseBody
    public ResponseResult<String> send(@RequestBody List<String> orderIdList) {
        Assert.isNotEmpty(orderIdList, "\u8ba2\u5355\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        BatchSendOrderCommand command = new BatchSendOrderCommand(orderIdList);
        command.setPurCompany(CompanyUtils.currentCompany());
        command.setPurUser((User)SpringSecurityUtils.getLoginUser());
        this.invoker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4fee\u6539\u91c7\u8d2d\u65b9\u8ba2\u5355\uff1a\u5165\u53c2\uff08\u6574\u4e2a\u8ba2\u5355\u5b9e\u4f53\uff09")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody PurchaseOrder purchaseOrderHeader) {
        this.purchaseOrderHeaderService.updateForSap(purchaseOrderHeader);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u91c7\u8d2d\u65b9\u8ba2\u5355\u5934")
    @RequestMapping(value={"service/findTobeSentOrderByPage"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseOrder>> findTobeSentOrderByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u91c7\u8d2d\u5546\u7269\u6599\u53f7") @RequestParam(required=false) String materialCode, @ApiParam(value="\u7269\u6599\u54c1\u724c") @RequestParam(required=false) String brand, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseOrderHeader") @RequestBody(required=false) QueryParamWapper wapper) {
        List<Company> companyList = this.companyPurRefService.queryAllCompanyByUserId(SpringSecurityUtils.getLoginUserId(), null);
        if (CollectionUtils.isEmpty(companyList)) {
            return ResponseResult.success(new PageView());
        }
        ArrayList<Integer> sendStatusList = new ArrayList<Integer>();
        sendStatusList.add(PurchaseOrderSendStatusEnum.NOTSEND.getValue());
        sendStatusList.add(PurchaseOrderSendStatusEnum.UPDATE_NOTSEND.getValue());
        ArrayList<Integer> orderStatusList = new ArrayList<Integer>();
        orderStatusList.add(PurchaseOrderStatusEnum.BACK.getValue());
        orderStatusList.add(PurchaseOrderStatusEnum.PART_BACK.getValue());
        PurchaseOrderExample example = new PurchaseOrderExample();
        example.setPageView(new PageView<PurchaseOrder>(pageNo, pageSize));
        example.createCriteria().andOrderSendStatusIn(sendStatusList).andIsEnableNotEqualTo(Constant.NO_INT);
        example.or().andOrderSendStatusEqualTo(PurchaseOrderSendStatusEnum.UPDATE_NOTSEND.getValue()).andSendTimeIsNotNull();
        example.or().andOrderStatusIn(orderStatusList);
        for (PurchaseOrderExample.Criteria criteria : example.getOredCriteria()) {
            criteria.andProjectIdEqualTo(ProjectUtils.getProjectId());
            criteria.andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
            if (wapper == null) continue;
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        example.setOrderByClause(" ORDER_DATE ASC , LAST_UPDATE_TIME DESC , CREATE_TIME DESC");
        PageView<PurchaseOrder> pageData = this.purchaseOrderHeaderService.queryObjNoItemsByPage(example, SpringSecurityUtils.getLoginUserId(), materialCode, brand);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u91c7\u8d2d\u65b9\u8ba2\u5355\u5934")
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseOrder>> findByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u91c7\u8d2d\u5546\u7269\u6599\u53f7") @RequestParam(required=false) String materialCode, @ApiParam(value="\u7269\u6599\u54c1\u724c") @RequestParam(required=false) String brand, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseOrderHeader") @RequestBody(required=false) QueryParamWapper wapper) {
        List<Company> companyList = this.companyPurRefService.queryAllCompanyByUserId(SpringSecurityUtils.getLoginUserId(), null);
        if (CollectionUtils.isEmpty(companyList)) {
            return ResponseResult.success(new PageView());
        }
        ArrayList<Integer> isEnableValues = new ArrayList<Integer>();
        isEnableValues.add(1);
        isEnableValues.add(2);
        PurchaseOrderExample example = new PurchaseOrderExample();
        example.setPageView(new PageView<PurchaseOrder>(pageNo, pageSize));
        PurchaseOrderExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId());
        criteria.andIsEnableIn(isEnableValues);
        criteria.andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        example.setOrderByClause(" ORDER_DATE ASC , LAST_UPDATE_TIME DESC , CREATE_TIME DESC");
        PageView<PurchaseOrder> pageData = this.purchaseOrderHeaderService.queryObjNoItemsByPage(example, SpringSecurityUtils.getLoginUserId(), materialCode, brand);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="GET", value="\u901a\u8fc7id\u67e5\u8be2\u91c7\u8d2d\u65b9\u8ba2\u5355\u5934\u5386\u53f2")
    @RequestMapping(value={"service/findHeaderHisById"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseOrder>> findHeaderHisById(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u91c7\u8d2d\u8ba2\u5355\u5934id") String id) {
        PurchaseOrderExample example = new PurchaseOrderExample();
        example.setPageView(new PageView<PurchaseOrder>(pageNo, pageSize));
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("id\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25", "id_is_blank");
        }
        PurchaseOrderExample.Criteria criteria = example.createCriteria();
        criteria.andIdEqualTo(id);
        example.setOrderByClause("version DESC");
        PageView<PurchaseOrder> pageData = this.purchaseOrderHeaderService.queryHisObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(value="\u91c7\u8d2d\u8ba2\u5355\u6279\u91cf\u5bfc\u51faExcel", httpMethod="GET")
    @RequestMapping(value={"service/downloadExcel"})
    @ResponseBody
    public ModelAndView downloadExcel(String queryParams, HttpServletResponse response) {
        try {
            List<Company> supCompanyList = this.companyPurRefService.queryAllCompanyByUserId(SpringSecurityUtils.getLoginUserId(), null);
            ArrayList<String> supCompanyIdList = new ArrayList<String>();
            for (int i = 0; CollectionUtils.isNotEmpty(supCompanyList) && i < supCompanyList.size(); ++i) {
                supCompanyIdList.add(supCompanyList.get(i).getId());
            }
            List<Object> purOrderList = null;
            if (CollectionUtils.isEmpty(supCompanyIdList)) {
                purOrderList = new ArrayList();
            } else {
                PurchaseOrderExample purchaseOrder = new PurchaseOrderExample();
                PurchaseOrderExample.Criteria createCriteria = purchaseOrder.createCriteria();
                createCriteria.andCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andProjectIdEqualTo(ProjectUtils.getProjectId()).andSupCompanyIdIn(supCompanyIdList);
                if (StringUtils.isNotEmpty((String)queryParams)) {
                    QueryParamWapper queryParamWapper = (QueryParamWapper)JsonUtil.convertValue((String)queryParams, QueryParamWapper.class);
                    CriteriaUtils.addCriterion(createCriteria, queryParamWapper);
                }
                purOrderList = this.purchaseOrderItemService.selectForExcel(purchaseOrder);
            }
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            String companyShortName = CompanyUtils.currentCompany().getCompanyName();
            header.append("filename=\"" + URLEncoder.encode("\u534e\u9633-" + companyShortName + "PO\u660e\u7ec6.xls", "UTF-8") + "\";");
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream outputStream = response.getOutputStream();
            for (PurchaseOrderItem purchaseOrderItem : purOrderList) {
                BigDecimal quantity = purchaseOrderItem.getQuantity();
                BigDecimal receivedQuantity = purchaseOrderItem.getReceivedQuantity();
                BigDecimal noReceivedQuantity = BigDecimal.ZERO;
                if (purchaseOrderItem.getQuantity() != null) {
                    noReceivedQuantity = purchaseOrderItem.getReceivedQuantity() != null ? quantity.subtract(receivedQuantity) : purchaseOrderItem.getQuantity();
                }
                purchaseOrderItem.setNoReceivedQuantity(noReceivedQuantity);
                if (purchaseOrderItem.getIsEnable() != null && purchaseOrderItem.getIsEnable() == 2) {
                    purchaseOrderItem.setFrozenFlag("\u5df2\u51bb\u7ed3");
                    continue;
                }
                purchaseOrderItem.setFrozenFlag("\u672a\u51bb\u7ed3");
            }
            List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKeys();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, purOrderList, (String)"\u91c7\u8d2d\u8ba2\u5355", null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(417);
        }
        return null;
    }

    private List<TitleAndModelKey> createTitleAndModelKeys() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u7f16\u7801", (String)"sapSupCompanyCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u7b80\u79f0", (String)"supCompanyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u91c7\u8d2d\u8ba2\u5355\u53f7", (String)"orderNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u9879\u76ee", (String)"orderItemNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u54c1\u53f7", (String)"materialCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u54c1\u540d\u89c4\u683c", (String)"materialName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8ba2\u5355\u6570\u91cf", (String)"quantity"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5df2\u4ea4\u6570\u91cf", (String)"receivedQuantity"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u672a\u4ea4\u6570\u91cf", (String)"noReceivedQuantity"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u51bb\u7ed3\u6807\u8bc6", (String)"frozenFlag"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5355\u4f4d", (String)"orderUnit"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u51c0\u4ef7", (String)"noTaxPrice"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ef7\u683c\u5355\u4f4d", (String)"priceUnit"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u91c7\u8d2d\u91d1\u989d", (String)"nonTaxAmount"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5e01\u79cd", (String)"currency"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7a0e\u7387", (String)"saleTaxCode"));
        TitleAndModelKey titleAndModelKey = ExcelUtils.createTitleAndModelKey((String)"\u51ed\u8bc1\u65e5\u671f", (String)"orderDate");
        DateConverter dateConverter = new DateConverter().setDateFormat("yyyy-MM-dd");
        titleAndModelKey.setToObjConverter((StrToObjConverter)dateConverter);
        titleAndModelKey.setToStrConverter((ObjToStrConverter)dateConverter);
        titleAndModelKeys.add(titleAndModelKey);
        TitleAndModelKey titleAndModelKey2 = ExcelUtils.createTitleAndModelKey((String)"\u4ea4\u8d27\u65e5\u671f", (String)"deliveredDate");
        DateConverter dateConverter2 = new DateConverter().setDateFormat("yyyy-MM-dd");
        titleAndModelKey2.setToObjConverter((StrToObjConverter)dateConverter2);
        titleAndModelKey2.setToStrConverter((ObjToStrConverter)dateConverter2);
        titleAndModelKeys.add(titleAndModelKey2);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u7269\u6599\u53f7", (String)"supMaterialCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u54c1\u724c", (String)"brand"));
        return titleAndModelKeys;
    }

    @ApiOperation(value="\u91c7\u8d2d\u8ba2\u5355\u9009\u4e2d\u5bfc\u51faExcel", httpMethod="GET")
    @RequestMapping(value={"service/downloadExcelBySelect"})
    @ResponseBody
    public ModelAndView downloadExcelBySelect(@ApiParam(value="\u91c7\u8d2d\u8ba2\u5355\u53f7", defaultValue="") @RequestParam(defaultValue="") String orderNOList, HttpServletResponse response) {
        try {
            if (StringUtils.isEmpty((String)orderNOList)) {
                throw new CommonException("id\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25", "id_is_blank");
            }
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            header.append("filename=\"" + URLEncoder.encode("\u534e\u9633-\u4f9b\u5e94\u5546\u7b80\u79f0PO\u660e\u7ec6.xls", "UTF-8") + "\";");
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream outputStream = response.getOutputStream();
            PurchaseOrderExample orderExample = new PurchaseOrderExample();
            PurchaseOrderExample.Criteria createCriteria = orderExample.createCriteria();
            createCriteria.andCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andProjectIdEqualTo(ProjectUtils.getProjectId());
            if (StringUtils.isNotBlank((String)orderNOList)) {
                createCriteria.andOrderNoIn((List)Arrays.asList(orderNOList.split(",")));
            }
            List<PurchaseOrderItem> listOrderItem = this.purchaseOrderItemService.selectForExcel(orderExample);
            for (int i = 0; CollectionUtils.isNotEmpty(listOrderItem) && i < listOrderItem.size(); ++i) {
                PurchaseOrderItem purchaseOrderItem = listOrderItem.get(i);
                BigDecimal quantity = purchaseOrderItem.getQuantity();
                BigDecimal receivedQuantity = purchaseOrderItem.getReceivedQuantity();
                BigDecimal noReceivedQuantity = BigDecimal.ZERO;
                if (purchaseOrderItem.getQuantity() != null) {
                    noReceivedQuantity = purchaseOrderItem.getReceivedQuantity() != null ? quantity.subtract(receivedQuantity) : purchaseOrderItem.getQuantity();
                }
                purchaseOrderItem.setNoReceivedQuantity(noReceivedQuantity);
                if (purchaseOrderItem.getIsEnable() != null && purchaseOrderItem.getIsEnable() == 2) {
                    purchaseOrderItem.setFrozenFlag("\u5df2\u51bb\u7ed3");
                    continue;
                }
                purchaseOrderItem.setFrozenFlag("\u672a\u51bb\u7ed3");
            }
            List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKeys();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, listOrderItem, (String)"\u91c7\u8d2d\u8ba2\u5355", null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(417);
        }
        return null;
    }
}

