/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.web.controller;

import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.PurchaseOrderItemExample;
import com.els.base.purchase.service.PurchaseOrderItemService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u91c7\u8d2d\u8ba2\u5355\u884c")
@Controller
@RequestMapping(value={"purchaseOrderItem"})
public class PurchaseOrderItemController {
    @Resource
    protected PurchaseOrderItemService purchaseOrderItemService;
    @Resource
    protected CompanyService companyService;

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u91c7\u8d2d\u8ba2\u5355\u884c\uff1a\u5165\u53c2\uff08\u91c7\u8d2d\u65b9\u8ba2\u5355\u884cid\uff09")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a", "id_is_blank");
        }
        PurchaseOrderItem returnObj = (PurchaseOrderItem)this.purchaseOrderItemService.queryObjById(id);
        if (returnObj == null) {
            throw new CommonException("\u5220\u9664\u5931\u8d25,\u91c7\u8d2d\u65b9\u8ba2\u5355\u884c\u4e0d\u5b58\u5728", "do_not_exists", "\u91c7\u8d2d\u65b9\u8ba2\u5355\u884c");
        }
        returnObj.setIsEnable(Constant.NO_INT);
        this.purchaseOrderItemService.modifyObj(returnObj);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u901a\u8fc7\u91c7\u8d2d\u8ba2\u5355\u53f7\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u884c")
    @RequestMapping(value={"service/findByPurchaseOrder"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseOrderItem>> findByPurchaseOrder(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u91c7\u8d2d\u8ba2\u5355\u53f7") String orderId) {
        if (StringUtils.isBlank((String)orderId)) {
            throw new CommonException("\u67e5\u8be2\u5931\u8d25,\u91c7\u8d2d\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728", "do_not_exists", "\u91c7\u8d2d\u8ba2\u5355\u53f7");
        }
        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        example.setPageView(new PageView<PurchaseOrderItem>(pageNo, pageSize));
        PurchaseOrderItemExample.Criteria criteria = example.createCriteria();
        criteria.andOrderIdEqualTo(orderId);
        criteria.andIsEnableNotEqualTo(0);
        example.setOrderByClause("ORDER_ITEM_NO ASC");
        PageView pageData = this.purchaseOrderItemService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u901a\u8fc7id\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u884c\u5386\u53f2")
    @RequestMapping(value={"service/findItemHisById"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseOrderItem>> findItemHisById(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u91c7\u8d2d\u8ba2\u5355\u53f7") String orderNo, @ApiParam(value="\u91c7\u8d2d\u8ba2\u5355\u884c\u53f7") String orderItemNo) {
        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        example.setPageView(new PageView<PurchaseOrderItem>(pageNo, pageSize));
        if (StringUtils.isBlank((String)orderNo)) {
            throw new CommonException("\u67e5\u8be2\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a", "id_is_blank");
        }
        PurchaseOrderItemExample.Criteria criteria = example.createCriteria();
        criteria.andOrderNoEqualTo(orderNo);
        criteria.andOrderItemNoEqualTo(orderItemNo);
        example.setOrderByClause("version DESC,UPDATE_TIME DESC");
        PageView<PurchaseOrderItem> pageData = this.purchaseOrderItemService.queryHisAllObjByExample(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u5206\u9875\u67e5\u8be2\u8ba2\u5355\u884c")
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseOrderItem>> findByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u901a\u7528\u67e5\u8be2\u6761\u4ef6") @RequestBody(required=true) QueryParamWapper wapper) {
        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        example.setPageView(new PageView<PurchaseOrderItem>(pageNo, pageSize));
        PurchaseOrderItemExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        example.setOrderByClause("ORDER_ITEM_NO ASC");
        PageView pageData = this.purchaseOrderItemService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}

