/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command.delivery;

import com.els.base.core.utils.Assert;
import com.els.base.purchase.command.AbstractOrderCommand;
import com.els.base.purchase.command.OrderComandInvoker;
import com.els.base.purchase.command.delivery.SendCommand;
import com.els.base.purchase.entity.DeliveryOrder;
import java.util.List;

public class BatchSendCommand
extends AbstractOrderCommand<String> {
    private List<String> deliveryOrderIdList;

    public BatchSendCommand(List<String> deliveryOrderIdList) {
        this.deliveryOrderIdList = deliveryOrderIdList;
    }

    @Override
    public String execute(OrderComandInvoker context) {
        Assert.isNotEmpty(this.deliveryOrderIdList, "\u9001\u8d27\u5355id\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        for (String deliveryOrderId : this.deliveryOrderIdList) {
            DeliveryOrder deliveryOrder = context.getDeliveryOrderService().queryDeliveryOrderId(deliveryOrderId);
            SendCommand sendCommand = new SendCommand(deliveryOrder);
            sendCommand.copyProperties(this);
            context.invoke(sendCommand);
        }
        return null;
    }
}

