/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.purchase.dao.SupplierOrderItemMapper;
import com.els.base.purchase.entity.SupplierOrderExample;
import com.els.base.purchase.entity.SupplierOrderItem;
import com.els.base.purchase.entity.SupplierOrderItemExample;
import com.els.base.purchase.service.SupplierOrderItemService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="supplierOrderItemService")
public class SupplierOrderItemServiceImpl
implements SupplierOrderItemService {
    @Resource
    protected SupplierOrderItemMapper supplierOrderItemMapper;

    @Override
    @CacheEvict(value={"supplierOrderItem"}, allEntries=true)
    public void addObj(SupplierOrderItem t) {
        this.supplierOrderItemMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"supplierOrderItem"}, allEntries=true)
    public void deleteObjById(String id) {
        this.supplierOrderItemMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"supplierOrderItem"}, allEntries=true)
    public void modifyObj(SupplierOrderItem t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        t.setUpdateTime(new Date());
        this.supplierOrderItemMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"supplierOrderItem"}, keyGenerator="redisKeyGenerator")
    public SupplierOrderItem queryObjById(String id) {
        return this.supplierOrderItemMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"supplierOrderItem"}, keyGenerator="redisKeyGenerator")
    public List<SupplierOrderItem> queryAllObjByExample(SupplierOrderItemExample example) {
        return this.supplierOrderItemMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"supplierOrderItem"}, keyGenerator="redisKeyGenerator")
    public PageView<SupplierOrderItem> queryObjByPage(SupplierOrderItemExample example) {
        PageView<SupplierOrderItem> pageView = example.getPageView();
        pageView.setQueryResult(this.supplierOrderItemMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"supplierOrderItem"}, allEntries=true)
    public int insertHisByOrderId(String orderHisId, String orderId, String cause) {
        return this.supplierOrderItemMapper.insertHisByOrderId(orderHisId, orderId, cause);
    }

    @Override
    @Cacheable(value={"supplierOrderItem"}, keyGenerator="redisKeyGenerator")
    public PageView<SupplierOrderItem> querySupplierOrderItemByPage(SupplierOrderItemExample example) {
        PageView<SupplierOrderItem> pageView = example.getPageView();
        List<SupplierOrderItem> items = this.supplierOrderItemMapper.selectSupplierOrderItemByPage(example);
        pageView.setQueryResult(items);
        return pageView;
    }

    @Override
    @CacheEvict(value={"supplierOrderItem"}, allEntries=true)
    public void updateBySupplierOrder(SupplierOrderItem supplierOrderItem, SupplierOrderItemExample supplierOrderItemExample) {
        this.supplierOrderItemMapper.updateByExampleSelective(supplierOrderItem, supplierOrderItemExample);
    }

    @Override
    @Cacheable(value={"supplierOrderItem"}, keyGenerator="redisKeyGenerator")
    public List<SupplierOrderItem> selectForExcel(SupplierOrderExample example) {
        return this.supplierOrderItemMapper.selectForExcel(example);
    }

    @Override
    public List<SupplierOrderItem> selectForExcelByOutstandingOrder(SupplierOrderExample supplierOrderExample) {
        return this.supplierOrderItemMapper.selectForExcelByOutstandingOrder(supplierOrderExample);
    }

    @Override
    public List<String> queryOrderIdByExample(SupplierOrderItemExample example) {
        return this.supplierOrderItemMapper.selectOrderIdByExample(example);
    }

    @Override
    @Cacheable(value={"supplierOrderItem"}, keyGenerator="redisKeyGenerator")
    public PageView<SupplierOrderItem> queryAllHisOrderItemByExample(SupplierOrderItemExample example) {
        PageView<SupplierOrderItem> pageView = example.getPageView();
        List<SupplierOrderItem> result = this.supplierOrderItemMapper.selectHisByExampleByPage(example);
        pageView.setQueryResult(result);
        return pageView;
    }
}

