/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.codegenerator.service.impl;

import com.els.base.codegenerator.entity.GenerateCode;
import com.els.base.codegenerator.service.GenerateStrategy;
import com.els.base.core.exception.CommonException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class AutoIncrementStrategy
extends GenerateStrategy {
    @Override
    public List<String> generateNextCode(GenerateCode currentCode, int quantity) {
        String code = currentCode.getCurrentCode();
        if (StringUtils.isBlank((String)code)) {
            code = currentCode.getStartCode();
        }
        if (StringUtils.isBlank((String)code)) {
            throw new CommonException("\u914d\u7f6e\u5f02\u5e38\uff0c\u7f16\u7801\u751f\u6210\u89c4\u5219\u4e2d\uff0c\u6ca1\u6709\u8d77\u59cb\u7f16\u7801");
        }
        if (code.equals(currentCode.getMaxCode())) {
            throw new CommonException("\u6d41\u6c34\u53f7\u5df2\u7ecf\u5230\u4e86\u6700\u5927\u503c\uff0c\u65e0\u6cd5\u751f\u6210\u6d41\u6c34\u53f7\u4e86");
        }
        BigDecimal bigDecimal = new BigDecimal(code);
        ArrayList<String> codeList = new ArrayList<String>();
        for (int i = 0; i < quantity; ++i) {
            bigDecimal = bigDecimal.add(new BigDecimal(1));
            codeList.add(bigDecimal.toString());
        }
        return codeList;
    }

    public static void main(String[] args) {
        GenerateCode code = new GenerateCode();
        code.setStartCode("50000");
        code.setPrefix("Do");
        AutoIncrementStrategy incrementStrategy = new AutoIncrementStrategy();
        List<String> result = incrementStrategy.generateNextCode(code, 10);
        System.out.println(result);
    }
}

