/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command.order;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.purchase.command.AbstractOrderCommand;
import com.els.base.purchase.command.OrderComandInvoker;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.SupplierOrder;
import com.els.base.purchase.entity.SupplierOrderItem;
import com.els.base.purchase.entity.SupplierOrderItemExample;
import com.els.base.purchase.event.SupReplyTimeEvent;
import com.els.base.purchase.utils.OrderBusinessTypeEnum;
import com.els.base.purchase.utils.PurchaseOrderStatusEnum;
import com.els.base.utils.SpringContextHolder;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.context.ApplicationEvent;

public class ConfirmTheWholeOrderCommand
extends AbstractOrderCommand<String> {
    private SupplierOrder supplierOrder;

    public ConfirmTheWholeOrderCommand(SupplierOrder order) {
        this.supplierOrder = order;
    }

    @Override
    public String execute(OrderComandInvoker context) {
        this.valid(this.supplierOrder);
        this.modifySupplierOrderAndItemsStatus();
        this.modifyPurchaseOrderAndItemsStatus();
        SpringContextHolder.getApplicationContext().publishEvent((ApplicationEvent)new SupReplyTimeEvent(this.supplierOrder));
        this.sendMessage();
        return null;
    }

    private void sendMessage() {
        Message message = Message.init((Object)this.supplierOrder).setCompanyCode(this.supplierOrder.getCompanySapCode()).setSenderId(this.getSupUser().getId()).addReceiverId(this.supplierOrder.getPurUserId()).setMsgLevel(MessageLevelEnum.HIGH).setBusinessTypeCode(OrderBusinessTypeEnum.PO_CONFIRM.getCode());
        MessageSendUtils.sendMessage((Message)message);
    }

    private void modifyPurchaseOrderAndItemsStatus() {
        String orderHisId = this.context.getPurchaseOrderService().insertHis(this.supplierOrder.getId(), "\u8ba2\u5355\u5934\u786e\u8ba4");
        this.context.getPurchaseOrderItemService().insertHisByOrderId(orderHisId, this.supplierOrder.getId(), "\u8ba2\u5355\u5934\u786e\u8ba4");
        PurchaseOrder record = new PurchaseOrder();
        record.setId(this.supplierOrder.getId());
        record.setSupRemark(this.supplierOrder.getSupRemark());
        record.setOrderStatus(PurchaseOrderStatusEnum.CONFIRM.getValue());
        record.setLastUpdateTime(new Date());
        record.setSupUserId(this.getSupUser().getId());
        record.setSupUserName(this.getSupUser().getNickName());
        this.context.getPurchaseOrderService().modifyObj(record);
        List<SupplierOrderItem> supplierOrderItems = this.supplierOrder.getItems();
        for (SupplierOrderItem supplierOrderItem : supplierOrderItems) {
            PurchaseOrderItem recordItem = new PurchaseOrderItem();
            recordItem.setId(supplierOrderItem.getId());
            recordItem.setSupRemark(supplierOrderItem.getSupRemark());
            recordItem.setOrderStatus(PurchaseOrderStatusEnum.CONFIRM.getValue());
            recordItem.setSupUserId(this.getSupUser().getId());
            recordItem.setSupUserName(this.getSupUser().getNickName());
            this.context.getPurchaseOrderItemService().modifyObj(recordItem);
        }
    }

    private void modifySupplierOrderAndItemsStatus() {
        String orderHisId = this.context.getSupplierOrderService().insertHis(this.supplierOrder.getId(), "\u8ba2\u5355\u5934\u786e\u8ba4");
        this.context.getSupplierOrderItemService().insertHisByOrderId(orderHisId, this.supplierOrder.getId(), "\u8ba2\u5355\u5934\u786e\u8ba4");
        SupplierOrder record = new SupplierOrder();
        record.setId(this.supplierOrder.getId());
        record.setOrderStatus(PurchaseOrderStatusEnum.CONFIRM.getValue());
        record.setSupRemark(this.supplierOrder.getSupRemark());
        record.setUserName(this.getSupUser().getNickName());
        record.setUserId(this.getSupUser().getId());
        record.setLastUpdateTime(new Date());
        this.context.getSupplierOrderService().modifyObj(record);
        SupplierOrderItemExample exampleItem = new SupplierOrderItemExample();
        exampleItem.createCriteria().andCompanyIdEqualTo(this.supplierOrder.getCompanyId()).andOrderIdEqualTo(this.supplierOrder.getId());
        List<SupplierOrderItem> supplierOrderItems = this.context.getSupplierOrderItemService().queryAllObjByExample(exampleItem);
        for (SupplierOrderItem supplierOrderItem : supplierOrderItems) {
            SupplierOrderItem recordItem = new SupplierOrderItem();
            recordItem.setId(supplierOrderItem.getId());
            recordItem.setOrderStatus(PurchaseOrderStatusEnum.CONFIRM.getValue());
            recordItem.setUserId(this.getSupUser().getId());
            recordItem.setUserName(this.getSupUser().getNickName());
            recordItem.setUpdateTime(new Date());
            recordItem.setSupRemark(supplierOrderItem.getSupRemark());
            this.context.getSupplierOrderItemService().modifyObj(recordItem);
        }
        this.supplierOrder.setItems(supplierOrderItems);
    }

    private void valid(SupplierOrder order) {
        if (order.getSupRemark() != null && order.getSupRemark().length() > 255) {
            throw new CommonException("\u8f93\u5165\u7684\u53c2\u6570\u957f\u5ea6\u8d85\u6807", "database_length_error");
        }
        if (CollectionUtils.isNotEmpty(order.getItems())) {
            for (SupplierOrderItem item : order.getItems()) {
                Assert.isNotBlank(item.getId(), "\u8ba2\u5355\u884cID\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        this.context.getSupplierOrderService().isHaveNewOrder(this.supplierOrder);
    }
}

