/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.notice.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.mould.notice.dao.MouldNoticePlanMapper;
import com.els.base.mould.notice.entity.MouldNoticePlan;
import com.els.base.mould.notice.entity.MouldNoticePlanExample;
import com.els.base.mould.notice.service.MouldNoticePlanService;
import com.els.base.mould.notice.vo.MouldNoticeColumnData;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultMouldNoticePlanService")
public class MouldNoticePlanServiceImpl
implements MouldNoticePlanService {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @Resource
    protected MouldNoticePlanMapper mouldNoticePlanMapper;

    @Override
    @CacheEvict(value={"mouldNoticePlan"}, allEntries=true)
    public void addObj(MouldNoticePlan t) {
        this.mouldNoticePlanMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"mouldNoticePlan"}, allEntries=true)
    public void deleteObjById(String id) {
        this.mouldNoticePlanMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"mouldNoticePlan"}, allEntries=true)
    public void modifyObj(MouldNoticePlan t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.mouldNoticePlanMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"mouldNoticePlan"}, keyGenerator="redisKeyGenerator")
    public MouldNoticePlan queryObjById(String id) {
        return this.mouldNoticePlanMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"mouldNoticePlan"}, keyGenerator="redisKeyGenerator")
    public List<MouldNoticePlan> queryAllObjByExample(MouldNoticePlanExample example) {
        return this.mouldNoticePlanMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"mouldNoticePlan"}, keyGenerator="redisKeyGenerator")
    public PageView<MouldNoticePlan> queryObjByPage(MouldNoticePlanExample example) {
        PageView<MouldNoticePlan> pageView = example.getPageView();
        pageView.setQueryResult(this.mouldNoticePlanMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"mouldNoticePlan"}, allEntries=true)
    public void deleteByNoticeId(String noticeId) {
        MouldNoticePlanExample example = new MouldNoticePlanExample();
        example.createCriteria().andMouldNoticeIdEqualTo(noticeId);
        this.mouldNoticePlanMapper.deleteByExample(example);
    }

    @Override
    @CacheEvict(value={"mouldNoticePlan"}, allEntries=true)
    public void modifyPlanData(MouldNoticeColumnData data) {
        MouldNoticePlan plan = new MouldNoticePlan();
        plan.setId(data.getId());
        plan.setUpdateTime(new Date());
        switch (data.getField()) {
            case "planCompleteTime": {
                Date planCompleteTime = null;
                if (data.getValue() != null) {
                    String formatPlanCompleteTime = sdf.format(Long.parseLong(data.getValue().toString()));
                    try {
                        planCompleteTime = sdf.parse(formatPlanCompleteTime);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                plan.setPlanCompleteTime(planCompleteTime);
                this.modifyPlanCompleteTime(plan);
                break;
            }
            case "actualCompleteTime": {
                Date actualCompleteTime = null;
                if (data.getValue() != null) {
                    String formatActualCompleteTime = sdf.format(Long.parseLong(data.getValue().toString()));
                    try {
                        actualCompleteTime = sdf.parse(formatActualCompleteTime);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                plan.setActualCompleteTime(actualCompleteTime);
                this.modifyActualCompleteTime(plan);
                break;
            }
            case "planPicture": {
                String planPicture = (String)data.getValue();
                plan.setPlanPicture(planPicture);
                this.modifyPlanPicture(plan);
                break;
            }
        }
    }

    @Override
    @CacheEvict(value={"mouldNoticePlan"}, allEntries=true)
    public void modifyActualCompleteTime(MouldNoticePlan t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.mouldNoticePlanMapper.modifyActualCompleteTime(t);
    }

    @Override
    @CacheEvict(value={"mouldNoticePlan"}, allEntries=true)
    public void modifyPlanPicture(MouldNoticePlan t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.mouldNoticePlanMapper.modifyPlanPicture(t);
    }

    @Override
    @CacheEvict(value={"mouldNoticePlan"}, allEntries=true)
    public void modifyPlanCompleteTime(MouldNoticePlan t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.mouldNoticePlanMapper.modifyPlanCompleteTime(t);
    }
}

