/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.command.jit.plan;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.plan.command.jit.plan.CreateJitChangeRecordCmd;
import com.els.base.plan.command.jit.plan.ModifyJitPlanAllocatedCmd;
import com.els.base.plan.entity.DeliveryPlan;
import com.els.base.plan.entity.DeliveryPlanExample;
import com.els.base.plan.entity.PurDeliveryPlanItem;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.plan.entity.SupDeliveryPlanItemExample;
import com.els.base.plan.utils.DeliveryPlanUesdStatusEnum;
import com.els.base.plan.utils.JitPlanUtils;
import com.els.base.utils.uuid.UUIDGenerator;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;

public class ModifyJitPlanCommand
extends AbstractCommand {
    private static Boolean arryvalTimeChange = false;
    private static Boolean deliveryQuantityChange = false;
    private static Boolean divide = false;
    private static SupDeliveryPlanItem planItem = null;
    private DeliveryPlan deliveryPlan;

    public ModifyJitPlanCommand(DeliveryPlan deliveryPlan) {
        this.deliveryPlan = deliveryPlan;
    }

    public Object execute(ICommandInvoker context) {
        this.vaidMust(this.deliveryPlan);
        ArrayList<SupDeliveryPlanItem> planItemLog = new ArrayList<SupDeliveryPlanItem>();
        if (this.deliveryPlan.getIsAllocated() == 0) {
            this.notAllocatChange(this.deliveryPlan);
        } else {
            List<SupDeliveryPlanItem> items;
            planItem = (SupDeliveryPlanItem)ContextUtils.getSupDeliveryPlanItemService().queryObjById(this.deliveryPlan.getItemId());
            arryvalTimeChange = planItem.getDeliveryDate().compareTo(this.deliveryPlan.getArryvalTime()) != 0;
            deliveryQuantityChange = planItem.getDeliveryQuantity().compareTo(this.deliveryPlan.getDeliveryQuantity()) != 0;
            divide = planItem.getDeliveryQuantity().compareTo(this.deliveryPlan.getDeliveryQuantity()) <= 0;
            this.vaidUserStatusAndNum(this.deliveryPlan, planItem);
            if (!arryvalTimeChange.booleanValue() && deliveryQuantityChange.booleanValue()) {
                SupDeliveryPlanItem item2 = this.onlyQuantityChange(this.deliveryPlan, planItem.getDeliveryQuantity());
                planItemLog.add(item2);
            }
            if (arryvalTimeChange.booleanValue() && !deliveryQuantityChange.booleanValue()) {
                items = this.onlyTimeChange(this.deliveryPlan, BigDecimal.ZERO.subtract(planItem.getDeliveryQuantity()));
                planItemLog.addAll(items);
            }
            if (arryvalTimeChange.booleanValue() && deliveryQuantityChange.booleanValue()) {
                items = this.allChange(this.deliveryPlan, BigDecimal.ZERO.subtract(this.deliveryPlan.getDeliveryQuantity()));
                planItemLog.addAll(items);
            }
        }
        if (CollectionUtils.isNotEmpty(planItemLog)) {
            CreateJitChangeRecordCmd command = new CreateJitChangeRecordCmd(planItemLog);
            context.invoke(command);
            planItemLog.stream().forEach(item -> this.modifyPlanItem((SupDeliveryPlanItem)item));
            this.setIsAllocated(planItemLog);
        }
        return null;
    }

    private void vaidUserStatusAndNum(DeliveryPlan plan, SupDeliveryPlanItem item) {
        if (DeliveryPlanUesdStatusEnum.COLSE_SUCCESS.getValue().equals(item.getUsedStatus())) {
            throw new CommonException("\u9001\u8d27\u901a\u77e5\u5df2\u5173\u95ed\uff0c\u4e0d\u80fd\u4fee\u6539");
        }
        if (DeliveryPlanUesdStatusEnum.PART_USED.getValue().equals(item.getUsedStatus()) || DeliveryPlanUesdStatusEnum.ALL_USED.getValue().equals(item.getUsedStatus())) {
            if (arryvalTimeChange.booleanValue()) {
                throw new CommonException("\u4fee\u6539\u5931\u8d25\uff1a\u5b58\u5728\u53d1\u8d27\u5355\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u65f6\u95f4");
            }
            item.setId(item.getId());
            BigDecimal num = item.getOnwayQuantity().add(item.getReceivedQuantity());
            if (plan.getDeliveryQuantity().compareTo(num) > 0) {
                item.setUsedStatus(DeliveryPlanUesdStatusEnum.PART_USED.getValue());
                item.setIsCanDelivery(Constant.YES_INT);
            }
            if (plan.getDeliveryQuantity().compareTo(num) == 0) {
                item.setUsedStatus(DeliveryPlanUesdStatusEnum.ALL_USED.getValue());
                item.setIsCanDelivery(Constant.NO_INT);
            }
            if (plan.getDeliveryQuantity().compareTo(num) < 0) {
                throw new CommonException(MessageFormat.format("\u4fee\u6539\u5931\u8d25\uff1a\u5206\u914d\u6570\u91cf\u5c0f\u4e8e\u5df2\u53d1\u8d27\u6570\u91cf{0}", num));
            }
        }
        BigDecimal undistributNum = JitPlanUtils.getUndistributNum(plan.getSupCompanySapCode(), plan.getFactoryCode(), plan.getMaterialCode(), plan.getSupCompanyName());
        undistributNum = undistributNum.add(item.getDeliveryQuantity());
        if (plan.getDeliveryQuantity().compareTo(undistributNum) > 0) {
            throw new CommonException(MessageFormat.format("\u4fee\u6539\u5931\u8d25\uff1a\u5206\u914d\u6570\u91cf\u5927\u4e8e\u53ef\u5206\u914d\u6570\u91cf{0}", undistributNum));
        }
    }

    private void setIsAllocated(List<SupDeliveryPlanItem> planItemLog) {
        List planId = planItemLog.stream().map(item -> item.getPlanId()).collect(Collectors.toList());
        SupDeliveryPlanItemExample example = new SupDeliveryPlanItemExample();
        example.createCriteria().andPlanIdIn(planId);
        List lists = ContextUtils.getSupDeliveryPlanItemService().queryAllObjByExample((IExample)example);
        ModifyJitPlanAllocatedCmd cmd = new ModifyJitPlanAllocatedCmd(lists);
        this.context.invoke(cmd);
    }

    private void vaidMust(DeliveryPlan deliveryPlan) {
        Assert.isNotNull((Object)deliveryPlan.getArryvalTime(), (String)"\u8981\u6c42\u5230\u8d27\u65f6\u95f4\u4e3a\u7a7a");
        if (deliveryPlan.getArryvalTime().getTime() < System.currentTimeMillis()) {
            throw new CommonException("\u8981\u6c42\u5230\u8d27\u65f6\u95f4\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4");
        }
        if (StringUtils.isNotBlank((String)deliveryPlan.getSupCompanySapCode())) {
            Assert.isNotNull((Object)deliveryPlan.getDeliveryQuantity(), (String)"\u5206\u914d\u6570\u91cf\u4e3a\u7a7a");
            if (deliveryPlan.getDeliveryQuantity().compareTo(BigDecimal.ZERO) <= 0) {
                throw new CommonException("\u5206\u914d\u6570\u91cf\u9700\u5927\u4e8e\u96f6");
            }
        }
    }

    private void notAllocatChange(DeliveryPlan plan) {
        this.modifyOldPlan(plan, plan.getConsumeMunber());
        DeliveryPlan exitPlan = this.getPlanByArraryTime(plan);
        if (exitPlan != null) {
            this.modifyOldPlan(exitPlan, plan.getConsumeMunber());
        } else {
            exitPlan = plan;
            exitPlan.setIsAllocated(Constant.NO_INT);
            ContextUtils.getDeliveryPlanService().modifyObj(exitPlan);
        }
    }

    private List<SupDeliveryPlanItem> allChange(DeliveryPlan deliveryPlan, BigDecimal deliveryQuantity) {
        return this.onlyTimeChange(deliveryPlan, deliveryQuantity);
    }

    private List<SupDeliveryPlanItem> onlyTimeChange(DeliveryPlan deliveryPlan, BigDecimal quantity) {
        this.modifyOldPlan(deliveryPlan, quantity);
        return this.mergerPlanByArraryTime(deliveryPlan);
    }

    private SupDeliveryPlanItem onlyQuantityChange(DeliveryPlan plan, BigDecimal deliveryQuantity) {
        SupDeliveryPlanItem item = this.modityPlanItem(plan);
        BigDecimal quantity = plan.getDeliveryQuantity().subtract(deliveryQuantity);
        this.modifyOldPlan(plan, quantity);
        return item;
    }

    private SupDeliveryPlanItem modityPlanItem(DeliveryPlan plan) {
        if (BigDecimal.ZERO.compareTo(plan.getDeliveryQuantity()) >= 0) {
            planItem.setIsEnable(Constant.NO_INT);
        } else {
            planItem.setDeliveryQuantity(plan.getDeliveryQuantity());
        }
        return planItem;
    }

    private List<SupDeliveryPlanItem> mergerPlanByArraryTime(DeliveryPlan plan) {
        ArrayList<SupDeliveryPlanItem> items = new ArrayList<SupDeliveryPlanItem>();
        DeliveryPlan exitPlan = this.getPlanByArraryTime(plan);
        if (exitPlan != null) {
            items.addAll(this.buildPlanItem(exitPlan, plan));
            this.modifyOldPlan(exitPlan, plan.getDeliveryQuantity());
        } else {
            items.addAll(this.createNewPlan(plan));
        }
        return items;
    }

    private DeliveryPlan getPlanByArraryTime(DeliveryPlan plan) {
        SupDeliveryPlanItemExample example = new SupDeliveryPlanItemExample();
        example.createCriteria().andMaterialNoEqualTo(planItem.getMaterialNo()).andFactoryCodeEqualTo(planItem.getFactoryCode()).andDeliveryDateEqualTo(plan.getArryvalTime()).andSupCompanySapCodeEqualTo(planItem.getSupCompanySapCode()).andIsEnableEqualTo(Constant.YES_INT);
        List items = ContextUtils.getSupDeliveryPlanItemService().queryAllObjByExample((IExample)example);
        if (CollectionUtils.isNotEmpty((Collection)items)) {
            throw new CommonException("\u8be5\u65f6\u6bb5\u5df2\u6709\u9700\u6c42");
        }
        DeliveryPlanExample deliveryPlanExample = new DeliveryPlanExample();
        deliveryPlanExample.createCriteria().andMaterialCodeEqualTo(plan.getMaterialCode()).andFactoryCodeEqualTo(plan.getFactoryCode()).andArryvalTimeEqualTo(plan.getArryvalTime()).andIsEnableEqualTo(Constant.YES_INT);
        List lists = ContextUtils.getDeliveryPlanService().queryAllObjByExample((IExample)deliveryPlanExample);
        if (CollectionUtils.isNotEmpty((Collection)lists)) {
            return (DeliveryPlan)lists.get(0);
        }
        return null;
    }

    private List<SupDeliveryPlanItem> createNewPlan(DeliveryPlan plan) {
        DeliveryPlan newPlan = new DeliveryPlan();
        BeanUtils.copyProperties((Object)plan, (Object)newPlan);
        newPlan.setId(UUIDGenerator.generateUUID());
        newPlan.setConsumeMunber(plan.getDeliveryQuantity());
        newPlan.setUsedStatus("N");
        newPlan.setDeliveryDate(null);
        newPlan.setStatus(Constant.NO_INT);
        newPlan.setIsEnable(Constant.YES_INT);
        newPlan.setIsAllocated(Constant.YES_INT);
        List<SupDeliveryPlanItem> items = this.buildPlanItem(newPlan, plan);
        ContextUtils.getDeliveryPlanService().addObj(newPlan);
        return items;
    }

    private List<SupDeliveryPlanItem> buildPlanItem(DeliveryPlan megerPlan, DeliveryPlan plan) {
        ArrayList<SupDeliveryPlanItem> items = new ArrayList<SupDeliveryPlanItem>();
        if (divide.booleanValue()) {
            planItem.setDeliveryDate(plan.getArryvalTime());
            planItem.setPlanId(megerPlan.getId());
            planItem.setPlanSendStatus(megerPlan.getStatus() == 0 ? "N" : "Y");
            planItem.setDeliveryQuantity(plan.getDeliveryQuantity());
            planItem.setConsumeMunber(megerPlan.getConsumeMunber());
        } else {
            planItem.setConsumeMunber(megerPlan.getConsumeMunber());
            planItem.setDeliveryQuantity(planItem.getDeliveryQuantity().subtract(plan.getDeliveryQuantity()));
            items.add(this.createNewPlanItem(megerPlan, plan.getDeliveryQuantity()));
        }
        items.add(planItem);
        return items;
    }

    private SupDeliveryPlanItem createNewPlanItem(DeliveryPlan megerPlan, BigDecimal deliveryQuantity) {
        SupDeliveryPlanItem supDeliveryPlanItem = new SupDeliveryPlanItem();
        BeanUtils.copyProperties((Object)planItem, (Object)supDeliveryPlanItem);
        supDeliveryPlanItem.setId(UUIDGenerator.generateUUID());
        supDeliveryPlanItem.setDeliveryDate(megerPlan.getArryvalTime());
        supDeliveryPlanItem.setPlanId(megerPlan.getId());
        supDeliveryPlanItem.setPlanSendStatus(megerPlan.getStatus() == 0 ? "N" : "Y");
        supDeliveryPlanItem.setDeliveryQuantity(deliveryQuantity);
        supDeliveryPlanItem.setConsumeMunber(megerPlan.getConsumeMunber());
        supDeliveryPlanItem.setIsEnable(Constant.YES_INT);
        supDeliveryPlanItem.setUsedStatus(DeliveryPlanUesdStatusEnum.UN_USED.getValue());
        supDeliveryPlanItem.setIsCanDelivery(Constant.YES_INT);
        return supDeliveryPlanItem;
    }

    private void modifyOldPlan(DeliveryPlan plan, BigDecimal quantity) {
        BigDecimal ConsumeMunber = plan.getConsumeMunber().add(quantity);
        DeliveryPlan deliveryPlan = new DeliveryPlan();
        deliveryPlan.setIsAllocated(Constant.NO_INT);
        deliveryPlan.setId(plan.getId());
        if (ConsumeMunber.compareTo(BigDecimal.ZERO) <= 0) {
            deliveryPlan.setConsumeMunber(BigDecimal.ZERO);
            deliveryPlan.setIsEnable(Constant.NO_INT);
            ContextUtils.getDeliveryPlanService().modifyObj(deliveryPlan);
        } else {
            deliveryPlan.setConsumeMunber(ConsumeMunber);
            ContextUtils.getDeliveryPlanService().modifyObj(deliveryPlan);
            ContextUtils.getSupDeliveryPlanItemService().updateConsumeMunber(deliveryPlan.getId(), ConsumeMunber);
            ContextUtils.getPurDeliveryPlanItemService().updateConsumeMunber(deliveryPlan.getId(), ConsumeMunber);
        }
    }

    private void modifyPlanItem(SupDeliveryPlanItem item) {
        item.setPurUserId(this.getPurUser().getId());
        item.setPurUserName(this.getPurUser().getNickName());
        PurDeliveryPlanItem purPlanItem = new PurDeliveryPlanItem();
        BeanUtils.copyProperties((Object)item, (Object)purPlanItem);
        if (ContextUtils.getSupDeliveryPlanItemService().queryObjById(item.getId()) == null) {
            ContextUtils.getSupDeliveryPlanItemService().addObj(item);
            ContextUtils.getPurDeliveryPlanItemService().addObj(purPlanItem);
        } else {
            ContextUtils.getSupDeliveryPlanItemService().modifyObj(item);
            ContextUtils.getPurDeliveryPlanItemService().modifyObj(purPlanItem);
        }
    }
}

