/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.plan.dao.DeliveryChangePlanMapper;
import com.els.base.plan.entity.DeliveryChangePlan;
import com.els.base.plan.entity.DeliveryChangePlanExample;
import com.els.base.plan.service.DeliveryChangePlanService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultDeliveryChangePlanService")
public class DeliveryChangePlanServiceImpl
implements DeliveryChangePlanService {
    @Resource
    protected DeliveryChangePlanMapper deliveryChangePlanMapper;

    @CacheEvict(value={"deliveryChangePlan"}, allEntries=true)
    public void addObj(DeliveryChangePlan t) {
        this.deliveryChangePlanMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"deliveryChangePlan"}, allEntries=true)
    public void addAll(List<DeliveryChangePlan> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.deliveryChangePlanMapper.insertBatch(list);
    }

    @CacheEvict(value={"deliveryChangePlan"}, allEntries=true)
    public void deleteObjById(String id) {
        this.deliveryChangePlanMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"deliveryChangePlan"}, allEntries=true)
    public void modifyObj(DeliveryChangePlan t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.deliveryChangePlanMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"deliveryChangePlan"}, keyGenerator="redisKeyGenerator")
    public DeliveryChangePlan queryObjById(String id) {
        return this.deliveryChangePlanMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"deliveryChangePlan"}, keyGenerator="redisKeyGenerator")
    public List<DeliveryChangePlan> queryAllObjByExample(DeliveryChangePlanExample example) {
        return this.deliveryChangePlanMapper.selectByExample(example);
    }

    @Cacheable(value={"deliveryChangePlan"}, keyGenerator="redisKeyGenerator")
    public PageView<DeliveryChangePlan> queryObjByPage(DeliveryChangePlanExample example) {
        PageView<DeliveryChangePlan> pageView = example.getPageView();
        pageView.setQueryResult(this.deliveryChangePlanMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value={"deliveryChangePlan"}, allEntries=true)
    public void deleteByExample(DeliveryChangePlanExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.deliveryChangePlanMapper.deleteByExample(example);
    }
}

