/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.service.impl;

import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.plan.dao.JITLeadTimeMapper;
import com.els.base.plan.entity.JITLeadTime;
import com.els.base.plan.entity.JITLeadTimeDetail;
import com.els.base.plan.entity.JITLeadTimeDetailExample;
import com.els.base.plan.entity.JITLeadTimeExample;
import com.els.base.plan.service.JITLeadTimeDetailService;
import com.els.base.plan.service.JITLeadTimeService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultJITLeadTimeService")
public class JITLeadTimeServiceImpl
implements JITLeadTimeService {
    @Resource
    protected JITLeadTimeMapper jITLeadTimeMapper;
    @Resource
    protected JITLeadTimeDetailService jitLeadTimeDetailService;

    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(value={"jITLeadTime"}, allEntries=true)
    public void addObj(JITLeadTime t) {
        Assert.isNotBlank((String)t.getFactoryCode(), (String)"\u5de5\u5382\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(t.getItems(), (String)"\u9879\u76ee\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        JITLeadTimeExample leadTimeExample = new JITLeadTimeExample();
        JITLeadTimeExample.Criteria criteria = leadTimeExample.createCriteria();
        criteria.andFactoryCodeEqualTo(t.getFactoryCode());
        if (StringUtils.isNotBlank((String)t.getMaterialCode())) {
            criteria.andMaterialCodeEqualTo(t.getMaterialCode());
        } else {
            criteria.andMaterialCodeIsNull();
        }
        List<JITLeadTime> lists = this.queryAllObjByExample(leadTimeExample);
        if (CollectionUtils.isNotEmpty(lists)) {
            throw new CommonException("\u65b0\u589e\u5931\u8d25\uff0c\u63d0\u524d\u671f\u5df2\u5b58\u5728");
        }
        String code = UUIDGenerator.generateUUID();
        t.setLeadTimeCode(code);
        List<JITLeadTimeDetail> jitLeadTimeDetailList = this.getjitLeadTimeDetailList(t.getItems(), t.getLeadTimeCode());
        this.jitLeadTimeDetailService.addAll(jitLeadTimeDetailList);
        this.jITLeadTimeMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"jITLeadTime"}, allEntries=true)
    public void addAll(List<JITLeadTime> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.jITLeadTimeMapper.insertBatch(list);
    }

    @CacheEvict(value={"jITLeadTime"}, allEntries=true)
    public void deleteObjById(String id) {
        this.jITLeadTimeMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"jITLeadTime"}, allEntries=true)
    public void deleteObjByCodes(List<String> codes) {
        JITLeadTimeDetailExample example = new JITLeadTimeDetailExample();
        example.createCriteria().andJitLeadTimeCodeIn((List)codes);
        this.jitLeadTimeDetailService.deleteObjByExampl(example);
        JITLeadTimeExample timeExample = new JITLeadTimeExample();
        timeExample.createCriteria().andLeadTimeCodeIn((List)codes);
        this.jITLeadTimeMapper.deleteByExample(timeExample);
    }

    @Override
    @Cacheable(value={"jITLeadTime"}, keyGenerator="redisKeyGenerator")
    public JITLeadTime queryObjByExample(JITLeadTimeExample example) {
        List<JITLeadTime> lists = this.jITLeadTimeMapper.selectByExample(example);
        if (lists.size() > 0) {
            JITLeadTime jitLeadTime = lists.get(0);
            List<JITLeadTimeDetail> detailLists = this.getjitLeadTimeDetailListByCode(jitLeadTime.getLeadTimeCode());
            jitLeadTime.setItems(detailLists);
            return jitLeadTime;
        }
        return null;
    }

    @CacheEvict(value={"jITLeadTime"}, allEntries=true)
    public void modifyObj(JITLeadTime t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        Assert.isNotBlank((String)t.getFactoryCode(), (String)"\u5de5\u5382\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(t.getItems(), (String)"\u9879\u76ee\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        JITLeadTimeDetailExample example = new JITLeadTimeDetailExample();
        example.createCriteria().andJitLeadTimeCodeEqualTo(t.getLeadTimeCode());
        this.jitLeadTimeDetailService.deleteObjByExampl(example);
        List<JITLeadTimeDetail> jitLeadTimeDetailList = this.getjitLeadTimeDetailList(t.getItems(), t.getLeadTimeCode());
        this.jitLeadTimeDetailService.addAll(jitLeadTimeDetailList);
        this.jITLeadTimeMapper.updateByPrimaryKey(t);
    }

    @Cacheable(value={"jITLeadTime"}, keyGenerator="redisKeyGenerator")
    public JITLeadTime queryObjById(String id) {
        JITLeadTime jitLeadTime = this.jITLeadTimeMapper.selectByPrimaryKey(id);
        jitLeadTime.setItems(this.getjitLeadTimeDetailListByCode(jitLeadTime.getLeadTimeCode()));
        return jitLeadTime;
    }

    @Cacheable(value={"jITLeadTime"}, keyGenerator="redisKeyGenerator")
    public List<JITLeadTime> queryAllObjByExample(JITLeadTimeExample example) {
        return this.jITLeadTimeMapper.selectByExample(example);
    }

    @Cacheable(value={"jITLeadTime"}, keyGenerator="redisKeyGenerator")
    public PageView<JITLeadTime> queryObjByPage(JITLeadTimeExample example) {
        PageView<JITLeadTime> pageView = example.getPageView();
        pageView.setQueryResult(this.jITLeadTimeMapper.selectByExampleByPage(example));
        return pageView;
    }

    private List<JITLeadTimeDetail> getjitLeadTimeDetailList(List<JITLeadTimeDetail> items, String leadTimeCode) {
        List<JITLeadTimeDetail> jitLeadTimeDetailList = items.stream().map(v -> {
            v.setJitLeadTimeCode(leadTimeCode);
            return v;
        }).collect(Collectors.toList());
        return jitLeadTimeDetailList;
    }

    private List<JITLeadTimeDetail> getjitLeadTimeDetailListByCode(String leadTimeCode) {
        JITLeadTimeDetailExample detailExample = new JITLeadTimeDetailExample();
        detailExample.createCriteria().andJitLeadTimeCodeEqualTo(leadTimeCode);
        return this.jitLeadTimeDetailService.queryAllObjByExample((IExample)detailExample);
    }

    @CacheEvict(value={"jITLeadTime"}, allEntries=true)
    public void deleteByExample(JITLeadTimeExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.jITLeadTimeMapper.deleteByExample(example);
    }
}

