/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.plan.dao.JITMaterialDemandMapper;
import com.els.base.plan.entity.JITMaterialDemand;
import com.els.base.plan.entity.JITMaterialDemandExample;
import com.els.base.plan.service.JITMaterialDemandService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultJITMaterialDemandService")
public class JITMaterialDemandServiceImpl
implements JITMaterialDemandService {
    @Resource
    protected JITMaterialDemandMapper jITMaterialDemandMapper;

    @CacheEvict(value={"jITMaterialDemand"}, allEntries=true)
    public void addObj(JITMaterialDemand t) {
        this.jITMaterialDemandMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"jITMaterialDemand"}, allEntries=true)
    public void addAll(List<JITMaterialDemand> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.jITMaterialDemandMapper.insertBatch(list);
    }

    @CacheEvict(value={"jITMaterialDemand"}, allEntries=true)
    public void deleteObjById(String id) {
        this.jITMaterialDemandMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"jITMaterialDemand"}, allEntries=true)
    public void modifyObj(JITMaterialDemand t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.jITMaterialDemandMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"jITMaterialDemand"}, keyGenerator="redisKeyGenerator")
    public JITMaterialDemand queryObjById(String id) {
        return this.jITMaterialDemandMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"jITMaterialDemand"}, keyGenerator="redisKeyGenerator")
    public List<JITMaterialDemand> queryAllObjByExample(JITMaterialDemandExample example) {
        return this.jITMaterialDemandMapper.selectByExample(example);
    }

    @Cacheable(value={"jITMaterialDemand"}, keyGenerator="redisKeyGenerator")
    public PageView<JITMaterialDemand> queryObjByPage(JITMaterialDemandExample example) {
        PageView<JITMaterialDemand> pageView = example.getPageView();
        pageView.setQueryResult(this.jITMaterialDemandMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public List<Map<String, Object>> getApsMaterial() {
        return this.jITMaterialDemandMapper.selectApsMaterialDemand();
    }

    @Override
    @CacheEvict(value={"jITMaterialDemand"}, allEntries=true)
    public void updateAps(String factory, String materialCode) {
        this.jITMaterialDemandMapper.updateApsAll(factory, materialCode);
    }

    @CacheEvict(value={"jITMaterialDemand"}, allEntries=true)
    public void deleteByExample(JITMaterialDemandExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.jITMaterialDemandMapper.deleteByExample(example);
    }
}

