/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command.order.sup;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.utils.Assert;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.SupplierOrder;
import com.els.base.purchase.entity.SupplierOrderItem;
import com.els.base.purchase.utils.ChangeTypeEnum;
import com.els.base.purchase.utils.IsRefuseStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderConfirmStatusEnum;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public class ConfirmOrderItemCommand
extends AbstractCommand<String> {
    private static final long serialVersionUID = 1L;
    private SupplierOrderItem supplierOrderItem;
    private SupplierOrder supplierOrder;

    public ConfirmOrderItemCommand(SupplierOrderItem supplierOrderItem, SupplierOrder supplierOrder) {
        this.supplierOrderItem = supplierOrderItem;
        this.supplierOrder = supplierOrder;
    }

    @Override
    public String execute(ICommandInvoker context) {
        Assert.isNotNull((Object)this.supplierOrderItem);
        Assert.isNotBlank((String)this.supplierOrderItem.getId(), (String)"\u8ba2\u5355\u884cId\u4e0d\u80fd\u4e3a\u7a7a");
        Date now = new Date();
        this.supplierOrderItem.setOrderStatus(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue());
        this.supplierOrderItem.setHaveChange(ChangeTypeEnum.OLD_ITEM.getValue());
        this.supplierOrderItem.setIsRefuseDeliveredDate(IsRefuseStatusEnum.NO_REFUSE.getValue());
        this.supplierOrderItem.setIsRefusePrice(IsRefuseStatusEnum.NO_REFUSE.getValue());
        this.supplierOrderItem.setIsRefuseQuantity(IsRefuseStatusEnum.NO_REFUSE.getValue());
        if (this.getSupUser() != null) {
            this.supplierOrderItem.setSupUserId(this.getSupUser().getId());
            this.supplierOrderItem.setSupUserName(this.getSupUser().getNickName());
        }
        this.supplierOrderItem.setUpdateTime(now);
        if (StringUtils.isBlank((String)this.supplierOrderItem.getSupRemark())) {
            this.supplierOrderItem.setSupRemark("");
        }
        ContextUtils.getSupplierOrderItemService().modifyObj(this.supplierOrderItem);
        PurchaseOrderItem recordItem = new PurchaseOrderItem();
        recordItem.setId(this.supplierOrderItem.getId());
        recordItem.setOrderStatus(this.supplierOrderItem.getOrderStatus());
        recordItem.setHaveChange(ChangeTypeEnum.OLD_ITEM.getValue());
        recordItem.setIsRefuseDeliveredDate(IsRefuseStatusEnum.NO_REFUSE.getValue());
        recordItem.setIsRefusePrice(IsRefuseStatusEnum.NO_REFUSE.getValue());
        recordItem.setIsRefuseQuantity(IsRefuseStatusEnum.NO_REFUSE.getValue());
        if (this.getSupUser() != null) {
            recordItem.setSupUserId(this.getSupUser().getId());
            recordItem.setSupUserName(this.getSupUser().getNickName());
        }
        recordItem.setUpdateTime(now);
        if (StringUtils.isBlank((String)this.supplierOrderItem.getSupRemark())) {
            recordItem.setSupRemark("");
        } else {
            recordItem.setSupRemark(this.supplierOrderItem.getSupRemark());
        }
        ContextUtils.getPurchaseOrderItemService().modifyObj(recordItem);
        return null;
    }
}

