/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.delivery.command;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.delivery.command.WriteBackToErpCommand;
import com.els.base.delivery.entity.DeliveryOrder;
import com.els.base.delivery.entity.DeliveryOrderItem;
import com.els.base.delivery.entity.DeliveryOrderItemExample;
import com.els.base.delivery.utils.DeliveryOperateEnum;
import com.els.base.delivery.utils.DeliveryStatusEnum;
import com.els.base.plan.command.BatchModifyPlanIsCanDeliveryCmd;
import com.els.base.plan.command.ModifyPlanOnWayQuantityCmd;
import com.els.base.purchase.command.order.ModifyOrderItemOnWayQuantityCmd;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class BatchCancelDeliveryItemCommand
extends AbstractCommand<String> {
    private static final long serialVersionUID = 1L;
    private List<String> deliveryOrderItemIdList;

    public BatchCancelDeliveryItemCommand(List<String> deliveryOrderItemIdList) {
        this.deliveryOrderItemIdList = deliveryOrderItemIdList;
    }

    @Override
    public String execute(ICommandInvoker context) {
        Assert.isNotEmpty(this.deliveryOrderItemIdList, (String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        List<DeliveryOrderItem> deliveryOrderItemList = this.queryDeliveryOrderItems(this.deliveryOrderItemIdList);
        this.valid(deliveryOrderItemList);
        Map<String, List<DeliveryOrderItem>> group = deliveryOrderItemList.stream().collect(Collectors.groupingBy(DeliveryOrderItem::getDeliveryOrderId));
        group.keySet().forEach(deliveryOrderId -> {
            ((List)group.get(deliveryOrderId)).forEach(item -> item.setIsEnable(Constant.NO_INT));
            this.cancelDeliveryOrderItems((List)group.get(deliveryOrderId));
            DeliveryOrder deliveryOrder = (DeliveryOrder)ContextUtils.getDeliveryOrderService().queryObjById(deliveryOrderId);
            deliveryOrder.setItems((List)group.get(deliveryOrderId));
            WriteBackToErpCommand backToErpCommand = new WriteBackToErpCommand(deliveryOrder);
            this.context.invoke(backToErpCommand);
        });
        return null;
    }

    private void valid(List<DeliveryOrderItem> deliveryOrderItemList) {
        List inValidData = deliveryOrderItemList.stream().filter(item -> !DeliveryStatusEnum.ONWAY.getValue().equals(item.getDeliveryStatus())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(inValidData)) {
            Map<String, List<DeliveryOrderItem>> group = deliveryOrderItemList.stream().collect(Collectors.groupingBy(DeliveryOrderItem::getDeliveryOrderNo));
            String inValidDataStr = group.keySet().stream().map(deliveryOrderNo -> {
                String itemNoListStr = ((List)group.get(deliveryOrderNo)).stream().map(DeliveryOrderItem::getMaterialNo).distinct().collect(Collectors.joining(","));
                return String.format("%s[%s]", deliveryOrderNo, itemNoListStr);
            }).collect(Collectors.joining(","));
            throw new CommonException(String.format("\u9001\u8d27\u5355\u884c %s \u4e0d\u662f\u5728\u9014\uff0c\u4e0d\u80fd\u4f5c\u5e9f", inValidDataStr));
        }
        Map<String, List<DeliveryOrderItem>> group = deliveryOrderItemList.stream().collect(Collectors.groupingBy(DeliveryOrderItem::getDeliveryOrderId));
        String inVaildDeliveryOrderNoList = group.keySet().stream().map(deliveryOrderId -> (DeliveryOrder)ContextUtils.getDeliveryOrderService().queryObjById(deliveryOrderId)).filter(deliveryOrder -> !DeliveryStatusEnum.ALL_RECEIVED.getValue().equals(deliveryOrder.getDeliveryStatus())).map(DeliveryOrder::getDeliveryOrderNo).collect(Collectors.joining(","));
        if (StringUtils.isNotBlank((String)inVaildDeliveryOrderNoList)) {
            throw new CommonException(String.format("\u9001\u8d27\u5355 [%s] \u6ca1\u6709\u6536\u8d27\uff0c\u4e0d\u80fd\u5bf9\u884c\u4f5c\u5e9f\uff0c\u8bf7\u5230\u9001\u8d27\u5355\u5934\u4fe1\u606f\u754c\u9762\u4f5c\u5e9f\u3002", inVaildDeliveryOrderNoList));
        }
    }

    private List<DeliveryOrderItem> queryDeliveryOrderItems(List<String> deliveryOrderItemIdList) {
        deliveryOrderItemIdList = deliveryOrderItemIdList.stream().distinct().collect(Collectors.toList());
        DeliveryOrderItemExample deliveryOrderItemExample = new DeliveryOrderItemExample();
        deliveryOrderItemExample.createCriteria().andIdIn((List)deliveryOrderItemIdList);
        List deliveryOrderItemList = ContextUtils.getDeliveryOrderItemService().queryAllObjByExample((IExample)deliveryOrderItemExample);
        Assert.isNotEmpty((Collection)deliveryOrderItemList, (String)"\u6570\u636e\u5df2\u8fc7\u671f\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
        if (deliveryOrderItemIdList.size() != deliveryOrderItemIdList.size()) {
            throw new CommonException("\u6570\u636e\u5df2\u8fc7\u671f\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
        }
        return deliveryOrderItemList;
    }

    private void cancelDeliveryOrderItems(List<DeliveryOrderItem> unReceivedItemList) {
        for (int i = 0; CollectionUtils.isNotEmpty(unReceivedItemList) && i < unReceivedItemList.size(); ++i) {
            DeliveryOrderItem deliveryOrderItem = unReceivedItemList.get(i);
            this.context.invoke(new ModifyPlanOnWayQuantityCmd(deliveryOrderItem.getDeliveryPlanItemId(), DeliveryOperateEnum.DELIVERY_ORDER_CANCEL, deliveryOrderItem.getDeliveryQuantity()));
            this.context.invoke(new ModifyOrderItemOnWayQuantityCmd(deliveryOrderItem.getPurOrderItemId(), DeliveryOperateEnum.DELIVERY_ORDER_CANCEL, deliveryOrderItem.getDeliveryQuantity()));
        }
        List<String> planItemIdList = unReceivedItemList.stream().map(DeliveryOrderItem::getDeliveryPlanItemId).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
        this.context.invoke(new BatchModifyPlanIsCanDeliveryCmd(planItemIdList));
        List itemIdList = unReceivedItemList.stream().map(DeliveryOrderItem::getId).collect(Collectors.toList());
        DeliveryOrderItemExample deliveryOrderItemExample = new DeliveryOrderItemExample();
        deliveryOrderItemExample.createCriteria().andIdIn(itemIdList);
        DeliveryOrderItem tempItem = new DeliveryOrderItem();
        tempItem.setIsEnable(Constant.NO_INT);
        ContextUtils.getDeliveryOrderItemService().updateDeliveryOrderItem(tempItem, deliveryOrderItemExample);
    }
}

