/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.delivery.command;

import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.delivery.command.PreviewDeliveryOrderItemCommand;
import com.els.base.delivery.entity.DeliveryOrder;
import com.els.base.delivery.entity.DeliveryOrderItem;
import com.els.base.delivery.utils.DeliveryStatusEnum;
import com.els.base.purchase.entity.SupplierOrder;
import com.els.base.purchase.entity.SupplierOrderExample;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class PreviewDeliveryOrderCommand
extends AbstractCommand<DeliveryOrder> {
    private static final long serialVersionUID = 1L;
    private List<String> orderItemIdList;

    public PreviewDeliveryOrderCommand(List<String> orderItemIdList) {
        Assert.isNotEmpty(orderItemIdList, (String)"\u8ba2\u8d27\u5355\u884c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        this.orderItemIdList = orderItemIdList;
    }

    @Override
    public DeliveryOrder execute(ICommandInvoker context) {
        PreviewDeliveryOrderItemCommand previewItemCmd = new PreviewDeliveryOrderItemCommand(this.orderItemIdList);
        previewItemCmd.copyProperties(this);
        List<DeliveryOrderItem> items = context.invoke(previewItemCmd);
        DeliveryOrder deliveryOrder = this.completeDeliveryOrder(items);
        deliveryOrder.setItems(items);
        GenerateCodeService generateCodeService = ContextUtils.getGenerateCodeService();
        String deliveryOrderNo = generateCodeService.getNextCode("DELIVERY_NO_GENERATOR");
        deliveryOrder.setDeliveryOrderNo(deliveryOrderNo);
        for (DeliveryOrderItem deliveryOrderItem : items) {
            deliveryOrderItem.setDeliveryOrderNo(deliveryOrderNo);
        }
        return deliveryOrder;
    }

    private DeliveryOrder completeDeliveryOrder(List<DeliveryOrderItem> items) {
        DeliveryOrder deliveryOrder = new DeliveryOrder();
        List orderNos = items.stream().map(DeliveryOrderItem::getPurOrderNo).distinct().collect(Collectors.toList());
        deliveryOrder.setPurchaseOrderNo(StringUtils.abbreviate((String)StringUtils.join(orderNos, (String)","), (int)1000));
        deliveryOrder.setDeliveryStatus(DeliveryStatusEnum.UN_SENT.getValue());
        deliveryOrder.setVoucherType(this.getVoucherType(items));
        if (this.getSupUser() != null) {
            deliveryOrder.setUserId(this.getSupUser().getId());
            deliveryOrder.setUserName(this.getSupUser().getNickName());
        }
        if (this.getSupCompany() != null) {
            deliveryOrder.setCompanyId(items.get(0).getCompanyId());
            deliveryOrder.setCompanyName(items.get(0).getCompanyName());
            deliveryOrder.setCompanyCode(items.get(0).getCompanyCode());
        }
        if (this.getPurUser() == null) {
            items.stream().filter(item -> StringUtils.isNotBlank((String)item.getPurUserId())).findFirst().ifPresent(item -> {
                deliveryOrder.setPurUserId(item.getPurUserId());
                deliveryOrder.setPurUserName(item.getPurUserName());
            });
        } else {
            deliveryOrder.setPurUserId(this.getPurUser().getId());
            deliveryOrder.setPurUserName(this.getPurUser().getNickName());
        }
        if (this.getPurCompany() == null) {
            deliveryOrder.setPurCompanyId(items.get(0).getPurCompanyId());
            deliveryOrder.setPurCompanyCode(items.get(0).getPurCompanyCode());
            deliveryOrder.setPurCompanyName(items.get(0).getPurCompanyName());
        } else {
            deliveryOrder.setPurCompanyId(this.getPurCompany().getId());
            deliveryOrder.setPurCompanyCode(this.getPurCompany().getCompanyCode());
            deliveryOrder.setPurCompanyName(this.getPurCompany().getCompanyFullName());
        }
        return deliveryOrder;
    }

    private String getVoucherType(List<DeliveryOrderItem> items) {
        List purOrderIdList = items.stream().map(DeliveryOrderItem::getPurOrderId).collect(Collectors.toList());
        SupplierOrderExample example = new SupplierOrderExample();
        example.createCriteria().andIdIn(purOrderIdList).andOrderTypeIsNotNull();
        example.setPageView((PageView<SupplierOrder>)new PageView(1, 1));
        example.setOrderByClause("ORDER_TYPE DESC");
        PageView pageView = ContextUtils.getSupplierOrderService().queryObjByPage((IExample)example);
        if (CollectionUtils.isEmpty((Collection)pageView.getQueryResult())) {
            return null;
        }
        return ((SupplierOrder)pageView.getQueryResult().get(0)).getOrderType();
    }
}

