/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.command.jit;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.utils.Constant;
import com.els.base.plan.entity.JITSupRef;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.plan.entity.SupDeliveryPlanItemExample;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.PurchaseOrderItemExample;
import com.els.liby.quota.entity.SupplierQuota;
import com.els.liby.quota.entity.SupplierQuotaExample;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class CompositeDataCommand
extends AbstractCommand<List<JITSupRef>> {
    private String materialCode;
    private String factoryCode;
    private String planId;

    public CompositeDataCommand(String materialCode, String factoryCode, String planId) {
        this.materialCode = materialCode;
        this.factoryCode = factoryCode;
        this.planId = planId;
    }

    @Override
    public List<JITSupRef> execute(ICommandInvoker context) {
        List<JITSupRef> jitSupRefLists = this.getJitSupRef();
        for (JITSupRef jitSupRef : jitSupRefLists) {
            this.getQuota(jitSupRef);
        }
        List<String> companySapCodes = jitSupRefLists.stream().map(JITSupRef::getSupCompanySapCode).collect(Collectors.toList());
        List<JITSupRef> unHaveOrderJitSupRefLists = this.getUnHaveOrderJitSupRefLists(companySapCodes);
        jitSupRefLists.addAll(unHaveOrderJitSupRefLists);
        jitSupRefLists.sort(Comparator.comparing(JITSupRef::getCumulativeUndistributeMun).reversed());
        return jitSupRefLists;
    }

    private List<JITSupRef> getUnHaveOrderJitSupRefLists(List<String> companySapCodes) {
        SupplierQuotaExample example = new SupplierQuotaExample();
        SupplierQuotaExample.Criteria criteria = example.createCriteria();
        criteria.andMaterialCodeEqualTo(this.materialCode).andFactoryCodeEqualTo(this.factoryCode).andIsEnableEqualTo(Constant.YES_INT);
        if (CollectionUtils.isNotEmpty(companySapCodes)) {
            criteria.andCompanyCodeNotIn(companySapCodes);
        }
        List lists = ContextUtils.getSupplierQuotaService().queryAllObjByExample((IExample)example);
        List<JITSupRef> jitSupRefs = new ArrayList<JITSupRef>();
        if (CollectionUtils.isNotEmpty((Collection)lists)) {
            jitSupRefs = lists.stream().map(quota -> this.buildJitSupRefByQuota((SupplierQuota)quota)).collect(Collectors.toList());
        }
        return jitSupRefs;
    }

    private JITSupRef buildJitSupRefByQuota(SupplierQuota quota) {
        JITSupRef jitSupRef = new JITSupRef();
        jitSupRef.setSupCompanySapCode(quota.getCompanyCode());
        jitSupRef.setSupCompanyName(quota.getCompanyName());
        jitSupRef.setFactoryCode(quota.getFactoryCode());
        jitSupRef.setFactoryName(quota.getFactoryName());
        jitSupRef.setMaterialCode(quota.getMaterialCode());
        jitSupRef.setMaterialDescribe(quota.getMaterialDescribe());
        jitSupRef.setQuota(quota.getQuota());
        SupDeliveryPlanItem thisPlanItem = this.getthisDestaibuteMun(quota.getCompanyCode());
        jitSupRef.setThisDestaibuteMun(thisPlanItem.getDeliveryQuantity());
        jitSupRef.setPurRemarks(thisPlanItem.getPurRemark());
        SupDeliveryPlanItem planItem = this.geLlastSupDeliveryPlanItem(quota.getCompanyCode());
        jitSupRef.setLastDistributionTime(planItem.getCreateTime());
        jitSupRef.setLastDistributeMun(planItem.getDeliveryQuantity());
        jitSupRef.setCumulativeUndistributeMun(BigDecimal.ZERO);
        return jitSupRef;
    }

    private void getQuota(JITSupRef jitSupRef) {
        SupplierQuotaExample example = new SupplierQuotaExample();
        example.createCriteria().andMaterialCodeEqualTo(jitSupRef.getMaterialCode()).andFactoryCodeEqualTo(jitSupRef.getFactoryCode()).andCompanyCodeEqualTo(jitSupRef.getSupCompanySapCode()).andIsEnableEqualTo(Constant.YES_INT);
        List lists = ContextUtils.getSupplierQuotaService().queryAllObjByExample((IExample)example);
        if (lists.size() > 0) {
            jitSupRef.setQuota(((SupplierQuota)lists.get(0)).getQuota());
        }
    }

    private List<JITSupRef> getJitSupRef() {
        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        example.createCriteria().andMaterialCodeEqualTo(this.materialCode).andFactoryEqualTo(this.factoryCode).andIsEnableEqualTo(Constant.YES_INT).andFinishFlagNotEqualTo("Y").andReturnFlagIsNull();
        List orderItemList = ContextUtils.getPurchaseOrderItemService().queryAllObjByExample((IExample)example);
        Map<String, List<PurchaseOrderItem>> groupList = orderItemList.stream().collect(Collectors.groupingBy(PurchaseOrderItem::getSupCompanySapCode));
        List<JITSupRef> jitSupRefLists = groupList.keySet().stream().map(companySapCode -> this.initJitSupRef((List)groupList.get(companySapCode), (String)companySapCode)).collect(Collectors.toList());
        return jitSupRefLists;
    }

    private JITSupRef initJitSupRef(List<PurchaseOrderItem> list, String companySapCode) {
        PurchaseOrderItem item = list.get(0);
        JITSupRef jitSupRef = new JITSupRef();
        jitSupRef.setSupCompanySapCode(companySapCode);
        jitSupRef.setSupCompanyId(item.getSupCompanyId());
        jitSupRef.setSupCompanyCode(item.getSupCompanySrmCode());
        jitSupRef.setSupCompanyName(item.getSupCompanyName());
        jitSupRef.setPurCompanyId(item.getPurCompanyId());
        jitSupRef.setPurCompanyCode(item.getPurCompanySrmCode());
        jitSupRef.setPurCompanySapCode(item.getPurCompanySapCode());
        jitSupRef.setPurCompanyName(item.getPurCompanyName());
        jitSupRef.setFactoryCode(item.getFactory());
        jitSupRef.setFactoryName(item.getFactoryName());
        jitSupRef.setMaterialCode(item.getMaterialCode());
        jitSupRef.setMaterialDescribe(item.getMaterialName());
        SupDeliveryPlanItem thisPlanItem = this.getthisDestaibuteMun(companySapCode);
        jitSupRef.setThisDestaibuteMun(thisPlanItem.getDeliveryQuantity());
        jitSupRef.setPurRemarks(thisPlanItem.getPurRemark());
        SupDeliveryPlanItem planItem = this.geLlastSupDeliveryPlanItem(companySapCode);
        jitSupRef.setLastDistributionTime(planItem.getCreateTime());
        jitSupRef.setLastDistributeMun(planItem.getDeliveryQuantity());
        jitSupRef.setCumulativeUndistributeMun(BigDecimal.ZERO);
        jitSupRef.setCumulativeUndistributeMun(this.getCumulativeUndistributeMun(companySapCode, list, jitSupRef.getThisDestaibuteMun()));
        return jitSupRef;
    }

    private BigDecimal getCumulativeUndistributeMun(String companySapCode, List<PurchaseOrderItem> lists, BigDecimal thisDestaibuteMun) {
        thisDestaibuteMun = thisDestaibuteMun == null ? BigDecimal.ZERO : thisDestaibuteMun;
        BigDecimal distributableNum = lists.stream().map(PurchaseOrderItem::getCanDeliveryQuantity).filter(num -> num.compareTo(BigDecimal.ZERO) > 0).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal distributedNum = ContextUtils.getSupDeliveryPlanItemService().getdistributedNum(companySapCode, this.materialCode, this.factoryCode, null);
        return distributableNum.subtract(distributedNum).add(thisDestaibuteMun);
    }

    private SupDeliveryPlanItem geLlastSupDeliveryPlanItem(String companySapCode) {
        List lists;
        SupDeliveryPlanItemExample example = new SupDeliveryPlanItemExample();
        example.setOrderByClause("CREATE_TIME DESC");
        SupDeliveryPlanItemExample.Criteria criteria = example.createCriteria();
        criteria.andIsJitEqualTo(Constant.YES_INT).andIsEnableEqualTo(Constant.YES_INT).andMaterialNoEqualTo(this.materialCode).andFactoryCodeEqualTo(this.factoryCode).andSupCompanySapCodeEqualTo(companySapCode);
        if (this.planId != null) {
            criteria.andPlanIdNotEqualTo(this.planId);
        }
        if ((lists = ContextUtils.getSupDeliveryPlanItemService().queryAllObjByExample((IExample)example)).size() > 0) {
            return (SupDeliveryPlanItem)lists.get(0);
        }
        return new SupDeliveryPlanItem();
    }

    private SupDeliveryPlanItem getthisDestaibuteMun(String sapCode) {
        if (this.planId != null) {
            SupDeliveryPlanItemExample example = new SupDeliveryPlanItemExample();
            SupDeliveryPlanItemExample.Criteria criteria = example.createCriteria();
            criteria.andIsJitEqualTo(Constant.YES_INT).andMaterialNoEqualTo(this.materialCode).andFactoryCodeEqualTo(this.factoryCode).andSupCompanySapCodeEqualTo(sapCode).andPlanIdEqualTo(this.planId).andIsEnableEqualTo(Constant.YES_INT);
            List lists = ContextUtils.getSupDeliveryPlanItemService().queryAllObjByExample((IExample)example);
            if (lists.size() > 0) {
                return (SupDeliveryPlanItem)lists.get(0);
            }
        }
        return new SupDeliveryPlanItem();
    }
}

