/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.command.jit.plan;

import com.els.base.auth.utils.AuthConstant;
import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.company.entity.CompanySapRelation;
import com.els.base.company.entity.CompanySapRelationExample;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.material.entity.Material;
import com.els.base.material.entity.MaterialExample;
import com.els.base.plan.command.jit.plan.ImportJitPlanCommand;
import com.els.base.plan.entity.JitPlanDataSources;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.plan.utils.JitPlanUtils;
import com.els.liby.organization.entity.Organization;
import com.els.liby.organization.entity.OrganizationExample;
import com.els.liby.organization.utils.UserOrganizationUtils;
import com.google.common.collect.ArrayListMultimap;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class CreateJitPlanByExcelCommand
extends AbstractCommand {
    private List<SupDeliveryPlanItem> itemList;
    private List<String> roleCodes;

    public CreateJitPlanByExcelCommand(List<SupDeliveryPlanItem> itemList, List<String> roleCodes) {
        this.itemList = itemList;
        this.roleCodes = roleCodes;
    }

    public Object execute(ICommandInvoker context) {
        this.vaidSource(this.itemList);
        this.init(this.itemList);
        this.vaidFactory(this.itemList);
        this.vaidIsJit(this.itemList);
        ImportJitPlanCommand command = new ImportJitPlanCommand(this.itemList, false);
        command.copyProperties(this);
        context.invoke(command);
        return null;
    }

    private void vaidSource(List<SupDeliveryPlanItem> itemList) {
        StringBuffer buffer = new StringBuffer("\u5bfc\u5165\u5931\u8d25\uff1b\u5de5\u5382/\u7269\u6599\uff1a");
        List<JitPlanDataSources> openList = ContextUtils.getJitPlanDataSourcesService().getOpenList();
        List aspList = itemList.stream().filter(demand -> openList.stream().anyMatch(open -> open.getFactory().equals(demand.getFactoryCode()) && open.getMaterialCode().equals(demand.getMaterialNo()))).collect(Collectors.toList());
        List itemSet = aspList.stream().map(list -> list.getFactoryCode() + "/" + list.getMaterialNo()).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(itemSet)) {
            itemSet.stream().forEach(list -> buffer.append(list + "\u3001"));
            buffer.append("\u5df2\u5f00\u542fASPROVE\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165");
            throw new CommonException(buffer.toString());
        }
    }

    private void vaidFactory(List<SupDeliveryPlanItem> itemList) {
        List factorys = itemList.stream().map(SupDeliveryPlanItem::getFactoryCode).distinct().collect(Collectors.toList());
        List factoryCodeList = UserOrganizationUtils.getUserFactoryCode((String)this.getPurUser().getId());
        if (CollectionUtils.isEmpty(this.roleCodes) || !this.roleCodes.contains(AuthConstant.SYS_MANAGER_ROLE.getRoleCode())) {
            Assert.isNotEmpty((Collection)factoryCodeList, (String)"\u5bfc\u5165\u5931\u8d25\uff1a\u8d26\u53f7\u672a\u5206\u914d\u5de5\u5382\u6743\u9650");
            factorys.stream().forEach(factory -> {
                if (!factoryCodeList.contains(factory)) {
                    throw new CommonException(MessageFormat.format("\u5bfc\u5165\u5931\u8d25\uff1a\u8d26\u53f7\u672a\u5206\u914d{0}\u5de5\u5382\u6743\u9650", factory));
                }
            });
        }
    }

    private void vaidIsJit(List<SupDeliveryPlanItem> itemList) {
        ArrayListMultimap arrayListMultiMap = ArrayListMultimap.create();
        for (SupDeliveryPlanItem planItem : itemList) {
            String planKey = planItem.getFactoryCode() + planItem.getMaterialNo();
            arrayListMultiMap.put((Object)planKey, (Object)planItem);
        }
        Set keySet = arrayListMultiMap.keySet();
        keySet.stream().forEach(quotaKey -> {
            List planItems = arrayListMultiMap.get(quotaKey);
            String jitItem = JitPlanUtils.getMaterialJitItem(((SupDeliveryPlanItem)planItems.get(0)).getMaterialNo(), ((SupDeliveryPlanItem)planItems.get(0)).getFactoryCode());
            planItems.stream().forEach(item -> item.setJitItem(jitItem));
        });
    }

    private void init(List<SupDeliveryPlanItem> itemList) {
        this.initFactory(itemList);
        this.initMaterial(itemList);
        this.initSupCompany(itemList);
    }

    private void initSupCompany(List<SupDeliveryPlanItem> itemList) {
        ArrayListMultimap arrayListMultiMap = ArrayListMultimap.create();
        for (SupDeliveryPlanItem planItem : itemList) {
            String supCompanyName2 = planItem.getSupCompanyName();
            arrayListMultiMap.put((Object)supCompanyName2, (Object)planItem);
        }
        Set keySet = arrayListMultiMap.keySet();
        keySet.stream().forEach(supCompanyName -> {
            CompanySapRelationExample example = new CompanySapRelationExample();
            example.createCriteria().andCompanyNameEqualTo(supCompanyName);
            List lists = ContextUtils.getCompanySapRelationService().queryAllObjByExample((IExample)example);
            if (lists.size() != 1) {
                throw new CommonException("\u4f9b\u5e94\u5546\u7b80\u79f0<" + supCompanyName + ">\u9519\u8bef");
            }
            CompanySapRelation companySapRelation = (CompanySapRelation)lists.get(0);
            arrayListMultiMap.get(supCompanyName).stream().forEach(planItem -> {
                planItem.setSupCompanyId(companySapRelation.getCompanyId());
                planItem.setSupCompanyName((String)supCompanyName);
                planItem.setSupCompanySapCode(companySapRelation.getCompanySapCode());
                planItem.setSupCompanySrmCode(companySapRelation.getCompanyCode());
            });
        });
    }

    private void initMaterial(List<SupDeliveryPlanItem> itemList) {
        ArrayListMultimap arrayListMultiMap = ArrayListMultimap.create();
        for (SupDeliveryPlanItem planItem : itemList) {
            String materialCode2 = planItem.getMaterialNo();
            arrayListMultiMap.put((Object)materialCode2, (Object)planItem);
        }
        Set keySet = arrayListMultiMap.keySet();
        keySet.stream().forEach(materialCode -> {
            MaterialExample example = new MaterialExample();
            example.createCriteria().andMaterialCodeEqualTo(materialCode);
            List lists = ContextUtils.getMaterialService().queryAllObjByExample((IExample)example);
            Assert.isNotEmpty((Collection)lists, (String)("\u7269\u6599\u7f16\u7801<" + materialCode + ">\u4e0d\u5b58\u5728"));
            Material material = (Material)lists.get(0);
            arrayListMultiMap.get(materialCode).stream().forEach(planItem -> {
                planItem.setMaterialId(material.getId());
                planItem.setMaterialDesc(material.getDescription());
                planItem.setMaterialGroup(material.getMaterialGroup());
                planItem.setExternalMaterialGroup(material.getExternalMaterialGroup());
                planItem.setOrderUnit(material.getBasicUnit());
            });
        });
    }

    private void initFactory(List<SupDeliveryPlanItem> itemList) {
        ArrayListMultimap arrayListMultiMap = ArrayListMultimap.create();
        for (SupDeliveryPlanItem planItem : itemList) {
            String factoryCode2 = planItem.getFactoryCode();
            arrayListMultiMap.put((Object)factoryCode2, (Object)planItem);
        }
        Set keySet = arrayListMultiMap.keySet();
        keySet.stream().forEach(factoryCode -> {
            OrganizationExample example = new OrganizationExample();
            example.createCriteria().andCodeEqualTo(factoryCode).andOrganizationTypeEqualTo("T001W");
            List lists = ContextUtils.getOrganizationService().queryAllObjByExample((IExample)example);
            Assert.isNotEmpty((Collection)lists, (String)("\u5de5\u5382\u4ee3\u7801<" + factoryCode + ">\u4e0d\u5b58\u5728"));
            arrayListMultiMap.get(factoryCode).stream().forEach(planItem -> planItem.setFactoryName(((Organization)lists.get(0)).getDescription()));
        });
    }
}

