/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.command.jit.plan;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.plan.entity.DeliveryPlan;
import com.els.base.plan.entity.DeliveryPlanExample;
import com.els.base.plan.entity.PurDeliveryPlanItem;
import com.els.base.plan.entity.PurDeliveryPlanItemExample;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.plan.entity.SupDeliveryPlanItemExample;
import java.util.Date;
import java.util.List;

public class JITIsLockCommand
extends AbstractCommand {
    private List<String> ids;
    private boolean isLock;

    public JITIsLockCommand(List<String> ids, boolean isLock) {
        this.ids = ids;
        this.isLock = isLock;
    }

    public Object execute(ICommandInvoker context) {
        if (this.isLock) {
            this.setLockPlan("F");
        } else {
            this.setLockPlan("N");
        }
        return null;
    }

    private void setLockPlan(String lock) {
        DeliveryPlan plan = new DeliveryPlan();
        plan.setIsLock(lock);
        plan.setLastUpdateTime(new Date());
        plan.setLastUpdateUser(this.getSupUser().getLoginName());
        DeliveryPlanExample deliveryPlanExample = new DeliveryPlanExample();
        deliveryPlanExample.createCriteria().andIdIn((List)this.ids);
        ContextUtils.getDeliveryPlanService().modifyByExample(plan, deliveryPlanExample);
        SupDeliveryPlanItem supItem = new SupDeliveryPlanItem();
        supItem.setIsLock(lock);
        SupDeliveryPlanItemExample supplanItemExample = new SupDeliveryPlanItemExample();
        supplanItemExample.createCriteria().andPlanIdIn((List)this.ids);
        ContextUtils.getSupDeliveryPlanItemService().modifyByExample(supItem, supplanItemExample);
        PurDeliveryPlanItem purItem = new PurDeliveryPlanItem();
        purItem.setIsLock(lock);
        PurDeliveryPlanItemExample purPlanItemExample = new PurDeliveryPlanItemExample();
        purPlanItemExample.createCriteria().andPlanIdIn((List)this.ids);
        ContextUtils.getPurDeliveryPlanItemService().modifyByExample(purItem, purPlanItemExample);
    }
}

