/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command.order;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.utils.Constant;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderExample;
import com.els.base.purchase.entity.PurchaseOrderImTemplete;
import com.els.base.purchase.utils.BusinessTypeEnum;
import com.els.base.purchase.utils.PurchaseOrderConfirmStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderSendStatusEnum;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.time.DateUtils;

public class RemindOfPurchaseOrderCmd
extends AbstractCommand<String> {
    private static final long serialVersionUID = 1L;

    @Override
    public String execute(ICommandInvoker context) {
        PurchaseOrderExample example = new PurchaseOrderExample();
        example.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andOrderStatusEqualTo(PurchaseOrderConfirmStatusEnum.UNCONFIRM.getValue()).andOrderSendStatusIn((List)Arrays.asList(PurchaseOrderSendStatusEnum.SENDED.getValue(), PurchaseOrderSendStatusEnum.UPDATE_SENDED.getValue())).andSendTimeLessThanOrEqualTo(DateUtils.addDays((Date)new Date(), (int)-1));
        List list = ContextUtils.getPurchaseOrderService().queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        Map<String, List<PurchaseOrder>> grouplist = list.stream().collect(Collectors.groupingBy(PurchaseOrder::getSupCompanySrmCode));
        grouplist.keySet().forEach(supCompanySrmCode -> {
            List supOrderList = (List)grouplist.get(supCompanySrmCode);
            Map<String, List<PurchaseOrder>> planerGroup = supOrderList.stream().collect(Collectors.groupingBy(PurchaseOrder::getPurPlanerId));
            planerGroup.keySet().forEach(planerId -> {
                this.sendExpiredConfirmMessagesToSup((List)planerGroup.get(planerId));
                this.sendExpiredConfirmMessagesToPur((List)planerGroup.get(planerId));
            });
        });
        return null;
    }

    private void sendExpiredConfirmMessagesToPur(List<PurchaseOrder> orderList) {
        if (CollectionUtils.isEmpty(orderList)) {
            return;
        }
        String billData = orderList.stream().map(PurchaseOrder::getOrderNo).collect(Collectors.joining(","));
        long timeMaxDayDiff = this.getTimeMaxDiff(orderList);
        String shrotName = orderList.get(0).getSupCompanyShortName();
        PurchaseOrderImTemplete tem = new PurchaseOrderImTemplete();
        tem.setDays(timeMaxDayDiff);
        tem.setCompanyName(shrotName);
        tem.setBillList(billData);
        tem.setOrderTotal(orderList.size());
        tem.setOverdueTime(new Date());
        tem.setOrderList(orderList);
        tem.setPlanerName(orderList.get(0).getPurPlanerName());
        if (timeMaxDayDiff == 0L) {
            tem.setOtherInfo(String.format("\u91c7\u8d2d\u8ba2\u5355%s\uff0c\u5df2\u903e\u671f\u672a\u56de\u7b7e\uff0c\u8bf7\u5c3d\u5feb\u4e0e\u4f9b\u5e94\u5546%s\u8054\u7cfb\uff0c\u786e\u8ba4\u8ba2\u5355\u3002", billData, shrotName));
        } else {
            tem.setOtherInfo(String.format("\u91c7\u8d2d\u8ba2\u5355%s\uff0c\u5df2\u903e\u671f%d\u5929\u672a\u56de\u7b7e\uff0c\u8bf7\u5c3d\u5feb\u4e0e\u4f9b\u5e94\u5546%s\u8054\u7cfb\uff0c\u786e\u8ba4\u8ba2\u5355\u3002", billData, timeMaxDayDiff, shrotName));
        }
        Message message = Message.init((Object)tem).setBusinessTypeCode(BusinessTypeEnum.PO_CONFIRM_IM_CODE.getCode()).setCompanyCode(orderList.get(0).getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId("1").addReceiverId(orderList.get(0).getPurPlanerId());
        MessageSendUtils.sendMessage((Message)message);
    }

    private void sendExpiredConfirmMessagesToSup(List<PurchaseOrder> orderList) {
        if (CollectionUtils.isEmpty(orderList)) {
            return;
        }
        String billData = orderList.stream().map(PurchaseOrder::getOrderNo).collect(Collectors.joining(","));
        long timeMaxDayDiff = this.getTimeMaxDiff(orderList);
        String shrotName = orderList.get(0).getSupCompanyShortName();
        PurchaseOrderImTemplete tem = new PurchaseOrderImTemplete();
        tem.setDays(timeMaxDayDiff);
        tem.setCompanyName(shrotName);
        tem.setBillList(billData);
        tem.setOrderTotal(orderList.size());
        tem.setOverdueTime(new Date());
        tem.setOrderList(orderList);
        tem.setPlanerName(orderList.get(0).getPurPlanerName());
        if (timeMaxDayDiff == 0L) {
            tem.setOtherInfo(String.format("\u91c7\u8d2d\u8ba2\u5355%s\uff0c\u5df2\u903e\u671f\u672a\u56de\u7b7e\uff0c\u8bf7\u5c3d\u5feb\u4e0e\u8ba2\u5355\u8d1f\u8d23\u4eba%s\u8054\u7cfb\uff0c\u786e\u8ba4\u8ba2\u5355\u3002", billData, orderList.get(0).getPurPlanerName()));
        } else {
            tem.setOtherInfo(String.format("\u91c7\u8d2d\u8ba2\u5355%s\uff0c\u5df2\u903e\u671f%d\u5929\u672a\u56de\u7b7e\uff0c\u8bf7\u5c3d\u5feb\u4e0e\u8ba2\u5355\u8d1f\u8d23\u4eba%s\u8054\u7cfb\uff0c\u786e\u8ba4\u8ba2\u5355\u3002", billData, timeMaxDayDiff, orderList.get(0).getPurPlanerName()));
        }
        Message message = Message.init((Object)tem).setBusinessTypeCode(BusinessTypeEnum.PO_CONFIRM_IM_CODE.getCode()).setCompanyCode(orderList.get(0).getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(orderList.get(0).getPurPlanerId()).addReceiverId(orderList.get(0).getSupUserId());
        MessageSendUtils.sendMessage((Message)message);
    }

    private long getTimeMaxDiff(List<PurchaseOrder> list) {
        Date minDate = list.stream().map(PurchaseOrder::getSendTime).min(Date::compareTo).orElse(null);
        if (minDate == null) {
            return 0L;
        }
        long diff = new Date().getTime() - minDate.getTime();
        return diff / 86400000L;
    }
}

