/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.delivery.utils;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.delivery.entity.DeliveryOrderItem;
import com.els.base.delivery.entity.DeliveryOrderPrint;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import com.els.base.logistic.entity.LogisticOrder;
import com.els.base.purchase.entity.LabelPrintRecordExtend;
import com.els.base.purchase.vo.KnMaterialQrcodeVO;
import com.els.base.utils.pdf.HtmlToPdfUtils;
import com.els.base.utils.template.BeetlTemplateUtils;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.itextpdf.text.pdf.BarcodePDF417;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.dom4j.DocumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Base64Utils;

public abstract class DeliveryOrderPrintUtils {
    private static Logger logger = LoggerFactory.getLogger(DeliveryOrderPrintUtils.class);
    private static int WIDTH = 150;
    private static int HEIGHT = 64;
    private static String LENGTH80_WIDTH80 = "80*80";
    private static String LENGTH70_WIDTH45 = "70*45";

    public static FileData generateLogisticOrderPdf(LogisticOrder logisticOrder) throws Exception {
        String barCodeContent = MessageFormat.format("{0}#{1}#{2}#{3}", logisticOrder.getLogisticOrderNo(), logisticOrder.getDriverName(), logisticOrder.getIdCard(), logisticOrder.getCar());
        String qrCodeBase64 = DeliveryOrderPrintUtils.getBase64QRCode(barCodeContent);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("logisticOrder", logisticOrder);
        params.put("qrCodeBase64", qrCodeBase64);
        String html = BeetlTemplateUtils.renderFromFile((String)"logisticOrderA4.html", params);
        String filename = MessageFormat.format("\u7269\u6d41\u5355_A4{0}", DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd-HH-mm"));
        FileData pdfFile = DeliveryOrderPrintUtils.createEmptyPDF(logisticOrder.getProjectId(), logisticOrder.getPurCompanyId(), filename);
        HtmlToPdfUtils.generatePdf((String)html, (File)pdfFile.toFile(), (String)"A4", (boolean)true, (String)filename);
        return pdfFile;
    }

    public static FileData generateDeliveryOrderPdf(DeliveryOrderPrint deliveryOrderPrint, String printType) throws WriterException, IOException, DocumentException, InterruptedException {
        Iterator<DeliveryOrderItem> iterator;
        String barcodeBase64 = DeliveryOrderPrintUtils.createPdf417QRCode("[S]ASN_NO[M]" + deliveryOrderPrint.getDeliveryOrderNo() + "[E]");
        deliveryOrderPrint.setScanPicPath(barcodeBase64);
        List<DeliveryOrderItem> items = deliveryOrderPrint.getItems();
        if (items != null && (iterator = items.iterator()).hasNext()) {
            DeliveryOrderItem item = iterator.next();
            deliveryOrderPrint.setAttachment(item.getFactoryCode());
        }
        HashMap<String, DeliveryOrderPrint> params = new HashMap<String, DeliveryOrderPrint>();
        params.put("deliveryOrder", deliveryOrderPrint);
        String filename = null;
        FileData pdfFile = null;
        String html = null;
        switch (printType) {
            case "LetterA5": {
                html = BeetlTemplateUtils.renderFromFile((String)"deliveryOrderLetterA5.html", params);
                filename = "\u9001\u8d27\u5355_Letter_A5" + DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd-HH-mm");
                pdfFile = DeliveryOrderPrintUtils.createEmptyPDF(deliveryOrderPrint.getProjectId(), deliveryOrderPrint.getPurCompanyId(), filename);
                HtmlToPdfUtils.generatePdf((String)html, (File)pdfFile.toFile(), (float)216.0f, (float)139.5f, (String)filename);
                break;
            }
            case "Letter": {
                html = BeetlTemplateUtils.renderFromFile((String)"deliveryOrderLetter.html", params);
                filename = "\u9001\u8d27\u5355_Letter_" + DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd-HH-mm");
                pdfFile = DeliveryOrderPrintUtils.createEmptyPDF(deliveryOrderPrint.getProjectId(), deliveryOrderPrint.getPurCompanyId(), filename);
                HtmlToPdfUtils.generatePdf((String)html, (File)pdfFile.toFile(), (String)"Letter", (boolean)true, (String)filename);
                break;
            }
            case "A4": {
                html = BeetlTemplateUtils.renderFromFile((String)"deliveryOrderA4.html", params);
                filename = "\u9001\u8d27\u5355_A4_" + DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd-HH-mm");
                pdfFile = DeliveryOrderPrintUtils.createEmptyPDF(deliveryOrderPrint.getProjectId(), deliveryOrderPrint.getPurCompanyId(), filename);
                HtmlToPdfUtils.generatePdf((String)html, (File)pdfFile.toFile(), (String)"A4", (boolean)true, (String)filename);
                break;
            }
            case "A5": {
                html = BeetlTemplateUtils.renderFromFile((String)"deliveryOrderA5.html", params);
                filename = "\u9001\u8d27\u5355_A5_" + DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd-HH-mm");
                pdfFile = DeliveryOrderPrintUtils.createEmptyPDF(deliveryOrderPrint.getProjectId(), deliveryOrderPrint.getPurCompanyId(), filename);
                HtmlToPdfUtils.generatePdf((String)html, (File)pdfFile.toFile(), (String)"A5", (boolean)false, (String)filename);
                break;
            }
            case "INVOICE": {
                html = BeetlTemplateUtils.renderFromFile((String)"InvoiceA4.html", params);
                filename = "INVOICE_" + DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd-HH-mm");
                pdfFile = DeliveryOrderPrintUtils.createEmptyPDF(deliveryOrderPrint.getProjectId(), deliveryOrderPrint.getPurCompanyId(), filename);
                HtmlToPdfUtils.generatePdf((String)html, (File)pdfFile.toFile(), (String)"A4", (boolean)false, (String)filename);
                break;
            }
            case "PACKINGLIST": {
                html = BeetlTemplateUtils.renderFromFile((String)"packinglistA4.html", params);
                filename = "PACKINGLIST_" + DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd-HH-mm");
                pdfFile = DeliveryOrderPrintUtils.createEmptyPDF(deliveryOrderPrint.getProjectId(), deliveryOrderPrint.getPurCompanyId(), filename);
                HtmlToPdfUtils.generatePdf((String)html, (File)pdfFile.toFile(), (String)"A4", (boolean)false, (String)filename);
                break;
            }
            default: {
                throw new CommonException("\u4e0d\u652f\u6301\u5f53\u524d\u6253\u5370\u7c7b\u578b[" + deliveryOrderPrint.getPrintSizeType() + "]");
            }
        }
        return pdfFile;
    }

    public static FileData generateKnMaterialQrcodePdf(List<KnMaterialQrcodeVO> voList) throws WriterException, IOException, DocumentException, InterruptedException {
        HashMap<String, List<KnMaterialQrcodeVO>> params = new HashMap<String, List<KnMaterialQrcodeVO>>();
        params.put("printList", voList);
        String filename = "\u7269\u6599\u4e8c\u7ef4\u7801_MI_" + DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd-HH-mm");
        String html = BeetlTemplateUtils.renderFromFile((String)"knMaterialQrcode72x38.html", params);
        FileData pdfFile = DeliveryOrderPrintUtils.createEmptyPDF(voList.get(0).getProjectId(), voList.get(0).getPurCompanyId(), filename);
        HtmlToPdfUtils.generatePdf((String)html, (File)pdfFile.toFile(), (float)72.0f, (float)38.0f, (String)filename);
        return pdfFile;
    }

    public static FileData generateDeliveryOrderOuterBoxPdf(List<LabelPrintRecordExtend> printList) throws WriterException, IOException, DocumentException, InterruptedException {
        logger.info("\u5f00\u59cb\u6253\u5370\u5916\u7bb1");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("printList", printList);
        params.put("fontPath", DeliveryOrderPrint.DEFAULT_FONT_PATH);
        FileData pdfFile = null;
        if (printList.get(0).getPrintSize().equals(LENGTH80_WIDTH80)) {
            String html = BeetlTemplateUtils.renderFromFile((String)"deliveryOrderOuterBox80x80.html", params);
            String filename = "\u5916\u7bb1\u4e8c\u7ef4\u7801_80x80_" + DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd-HH-mm");
            pdfFile = DeliveryOrderPrintUtils.createEmptyPDF(printList.get(0).getProjectId(), printList.get(0).getPurCompanyId(), filename);
            File file = pdfFile.toFile();
            HtmlToPdfUtils.generatePdf((String)html, (File)file, (float)80.0f, (float)80.0f, (String)filename);
        } else if (printList.get(0).getPrintSize().equals(LENGTH70_WIDTH45)) {
            String html = BeetlTemplateUtils.renderFromFile((String)"deliveryOrderOuterBox70x45.html", params);
            String filename = "\u5916\u7bb1\u4e8c\u7ef4\u7801_70x45_" + DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd-HH-mm");
            pdfFile = DeliveryOrderPrintUtils.createEmptyPDF(printList.get(0).getProjectId(), printList.get(0).getPurCompanyId(), filename);
            File file = pdfFile.toFile();
            HtmlToPdfUtils.generatePdf((String)html, (File)file, (float)70.0f, (float)45.0f, (String)filename);
        } else {
            throw new CommonException("\u4e0d\u652f\u6301\u5f53\u524d\u6253\u5370\u5c3a\u5bf8[" + printList.get(0).getPrintSize() + "]");
        }
        return pdfFile;
    }

    public static FileData generateDeliveryOrderInnerBoxPdf(List<LabelPrintRecordExtend> printList) throws WriterException, IOException, InterruptedException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("printList", printList);
        params.put("fontPath", DeliveryOrderPrint.DEFAULT_FONT_PATH);
        FileData pdfFile = null;
        if (printList.get(0).getPrintSize().equals(LENGTH80_WIDTH80)) {
            String html = BeetlTemplateUtils.renderFromFile((String)"deliveryOrderInerBox80x80.html", params);
            String filename = "\u5185\u7bb1\u4e8c\u7ef4\u7801_80x80_" + DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd-HH-mm");
            pdfFile = DeliveryOrderPrintUtils.createEmptyPDF(printList.get(0).getProjectId(), printList.get(0).getPurCompanyId(), filename);
            File file = pdfFile.toFile();
            HtmlToPdfUtils.generatePdf((String)html, (File)file, (float)80.0f, (float)80.0f, (String)filename);
        } else if (printList.get(0).getPrintSize().equals(LENGTH70_WIDTH45)) {
            String html = BeetlTemplateUtils.renderFromFile((String)"deliveryOrderInerBox70x45.html", params);
            String filename = "\u5185\u7bb1\u4e8c\u7ef4\u7801_70x45_" + DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd-HH-mm");
            pdfFile = DeliveryOrderPrintUtils.createEmptyPDF(printList.get(0).getProjectId(), printList.get(0).getPurCompanyId(), filename);
            File file = pdfFile.toFile();
            HtmlToPdfUtils.generatePdf((String)html, (File)file, (float)70.0f, (float)45.0f, (String)filename);
        } else {
            throw new CommonException("\u4e0d\u652f\u6301\u5f53\u524d\u6253\u5370\u5c3a\u5bf8[" + printList.get(0).getPrintSize() + "]");
        }
        return pdfFile;
    }

    public static FileData createEmptyPDF(String projectId, String companyId, String filename) throws UnsupportedEncodingException, IOException {
        FileData pdfFile = new FileData();
        pdfFile.setProjectId(projectId);
        pdfFile.setCompanyId(companyId);
        pdfFile.setFileName(filename + ".pdf");
        pdfFile.setFileSuffix("pdf");
        pdfFile.setIsEncrypt(String.valueOf(Constant.NO_INT));
        pdfFile.setExpiryDay(DateUtils.addMinutes((Date)new Date(), (int)30));
        FileManagerFactory.getFileManager().createEmptyFile(pdfFile);
        return pdfFile;
    }

    public static String generateBarcodeBase64(String deliveryOrderNo) throws WriterException, IOException {
        BitMatrix bitMatrix = new MultiFormatWriter().encode(deliveryOrderNo, BarcodeFormat.CODE_128, WIDTH, HEIGHT, null);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"png", (OutputStream)outputStream);
        outputStream.flush();
        outputStream.close();
        outputStream.toByteArray();
        byte[] base64Encode = Base64Utils.encode((byte[])outputStream.toByteArray());
        return new String(base64Encode);
    }

    public static String getBase64QRCode(String content) throws WriterException, IOException {
        MultiFormatWriter multiFormatWriter = new MultiFormatWriter();
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
        hints.put(EncodeHintType.MARGIN, 1);
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.L);
        hints.put(EncodeHintType.CHARACTER_SET, "GBK");
        BitMatrix bitMatrix = multiFormatWriter.encode(content, BarcodeFormat.QR_CODE, 400, 400, hints);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"png", (OutputStream)outputStream);
        outputStream.flush();
        outputStream.close();
        outputStream.toByteArray();
        byte[] base64Encode = Base64Utils.encode((byte[])outputStream.toByteArray());
        return new String(base64Encode);
    }

    public static String createPdf417QRCode(String content) throws IOException {
        BarcodePDF417 pdf = new BarcodePDF417();
        pdf.setText(content.getBytes("GBK"));
        Image pdfImage = pdf.createAwtImage(Color.BLACK, Color.white);
        BufferedImage img = new BufferedImage(pdfImage.getWidth(null), pdfImage.getHeight(null), 1);
        Graphics g = img.getGraphics();
        g.drawImage(pdfImage, 0, 0, Color.white, null);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)img, "png", outputStream);
        outputStream.flush();
        outputStream.close();
        byte[] base64Encode = Base64Utils.encode((byte[])outputStream.toByteArray());
        return new String(base64Encode);
    }
}

