/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.orderchange.command;

import com.els.base.command.AbstractPurchaseCommand;
import com.els.base.command.PurchaseInvorker;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.orderchange.entity.PurchaseOrderChange;
import com.els.base.orderchange.entity.PurchaseOrderChangeExample;
import com.els.base.orderchange.util.BillStatusConfirmEnum;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupConfirmCommand
extends AbstractPurchaseCommand<String> {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    List<PurchaseOrderChange> purchaseOrderChangeList;

    public SupConfirmCommand(List<PurchaseOrderChange> purchaseOrderChangeList) {
        this.purchaseOrderChangeList = purchaseOrderChangeList;
    }

    @Override
    public String execute(PurchaseInvorker billInvorker) {
        this.validate(this.purchaseOrderChangeList);
        this.process(this.purchaseOrderChangeList);
        return null;
    }

    private void process(List<PurchaseOrderChange> list) {
        boolean debugEnabled = this.logger.isDebugEnabled();
        if (debugEnabled) {
            this.logger.info("1\u3001\u91c7\u8d2d\u8ba2\u5355\u9700\u8981\u53d8\u66f4\u4e3a\u5df2\u7ecf\u786e\u8ba4");
        }
        this.updatePurOrder(list);
        if (debugEnabled) {
            this.logger.info("2\u3001\u53d8\u66f4\u4f9b\u5e94\u5546\u7aef\u8ba2\u5355\u4e3a\u5df2\u786e\u8ba4");
        }
        this.updateSupOrder(list);
        if (debugEnabled) {
            this.logger.info("3\u3001\u8ba2\u5355\u53d8\u66f4\u8ba2\u5355\u91cc\u9762\u7684\u72b6\u6001\u4e5f\u53d8\u4e3a\u5df2\u786e\u8ba4");
        }
        this.updateOrderChange(list);
    }

    private void updateOrderChange(List<PurchaseOrderChange> list) {
        PurchaseOrderChange purchaseOrderChange = new PurchaseOrderChange();
        purchaseOrderChange.setConfirmStatus(BillStatusConfirmEnum.STATUS_CONFIRM.getCode());
        List ids = list.stream().map(PurchaseOrderChange::getId).collect(Collectors.toList());
        PurchaseOrderChangeExample example = new PurchaseOrderChangeExample();
        example.createCriteria().andIdIn(ids);
        this.getPurchaseInvorker().getPurchaseOrderChangeService().updateByExampleSelective(purchaseOrderChange, example);
    }

    private void updateSupOrder(List<PurchaseOrderChange> list) {
    }

    private void updatePurOrder(List<PurchaseOrderChange> list) {
    }

    private void validate(List<PurchaseOrderChange> list) {
        Assert.isNotEmpty(list, (String)"\u8bf7\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u6570\u636e");
        for (int i = 0; i < list.size(); ++i) {
            Assert.isNotNull((Object)list.get(i), (String)"\u53d8\u66f4\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            String id = list.get(i).getId();
            Assert.isNotBlank((String)id, (String)"\u53d8\u66f4ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            PurchaseOrderChangeExample example = new PurchaseOrderChangeExample();
            PurchaseOrderChangeExample.Criteria criteria = example.createCriteria();
            criteria.andIdEqualTo(id);
            criteria.andStatusEqualTo("NEW");
            List changeOrders = this.getPurchaseInvorker().getPurchaseOrderChangeService().queryAllObjByExample((IExample)example);
            Assert.isNotEmpty((Collection)changeOrders, (String)"\u672a\u627e\u5230\u6b64\u8ba2\u5355");
            PurchaseOrderChange changeOrder = (PurchaseOrderChange)changeOrders.get(0);
            if (changeOrder == null || !changeOrder.getConfirmStatus().equals("2")) continue;
            throw new CommonException("\u8be5\u53d8\u66f4\u7533\u8bf7\u5df2\u518d\u6b21\u53d1\u9001\uff0c\u6b64\u6b21\u64cd\u4f5c\u7684\u6570\u636e\u4e3a\u65e7\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u786e\u8ba4\u7684\u6570\u636e\u3002", "old_data", new Object[]{"\u8be5\u53d8\u66f4\u7533\u8bf7\u5df2\u518d\u6b21\u53d1\u9001\uff0c"});
        }
    }
}

