/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.utils;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import com.els.base.purchase.vo.KnPurOrderPdfVO;
import com.els.base.utils.pdf.HtmlToPdfUtils;
import com.els.base.utils.template.BeetlTemplateUtils;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PurchaseOrderPdfPrintUtil {
    private static Logger logger = LoggerFactory.getLogger(PurchaseOrderPdfPrintUtil.class);

    public static FileData getPdfFile(KnPurOrderPdfVO headerVo) {
        try {
            logger.info("=====================> \u91c7\u8d2d\u8ba2\u5355\u751f\u6210PDF\u5f00\u59cb");
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("purchaseOrder", headerVo);
            params.put("fontPath", PurchaseOrderPdfPrintUtil.class.getClassLoader().getResource("").toString() + "fonts/nsimsum.ttf");
            String filename = null;
            FileData pdfFile = null;
            String html = null;
            html = BeetlTemplateUtils.renderFromFile((String)"purchaseOrderPdf.html", params);
            logger.info(html);
            filename = "\u91c7\u8d2d\u8ba2\u5355PDF" + DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd-HH-mm");
            pdfFile = PurchaseOrderPdfPrintUtil.createEmptyPDF(headerVo.getProjectId(), headerVo.getCompanyId(), filename);
            HtmlToPdfUtils.generatePdf((String)html, (File)pdfFile.toFile(), (String)"A4", (boolean)true, (String)filename);
            logger.info("=====================> \u91c7\u8d2d\u8ba2\u5355\u751f\u6210PDF\u7ed3\u675f");
            return pdfFile;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("=====================> \u91c7\u8d2d\u8ba2\u5355\u751f\u6210PDF\u5f02\u5e38");
            throw new CommonException("\u91c7\u8d2d\u8ba2\u5355\u5bfc\u51faPDF\u5f02\u5e38");
        }
    }

    public static FileData createEmptyPDF(String projectId, String companyId, String filename) throws UnsupportedEncodingException, IOException {
        FileData pdfFile = new FileData();
        pdfFile.setProjectId(projectId);
        pdfFile.setCompanyId(companyId);
        pdfFile.setFileName(filename + ".pdf");
        pdfFile.setFileSuffix("pdf");
        pdfFile.setIsEncrypt(String.valueOf(Constant.NO_INT));
        pdfFile.setExpiryDay(DateUtils.addMinutes((Date)new Date(), (int)30));
        FileManagerFactory.getFileManager().createEmptyFile(pdfFile);
        return pdfFile;
    }
}

