/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.utils;

import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.supperorder.entity.SupplierOrder;
import com.els.base.supperorder.entity.SupplierOrderItem;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.qrcode.QrcodeUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class SysUtil {
    private static final Logger logger = LoggerFactory.getLogger(SysUtil.class);
    private static final int PRINT_PAGE_SIZE = 10;

    public static String getOrderNumber(String purchaseOrderNumber) {
        String newPurchaseOrderNumber = "";
        Calendar a = Calendar.getInstance();
        int year = a.get(1) % 100;
        if (StringUtils.isBlank((String)purchaseOrderNumber)) {
            newPurchaseOrderNumber = "20" + year + "00000001";
        } else {
            int lastNumber = Integer.parseInt(purchaseOrderNumber.substring(4)) + 1;
            String addZero = "";
            for (int i = 0; i < 8 - (lastNumber + "").length(); ++i) {
                addZero = addZero + "0";
            }
            newPurchaseOrderNumber = "20" + year + addZero + lastNumber;
        }
        return newPurchaseOrderNumber;
    }

    public static String getNextDeliveryNumber() {
        GenerateCodeService generateCodeService = (GenerateCodeService)SpringContextHolder.getOneBean(GenerateCodeService.class);
        String newNo = generateCodeService.getNextCode("DELIVERY_NO_GENERATOR");
        return newNo;
    }

    public static String getNextLogisticsNumber() {
        GenerateCodeService generateCodeService = (GenerateCodeService)SpringContextHolder.getOneBean(GenerateCodeService.class);
        String newNo = generateCodeService.getNextCode("LOGISTIC_NO_GENERATOR");
        return newNo;
    }

    public static String getNextInvoiceNumber() {
        GenerateCodeService generateCodeService = (GenerateCodeService)SpringContextHolder.getOneBean(GenerateCodeService.class);
        String newNo = generateCodeService.getNextCode("VOINCE_NO_GENERATOR");
        return newNo;
    }

    public static String removeZero(String val) {
        if (StringUtils.isBlank((String)val)) {
            return val;
        }
        int len = val.length();
        int index = 0;
        char[] strs = val.toCharArray();
        for (int i = 0; i < len; ++i) {
            if ('0' == strs[i]) continue;
            index = i;
            break;
        }
        return val.substring(index, len);
    }

    public static String addZero(String val, int length) {
        if (StringUtils.isBlank((String)val)) {
            return val;
        }
        int len = val.length();
        boolean index = false;
        char[] strs = val.toCharArray();
        String zeroStr = "";
        for (int i = 0; i < length - len; ++i) {
            zeroStr = zeroStr + "0";
        }
        return zeroStr + val;
    }

    public static String getNextFileName() {
        String rid = "";
        rid = "f" + DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd").substring(2, DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd").length());
        Random random = new Random();
        int rannum = (int)(random.nextDouble() * 90000.0) + 10000;
        return rid + rannum;
    }

    public static FileData createQrcode(String content, String charsetName, int width, FileData fileUpload) {
        FileData fileData = null;
        try {
            BufferedImage bufferedImage = QrcodeUtils.writeQrcode((String)content, (String)charsetName, (int)width);
            InputStream in = SysUtil.getImageStream(bufferedImage);
            fileData = FileManagerFactory.getFileManager().write(in, fileUpload);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fileData;
    }

    public static InputStream getImageStream(BufferedImage bi) {
        ByteArrayInputStream is = null;
        bi.flush();
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        try {
            ImageOutputStream imOut = ImageIO.createImageOutputStream(bs);
            ImageIO.write((RenderedImage)bi, "png", imOut);
            is = new ByteArrayInputStream(bs.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return is;
    }

    public static BigDecimal getCanDeliveryAmount(BigDecimal quantity, BigDecimal onwayQuantity, BigDecimal receivedQuantity, BigDecimal freezeQuantity) {
        BigDecimal canDeliveryAmount = new BigDecimal("0");
        quantity = quantity == null ? BigDecimal.ZERO : quantity;
        onwayQuantity = onwayQuantity == null ? BigDecimal.ZERO : onwayQuantity;
        receivedQuantity = receivedQuantity == null ? BigDecimal.ZERO : receivedQuantity;
        freezeQuantity = freezeQuantity == null ? BigDecimal.ZERO : freezeQuantity;
        canDeliveryAmount = quantity.subtract(onwayQuantity).subtract(receivedQuantity).subtract(freezeQuantity);
        logger.info("----------quantity--------[" + quantity + "]-----onwayQuantity------[" + onwayQuantity + "]--------canDeliveryAmount----[" + canDeliveryAmount + "]-------freezeQuantity----[" + freezeQuantity + "]-----");
        return canDeliveryAmount;
    }

    public static void purhcaseTosSupplier(PurchaseOrder purchaseOrder, SupplierOrder supplierOrder) {
        BeanUtils.copyProperties((Object)purchaseOrder, (Object)supplierOrder);
        supplierOrder.setUserId(purchaseOrder.getSupUserId());
        supplierOrder.setUserName(purchaseOrder.getSupUserName());
        supplierOrder.setCompanyId(purchaseOrder.getSupCompanyId());
        supplierOrder.setCompanySapCode(purchaseOrder.getSupCompanySapCode());
        supplierOrder.setCompanyName(purchaseOrder.getSupCompanyName());
        supplierOrder.setPurUserId(purchaseOrder.getUserId());
        supplierOrder.setPurUserName(purchaseOrder.getUserName());
        supplierOrder.setPurCompanyId(purchaseOrder.getCompanyId());
        supplierOrder.setPurCompanyCode(purchaseOrder.getCompanyCode());
        supplierOrder.setPurCompanyName(purchaseOrder.getCompanyName());
        Date date = new Date();
        supplierOrder.setCreateTime(date);
        supplierOrder.setLastUpdateTime(date);
        ArrayList<SupplierOrderItem> supplierOrderItems = new ArrayList<SupplierOrderItem>();
        List<PurchaseOrderItem> purchaseOrderItems = purchaseOrder.getItems();
        for (PurchaseOrderItem purchaseOrderItem : purchaseOrderItems) {
            SupplierOrderItem supplierOrderItem = new SupplierOrderItem();
            BeanUtils.copyProperties((Object)purchaseOrderItem, (Object)supplierOrderItem);
            supplierOrderItem.setUserId(supplierOrder.getUserId());
            supplierOrderItem.setUserName(supplierOrder.getUserName());
            supplierOrderItem.setCompanyId(supplierOrder.getCompanyId());
            supplierOrderItem.setCompanyName(supplierOrder.getCompanyName());
            supplierOrderItem.setPurUserId(supplierOrder.getPurUserId());
            supplierOrderItem.setPurUserName(supplierOrder.getPurUserName());
            supplierOrderItem.setPurCompanyId(supplierOrder.getPurCompanyId());
            supplierOrderItem.setPurCompanyName(supplierOrder.getPurCompanyName());
            supplierOrderItem.setSapSupCompanyCode(supplierOrder.getCompanySapCode());
            supplierOrderItem.setUpdateTime(date);
            supplierOrderItem.setItemDescription(purchaseOrderItem.getItemDescription());
            supplierOrderItem.setItemType(purchaseOrderItem.getItemType());
            supplierOrderItem.setOrderType(purchaseOrder.getOrderType());
            supplierOrderItem.setOrderTypeDesc(purchaseOrder.getOrderTypeDesc());
            supplierOrderItem.setNeedFollowNo(purchaseOrderItem.getNeedFollowNo());
            supplierOrderItem.setWbsNo(purchaseOrderItem.getWbsNo());
            supplierOrderItem.setWbsNoDesc(purchaseOrderItem.getWbsNoDesc());
            supplierOrderItems.add(supplierOrderItem);
        }
        supplierOrder.setItems(supplierOrderItems);
    }

    public static SupplierOrderItem purhcaseItemTosSupplierItem(PurchaseOrder purchaseOrder, PurchaseOrderItem purchaseOrderItem) {
        SupplierOrderItem supplierOrderItem = new SupplierOrderItem();
        BeanUtils.copyProperties((Object)purchaseOrderItem, (Object)supplierOrderItem);
        supplierOrderItem.setUserId(purchaseOrder.getUserId());
        supplierOrderItem.setUserName(purchaseOrder.getUserName());
        supplierOrderItem.setCompanyId(purchaseOrder.getCompanyId());
        supplierOrderItem.setCompanyName(purchaseOrder.getCompanyName());
        supplierOrderItem.setPurUserId(purchaseOrderItem.getPurUserId());
        supplierOrderItem.setPurUserName(purchaseOrderItem.getPurUserName());
        supplierOrderItem.setPurCompanyId(purchaseOrderItem.getPurCompanyId());
        supplierOrderItem.setPurCompanyName(purchaseOrderItem.getPurCompanyName());
        supplierOrderItem.setSapSupCompanyCode(purchaseOrderItem.getSapSupCompanyCode());
        supplierOrderItem.setUpdateTime(new Date());
        supplierOrderItem.setItemDescription(purchaseOrderItem.getItemDescription());
        supplierOrderItem.setItemType(purchaseOrderItem.getItemType());
        supplierOrderItem.setOrderType(purchaseOrderItem.getOrderType());
        supplierOrderItem.setOrderTypeDesc(purchaseOrder.getOrderTypeDesc());
        supplierOrderItem.setNeedFollowNo(purchaseOrderItem.getNeedFollowNo());
        supplierOrderItem.setWbsNo(purchaseOrderItem.getWbsNo());
        supplierOrderItem.setWbsNoDesc(purchaseOrderItem.getWbsNoDesc());
        return supplierOrderItem;
    }

    public static boolean isReturnNewRecord() {
        Properties properties = (Properties)SpringContextHolder.getBean((String)"sysConfig");
        if (properties != null) {
            String isReturnNewRecord = properties.getProperty("order.isReturnNewRecord", "true");
            return Boolean.valueOf(isReturnNewRecord);
        }
        return true;
    }
}

