/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.delivery.command;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.delivery.entity.DeliveryOrder;
import com.els.base.delivery.entity.DeliveryOrderExample;
import com.els.base.delivery.utils.DeliveryStatusEnum;
import com.els.base.delivery.web.vo.DeliveryOrderTypeEnum;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.plan.entity.PurDeliveryPlanItem;
import com.els.base.plan.entity.PurDeliveryPlanItemExample;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.plan.entity.SupDeliveryPlanItemExample;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class ArrivedCommand
extends AbstractCommand<String> {
    private static final long serialVersionUID = 1L;
    private String deliveryOrderNo;

    public ArrivedCommand(String deliveryOrderNo) {
        this.deliveryOrderNo = deliveryOrderNo;
    }

    @Override
    public String execute(ICommandInvoker context) {
        DeliveryOrder deliveryOrder = this.getDeliveryOrder(this.deliveryOrderNo.trim());
        this.valid(deliveryOrder);
        this.updateDelivereyOrder(deliveryOrder);
        this.updateDeliveryPlan(deliveryOrder);
        return null;
    }

    public void sendToSupCompany(DeliveryOrder deliveryOrder) {
        User purUser = this.getPurUser();
        deliveryOrder.setPurUserName(purUser.getNickName());
        Company company = ContextUtils.getCompanyService().queryCompanyBySapCode(deliveryOrder.getCompanyCode());
        User supUser = ContextUtils.getCompanyUserRefService().queryMainUserOfCompany(company.getId());
        Message deliveryOrderMessage = Message.init((Object)deliveryOrder).setCompanyCode(company.getCompanyCode()).setBusinessTypeCode(DeliveryOrderTypeEnum.CONFIRM_TO_FACTORY.getCode()).setSenderId(purUser.getId()).addReceiverId(supUser.getId()).setMsgLevel(MessageLevelEnum.HIGH);
        this.logger.info("ArrivedCommand:\u53d1\u9001\u6d88\u606fstart");
        MessageSendUtils.sendMessage((Message)deliveryOrderMessage);
        this.logger.info("ArrivedCommand:\u53d1\u9001\u6d88\u606fend");
    }

    private DeliveryOrder getDeliveryOrder(String deliveryOrderNo) {
        DeliveryOrderExample example = new DeliveryOrderExample();
        DeliveryOrderExample.Criteria criteria = example.createCriteria();
        criteria.andDeliveryOrderNoEqualTo(deliveryOrderNo);
        List deliveryOrderList = ContextUtils.getDeliveryOrderService().queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)deliveryOrderList)) {
            return null;
        }
        return (DeliveryOrder)deliveryOrderList.get(0);
    }

    private void updateDeliveryPlan(DeliveryOrder deliveryOrder) {
        PurDeliveryPlanItemExample example = new PurDeliveryPlanItemExample();
        example.createCriteria().andDeliveryOrderIdEqualTo(deliveryOrder.getId());
        PurDeliveryPlanItem tmpDeliveryPlanItem = new PurDeliveryPlanItem();
        tmpDeliveryPlanItem.setSendTime(new Date());
        ContextUtils.getPurDeliveryPlanItemService().modifyByExample(tmpDeliveryPlanItem, example);
        SupDeliveryPlanItemExample supExample = new SupDeliveryPlanItemExample();
        example.createCriteria().andDeliveryOrderIdEqualTo(deliveryOrder.getId());
        SupDeliveryPlanItem tmpSupDeliveryPlanItem = new SupDeliveryPlanItem();
        tmpSupDeliveryPlanItem.setSendTime(new Date());
        ContextUtils.getSupDeliveryPlanItemService().modifyByExample(tmpSupDeliveryPlanItem, supExample);
    }

    private void updateDelivereyOrder(DeliveryOrder deliveryOrder) {
        DeliveryOrder tmpDeliveryOrder = new DeliveryOrder();
        tmpDeliveryOrder.setId(deliveryOrder.getId());
        tmpDeliveryOrder.setGateScanTime(new Date());
        tmpDeliveryOrder.setDeliveryStatus(DeliveryStatusEnum.TO_FACTORY.getValue());
        ContextUtils.getDeliveryOrderService().modifyObj(tmpDeliveryOrder);
    }

    private void valid(DeliveryOrder deliveryOrder) {
        Assert.isNotNull((Object)deliveryOrder, (String)"\u7cfb\u7edf\u627e\u4e0d\u5230\u8be5\u9001\u8d27\u5355\uff0c\u65e0\u6cd5\u505a\u5230\u5382\u786e\u8ba4");
        if (DeliveryStatusEnum.UN_SENT.getValue().equals(deliveryOrder.getDeliveryStatus())) {
            throw new CommonException("\u8be5\u9001\u8d27\u5355\u672a\u53d1\u8d27\uff0c\u65e0\u6cd5\u505a\u5230\u5382\u786e\u8ba4");
        }
        if (DeliveryStatusEnum.TO_FACTORY.getValue().equals(deliveryOrder.getDeliveryStatus())) {
            throw new CommonException("\u8be5\u9001\u8d27\u5355\u5df2\u5230\u5382\uff0c\u65e0\u6cd5\u505a\u5230\u5382\u786e\u8ba4");
        }
        if (DeliveryStatusEnum.ALL_RECEIVED.getValue().equals(deliveryOrder.getDeliveryStatus())) {
            throw new CommonException("\u8be5\u9001\u8d27\u5355\u5df2\u6536\u8d27\uff0c\u65e0\u6cd5\u505a\u5230\u5382\u786e\u8ba4");
        }
        if (Constant.NO_INT.equals(deliveryOrder.getIsEnable())) {
            throw new CommonException("\u8be5\u9001\u8d27\u5355\u5df2\u4f5c\u5e9f\uff0c\u65e0\u6cd5\u505a\u5230\u5382\u786e\u8ba4");
        }
        if (DeliveryStatusEnum.ONWAY.equals(deliveryOrder.getDeliveryStatus())) {
            throw new CommonException("\u8be5\u9001\u8d27\u5355\u4e0d\u662f\u9001\u8d27\u72b6\u6001\uff0c\u65e0\u6cd5\u5230\u5382\u786e\u8ba4");
        }
    }
}

