/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.command.jit.plan;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.utils.Constant;
import com.els.base.plan.entity.DeliveryPlan;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.google.common.collect.ArrayListMultimap;
import java.math.BigDecimal;
import java.util.List;
import java.util.Set;

public class ModifyJitPlanAllocatedCmd
extends AbstractCommand {
    private List<SupDeliveryPlanItem> planItemLists;

    public ModifyJitPlanAllocatedCmd(List<SupDeliveryPlanItem> planItemLists) {
        this.planItemLists = planItemLists;
    }

    public Object execute(ICommandInvoker context) {
        ArrayListMultimap arrayListMultiMap = ArrayListMultimap.create();
        for (SupDeliveryPlanItem planItem : this.planItemLists) {
            String key2 = planItem.getPlanId();
            arrayListMultiMap.put((Object)key2, (Object)planItem);
        }
        Set keySet = arrayListMultiMap.keySet();
        keySet.stream().forEach(key -> {
            List lists = arrayListMultiMap.get(key);
            BigDecimal distributableNum = lists.stream().map(item -> item.getDeliveryQuantity()).reduce((x, y) -> x.add((BigDecimal)y)).get();
            BigDecimal consumeMunber = ((SupDeliveryPlanItem)lists.get(0)).getConsumeMunber();
            DeliveryPlan plan = new DeliveryPlan();
            plan.setId((String)key);
            if (distributableNum.compareTo(consumeMunber) < 0) {
                plan.setIsAllocated(2);
            } else {
                plan.setIsAllocated(Constant.YES_INT);
            }
            if (distributableNum.compareTo(BigDecimal.ZERO) == 0) {
                plan.setIsAllocated(Constant.NO_INT);
            }
            ContextUtils.getDeliveryPlanService().modifyObj(plan);
        });
        return null;
    }
}

