/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.utils;

import com.els.base.common.ContextUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.material.entity.MaterialExt;
import com.els.base.material.entity.MaterialExtExample;
import com.els.base.plan.entity.DeliveryPlan;
import com.els.base.plan.entity.JITDemandMerge;
import com.els.base.plan.entity.JITDemandMergeTime;
import com.els.base.plan.entity.JITMaterialDemand;
import com.els.base.plan.entity.JITSupRef;
import com.els.base.plan.entity.PurDeliveryPlanItem;
import com.els.base.plan.entity.PurDeliveryPlanItemExample;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.plan.entity.SupDeliveryPlanItemExample;
import com.els.base.plan.utils.DeliveryPlanUesdStatusEnum;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.PurchaseOrderItemExample;
import com.els.base.utils.uuid.UUIDGenerator;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.springframework.beans.BeanUtils;

public class JitPlanUtils {
    public static final long ONEDATE = 86400000L;

    public static List<DeliveryPlan> mergeDemands(List<JITMaterialDemand> demands) {
        ArrayListMultimap arrayListMultiMap = ArrayListMultimap.create();
        for (JITMaterialDemand demand2 : demands) {
            String key = demand2.getFactoryCode() + demand2.getMaterialCode() + demand2.getArryvalTime();
            arrayListMultiMap.put((Object)key, (Object)demand2);
        }
        Set keySet = arrayListMultiMap.keySet();
        ArrayList deliveryPlanList = Lists.newArrayList();
        for (String key : keySet) {
            List demandGroup = arrayListMultiMap.get((Object)key);
            BigDecimal result = demandGroup.stream().map(demand -> demand.getConsumeMunber()).reduce((x, y) -> x.add((BigDecimal)y)).get();
            DeliveryPlan deliveryPlan = new DeliveryPlan();
            deliveryPlan.setId(UUIDGenerator.generateUUID());
            deliveryPlan.setConsumeMunber(result);
            deliveryPlan.setFactoryCode(((JITMaterialDemand)demandGroup.get(0)).getFactoryCode());
            deliveryPlan.setFactoryName(((JITMaterialDemand)demandGroup.get(0)).getFactoryName());
            deliveryPlan.setMaterialCode(((JITMaterialDemand)demandGroup.get(0)).getMaterialCode());
            deliveryPlan.setMaterialDescride(((JITMaterialDemand)demandGroup.get(0)).getMaterialDescribe());
            deliveryPlan.setJitItem(((JITMaterialDemand)demandGroup.get(0)).getJitItem());
            deliveryPlan.setUnit(((JITMaterialDemand)demandGroup.get(0)).getUnit());
            deliveryPlan.setMergId(((JITMaterialDemand)demandGroup.get(0)).getMergId());
            deliveryPlan.setArryvalTime(((JITMaterialDemand)demandGroup.get(0)).getArryvalTime());
            deliveryPlan.setIsLock(((JITMaterialDemand)demandGroup.get(0)).getIsLock() == null ? "N" : ((JITMaterialDemand)demandGroup.get(0)).getIsLock());
            deliveryPlan.setStatus(Constant.NO_INT);
            deliveryPlan.setCreateTime(new Date());
            deliveryPlan.setUsedStatus("N");
            deliveryPlan.setIsEnable(Constant.YES_INT);
            deliveryPlan.setPurOrderNumberRouding(((JITMaterialDemand)demandGroup.get(0)).getPurOrderNumberRouding());
            deliveryPlan.setMaterialGroup(((JITMaterialDemand)demandGroup.get(0)).getMaterialGroup());
            deliveryPlan.setExternalMaterialGroup(((JITMaterialDemand)demandGroup.get(0)).getExternalMaterialGroup());
            deliveryPlanList.add(deliveryPlan);
        }
        Collections.sort(deliveryPlanList, new Comparator<DeliveryPlan>(){

            @Override
            public int compare(DeliveryPlan o1, DeliveryPlan o2) {
                if (o1.getArryvalTime().after(o2.getArryvalTime())) {
                    return 1;
                }
                if (o1.getArryvalTime().before(o2.getArryvalTime())) {
                    return -1;
                }
                if (o1.getArryvalTime().equals(o2.getArryvalTime())) {
                    return 0;
                }
                return 0;
            }
        });
        return deliveryPlanList;
    }

    public static SupDeliveryPlanItem initSupDeliveryPlanItem(DeliveryPlan plan, JITSupRef jitSupRef) {
        SupDeliveryPlanItem item = new SupDeliveryPlanItem();
        item.setQuota(jitSupRef.getQuota());
        item.setLastDistributeMun(jitSupRef.getLastDistributeMun());
        item.setPlanSendStatus("Y");
        item.setSendStatus("Y");
        item.setDeliveryDate(plan.getArryvalTime());
        item.setSupCompanyId(jitSupRef.getSupCompanyId());
        item.setSupCompanySapCode(jitSupRef.getSupCompanySapCode());
        item.setSupCompanySrmCode(jitSupRef.getSupCompanyCode());
        item.setSupCompanyName(jitSupRef.getSupCompanyName());
        item.setPurCompanyId(jitSupRef.getPurCompanyId());
        item.setPurCompanySapCode(jitSupRef.getPurCompanySapCode());
        item.setPurCompanySrmCode(jitSupRef.getPurCompanyCode());
        item.setPurCompanyName(jitSupRef.getPurCompanyName());
        item.setIsLock(plan.getIsLock());
        item.setConsumeMunber(plan.getConsumeMunber());
        item.setIsEnable(Constant.YES_INT);
        item.setMaterialNo(plan.getMaterialCode());
        item.setMaterialDesc(plan.getMaterialDescride());
        item.setMaterialGroup(plan.getMaterialGroup());
        item.setExternalMaterialGroup(plan.getExternalMaterialGroup());
        item.setOrderUnit(plan.getUnit());
        item.setFactoryCode(plan.getFactoryCode());
        item.setFactoryName(plan.getFactoryName());
        item.setPurRemark("ASPROVE\u751f\u6210");
        return item;
    }

    public static long getHms(Date date, boolean isIncludeSecond) {
        if (date == null) {
            return 0L;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        String hms = sdf.format(date);
        String[] split = hms.split(":");
        long time = Integer.parseInt(split[0]) * 60 * 60 * 1000 + Integer.parseInt(split[1]) * 60 * 1000;
        if (isIncludeSecond) {
            time += (long)(Integer.parseInt(split[2]) * 1000);
        }
        return time;
    }

    public static void initArryValTimeAndLockByMerge(List<JITDemandMerge> mergeList, JITMaterialDemand j) {
        Date now = new Date();
        long lock = (now.getTime() - JitPlanUtils.getHms(now, true) + 86400000L + 86400000L) / 1000L * 1000L;
        long demandTime = JitPlanUtils.getHms(j.getDemandTime(), false);
        long second = JitPlanUtils.getHms(j.getDemandTime(), true) - demandTime;
        if (mergeList.size() > 0) {
            if (demandTime < JitPlanUtils.getHms(mergeList.get(0).getStartTime(), false)) {
                demandTime += 86400000L;
            }
        } else {
            if (j.getDemandTime().getTime() < lock) {
                j.setIsLock("F");
            }
            j.setArryvalTime(new Date(j.getDemandTime().getTime() - second));
        }
        for (JITDemandMerge merge : mergeList) {
            long finalTime;
            long startTime = JitPlanUtils.getHms(merge.getStartTime(), false);
            if (startTime >= (finalTime = JitPlanUtils.getHms(merge.getFinalTime(), false))) {
                finalTime += 86400000L;
            }
            if (startTime > demandTime || demandTime >= finalTime) continue;
            long arryvalTime = j.getDemandTime().getTime() - second - demandTime + startTime;
            if (arryvalTime < lock) {
                j.setIsLock("F");
            } else {
                j.setIsLock("N");
            }
            j.setArryvalTime(new Date(arryvalTime));
            j.setMergId(merge.getId());
            break;
        }
    }

    public static List<JITDemandMerge> setMergeFinalTime(JITDemandMerge merge, List<JITDemandMergeTime> lists) {
        int i;
        for (i = 0; i < lists.size() - 1; ++i) {
            for (int j = 0; j < lists.size() - i - 1; ++j) {
                JITDemandMergeTime o1 = lists.get(j);
                JITDemandMergeTime o2 = lists.get(j + 1);
                if (JitPlanUtils.getHms(o1.getStartTime(), false) > JitPlanUtils.getHms(o2.getStartTime(), false)) {
                    if (JitPlanUtils.getHms(o1.getStartTime(), false) <= JitPlanUtils.getHms(o2.getEndTime(), false)) {
                        throw new CommonException("\u6536\u8d27\u7a97\u53e3\u65f6\u95f4\u4e0d\u80fd\u91cd\u53e0");
                    }
                    lists.set(j, o2);
                    lists.set(j + 1, o1);
                }
                if (JitPlanUtils.getHms(o1.getStartTime(), false) < JitPlanUtils.getHms(o2.getStartTime(), false)) {
                    if (JitPlanUtils.getHms(o2.getStartTime(), false) <= JitPlanUtils.getHms(o1.getEndTime(), false)) {
                        throw new CommonException("\u6536\u8d27\u7a97\u53e3\u65f6\u95f4\u4e0d\u80fd\u91cd\u53e0");
                    }
                    o1.setFinalTime(o2.getStartTime());
                }
                if (JitPlanUtils.getHms(o1.getStartTime(), false) != JitPlanUtils.getHms(o2.getStartTime(), false)) continue;
                throw new CommonException("\u6536\u8d27\u7a97\u53e3\u65f6\u95f4\u4e0d\u80fd\u91cd\u53e0");
            }
        }
        for (i = 0; i < lists.size() - 1; ++i) {
            lists.get(i).setFinalTime(lists.get(i + 1).getStartTime());
        }
        lists.get(lists.size() - 1).setFinalTime(lists.get(0).getStartTime());
        List<JITDemandMerge> mergeLists = lists.stream().map(t -> {
            merge.setStartTime(t.getStartTime());
            merge.setEndTime(t.getEndTime());
            merge.setFinalTime(t.getFinalTime());
            JITDemandMerge jitDemandMerge = new JITDemandMerge();
            BeanUtils.copyProperties((Object)merge, (Object)jitDemandMerge);
            return jitDemandMerge;
        }).collect(Collectors.toList());
        return mergeLists;
    }

    public static BigDecimal getUndistributNum(String companyCode, String factory, String materialCode, String supCompanyName) {
        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        example.createCriteria().andSupCompanySapCodeEqualTo(companyCode).andFactoryEqualTo(factory).andMaterialCodeEqualTo(materialCode).andIsEnableEqualTo(Constant.YES_INT).andFinishFlagNotEqualTo("Y").andReturnFlagIsNull();
        List orderItemList = ContextUtils.getPurchaseOrderItemService().queryAllObjByExample((IExample)example);
        Assert.isNotEmpty((Collection)orderItemList, (String)("\u5bfc\u5165\u5931\u8d25\uff1b\u5de5\u5382\u4ee3\u7801\uff1a" + factory + "\u7269\u6599\u7f16\u7801\uff1a" + materialCode + "\u4f9b\u5e94\u5546\uff1a" + supCompanyName + " \u4e0d\u5b58\u5728\u91c7\u8d2d\u8ba2\u5355"));
        BigDecimal distributableNum = orderItemList.stream().map(PurchaseOrderItem::getCanDeliveryQuantity).filter(num -> num.compareTo(BigDecimal.ZERO) > 0).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal distributedNum = ContextUtils.getSupDeliveryPlanItemService().getdistributedNum(companyCode, materialCode, factory, null);
        return distributableNum.subtract(distributedNum);
    }

    public static String getMaterialJitItem(String materialCode, String factory) {
        MaterialExtExample example = new MaterialExtExample();
        example.createCriteria().andMaterialCodeEqualTo(materialCode).andFactoryEqualTo(factory);
        List materialExtList = ContextUtils.getMaterialService().queryMaterialExtByExampl(example);
        if (materialExtList.size() > 0) {
            String jitItem = ((MaterialExt)materialExtList.get(0)).getJitItem();
            if (StringUtils.isBlank((String)jitItem) || "0".equals(jitItem)) {
                throw new CommonException("\u7269\u6599\u7f16\u7801\uff1a" + materialCode + "\u4e0d\u662fJIT\u7269\u6599");
            }
            return jitItem;
        }
        throw new CommonException("\u7269\u6599\u7f16\u7801\uff1a" + materialCode + "\u4e0d\u662fJIT\u7269\u6599");
    }

    public static void closeValid(List<PurDeliveryPlanItem> list) {
        list.stream().forEach(item -> {
            if (item.getOnwayQuantity() != null && item.getOnwayQuantity().compareTo(BigDecimal.ZERO) != 0) {
                throw new CommonException("\u5173\u95ed\u5931\u8d25\uff1b\u5de5\u5382\u4ee3\u7801\uff1a" + item.getFactoryCode() + "\u7269\u6599\u7f16\u7801\uff1a" + item.getMaterialNo() + "\u8981\u6c42\u5230\u8d27\u65f6\u95f4\uff1a" + DateFormatUtils.format((Date)item.getDeliveryDate(), (String)"yyyy-MM-dd HH:mm:ss") + "\u5b58\u5728\u5728\u9014\u9001\u8d27\u5355\uff0c\u4e0d\u80fd\u5173\u95ed");
            }
            if (DeliveryPlanUesdStatusEnum.ALL_USED.getValue().equals(item.getUsedStatus())) {
                throw new CommonException("\u5173\u95ed\u5931\u8d25\uff1b\u5de5\u5382\u4ee3\u7801\uff1a" + item.getFactoryCode() + "\u7269\u6599\u7f16\u7801\uff1a" + item.getMaterialNo() + "\u8981\u6c42\u5230\u8d27\u65f6\u95f4\uff1a" + DateFormatUtils.format((Date)item.getDeliveryDate(), (String)"yyyy-MM-dd HH:mm:ss") + "\u5df2\u5b8c\u6210\u53d1\u8d27\uff0c\u4e0d\u80fd\u5173\u95ed");
            }
            if (DeliveryPlanUesdStatusEnum.COLSE_SUCCESS.getValue().equals(item.getUsedStatus())) {
                throw new CommonException("\u5173\u95ed\u5931\u8d25\uff1b\u5de5\u5382\u4ee3\u7801\uff1a" + item.getFactoryCode() + "\u7269\u6599\u7f16\u7801\uff1a" + item.getMaterialNo() + "\u8981\u6c42\u5230\u8d27\u65f6\u95f4\uff1a" + DateFormatUtils.format((Date)item.getDeliveryDate(), (String)"yyyy-MM-dd HH:mm:ss") + "\u5df2\u5173\u95ed\uff0c\u4e0d\u80fd\u5173\u95ed");
            }
        });
    }

    public static void closePlanValid(List<String> planItemIds) {
        PurDeliveryPlanItemExample example = new PurDeliveryPlanItemExample();
        example.createCriteria().andIdIn((List)planItemIds);
        List list = ContextUtils.getPurDeliveryPlanItemService().queryAllObjByExample((IExample)example);
        JitPlanUtils.closeValid(list);
    }

    public static void closePlanAndOrderValid(List<String> planItemIds) {
        PurDeliveryPlanItemExample example = new PurDeliveryPlanItemExample();
        example.createCriteria().andIdIn((List)planItemIds);
        List list = ContextUtils.getPurDeliveryPlanItemService().queryAllObjByExample((IExample)example);
        list.stream().forEach(item -> {
            if (DeliveryPlanUesdStatusEnum.UN_USED.getValue().equals(item.getUsedStatus())) {
                throw new CommonException("\u5173\u95ed\u5931\u8d25\uff1b\u5de5\u5382\u4ee3\u7801\uff1a" + item.getFactoryCode() + "\u7269\u6599\u7f16\u7801\uff1a" + item.getMaterialNo() + "\u8981\u6c42\u5230\u8d27\u65f6\u95f4\uff1a" + DateFormatUtils.format((Date)item.getDeliveryDate(), (String)"yyyy-MM-dd HH:mm:ss") + "\u672a\u53d1\u8d27\uff0c\u65e0\u91c7\u8d2d\u8ba2\u5355\u5173\u95ed");
            }
            if (item.getOnwayQuantity() == null || item.getOnwayQuantity().compareTo(BigDecimal.ZERO) == 0) {
                throw new CommonException("\u5173\u95ed\u5931\u8d25\uff1b\u5de5\u5382\u4ee3\u7801\uff1a" + item.getFactoryCode() + "\u7269\u6599\u7f16\u7801\uff1a" + item.getMaterialNo() + "\u8981\u6c42\u5230\u8d27\u65f6\u95f4\uff1a" + DateFormatUtils.format((Date)item.getDeliveryDate(), (String)"yyyy-MM-dd HH:mm:ss") + "\u4e0d\u5b58\u5728\u5728\u9014\u9001\u8d27\u5355\uff0c\u65e0\u91c7\u8d2d\u8ba2\u5355\u5173\u95ed");
            }
        });
        JitPlanUtils.closeValid(list);
    }

    public static void closePlanItem(List<String> planItemIds) {
        PurDeliveryPlanItemExample purExample = new PurDeliveryPlanItemExample();
        purExample.createCriteria().andIdIn((List)planItemIds);
        PurDeliveryPlanItem purDeliveryPlanItem = new PurDeliveryPlanItem();
        purDeliveryPlanItem.setIsCanDelivery(Constant.NO_INT);
        purDeliveryPlanItem.setUsedStatus(DeliveryPlanUesdStatusEnum.COLSE_SUCCESS.getValue());
        ContextUtils.getPurDeliveryPlanItemService().modifyByExample(purDeliveryPlanItem, purExample);
        SupDeliveryPlanItemExample supExample = new SupDeliveryPlanItemExample();
        supExample.createCriteria().andIdIn((List)planItemIds);
        SupDeliveryPlanItem supDeliveryPlanItem = new SupDeliveryPlanItem();
        supDeliveryPlanItem.setIsCanDelivery(Constant.NO_INT);
        supDeliveryPlanItem.setUsedStatus(DeliveryPlanUesdStatusEnum.COLSE_SUCCESS.getValue());
        ContextUtils.getSupDeliveryPlanItemService().modifyByExample(supDeliveryPlanItem, supExample);
    }
}

