/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.service.impl;

import com.els.base.common.OrderCommandInvoker;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.plan.command.nonejit.pur.NoneJitPlanCreateCmd;
import com.els.base.purchase.command.order.RemindOfPurchaseOrderCmd;
import com.els.base.purchase.dao.PurchaseOrderMapper;
import com.els.base.purchase.entity.PurOrderItemExt;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderExample;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.service.PurOrderItemExtService;
import com.els.base.purchase.service.PurchaseOrderItemService;
import com.els.base.purchase.service.PurchaseOrderService;
import com.els.base.purchase.utils.ChangeTypeEnum;
import com.els.base.purchase.utils.PurchaseOrderConfirmStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderSendStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderUtils;
import com.els.base.utils.uuid.UUIDGenerator;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="purchaseOrderService")
public class PurchaseOrderServiceImpl
implements PurchaseOrderService {
    private static Logger logger = LoggerFactory.getLogger(PurchaseOrderServiceImpl.class);
    @Resource
    protected PurchaseOrderMapper purchaseOrderMapper;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected ThreadPoolTaskExecutor defaultThreadPool;
    @Resource
    protected OrderCommandInvoker invoker;
    @Resource
    protected PurchaseOrderItemService purchaseOrderItemService;
    @Resource
    protected PurOrderItemExtService purOrderItemExtService;

    @Transactional
    @CacheEvict(value={"purchaseOrder", "purchaseOrderItem"}, allEntries=true)
    public void addObj(PurchaseOrder purchaseOrder) {
        this.purchaseOrderMapper.insertSelective(purchaseOrder);
    }

    @CacheEvict(value={"purchaseOrder"}, allEntries=true)
    public void deleteObjById(String id) {
        this.purchaseOrderMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"purchaseOrder"}, allEntries=true)
    public void modifyObj(PurchaseOrder t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        this.purchaseOrderMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"purchaseOrder"}, keyGenerator="redisKeyGenerator")
    public PurchaseOrder queryObjById(String id) {
        return this.purchaseOrderMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"purchaseOrder"}, keyGenerator="redisKeyGenerator")
    public List<PurchaseOrder> queryAllObjByExample(PurchaseOrderExample example) {
        return this.purchaseOrderMapper.selectByExample(example);
    }

    @Cacheable(value={"purchaseOrder"}, keyGenerator="redisKeyGenerator")
    public PageView<PurchaseOrder> queryObjByPage(PurchaseOrderExample example) {
        PageView<PurchaseOrder> pageView = example.getPageView();
        List<PurchaseOrder> list = this.purchaseOrderMapper.selectByExampleByPage(example);
        for (PurchaseOrder purchaseOrder : list) {
            Company company = (Company)this.companyService.queryObjById((Object)purchaseOrder.getSupCompanyId());
            if (company == null) continue;
            purchaseOrder.setSupCompanyShortName(company.getCompanyName());
        }
        pageView.setQueryResult(list);
        return pageView;
    }

    @Override
    @Cacheable(value={"purchaseOrder"}, keyGenerator="redisKeyGenerator")
    public PageView<PurchaseOrder> queryHisObjByPage(PurchaseOrderExample example) {
        PageView<PurchaseOrder> pageView = example.getPageView();
        pageView.setQueryResult(this.purchaseOrderMapper.selectHisByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"purchaseOrder"}, allEntries=true)
    public void updateByPurcahseOrder(PurchaseOrder record, PurchaseOrderExample example) {
        this.purchaseOrderMapper.updateByExampleSelective(record, example);
    }

    @Override
    @Cacheable(value={"purchaseOrder"}, keyGenerator="redisKeyGenerator")
    public PageView<PurchaseOrder> queryObjNoItemsByPage(PurchaseOrderExample example, String purUserId, String materialCode, String brand) {
        PageView<PurchaseOrder> pageView = example.getPageView();
        List<PurchaseOrder> list = this.purchaseOrderMapper.selectForPurUserByExampleByPage(example, pageView, purUserId, materialCode, brand);
        pageView.setQueryResult(list);
        return pageView;
    }

    @Override
    @Cacheable(value={"purchaseOrder"}, keyGenerator="redisKeyGenerator")
    public PurchaseOrder queryByOrderNo(String projectId, String orderNo) {
        PurchaseOrderExample example = new PurchaseOrderExample();
        example.createCriteria().andProjectIdEqualTo(projectId).andOrderNoEqualTo(orderNo);
        List<PurchaseOrder> list = this.queryAllObjByExample(example);
        if (list != null && list.size() > 1) {
            throw new CommonException("\u51fa\u73b0\u91cd\u590d\u8ba2\u5355\u53f7\u7684\u95ee\u9898");
        }
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    @Override
    @CacheEvict(value={"purchaseOrder"}, allEntries=true)
    public String insertHis(String orderId, String cause) {
        String uuid = UUIDGenerator.generateUUID();
        this.purchaseOrderMapper.insertHis(uuid, orderId, cause, new Date());
        return uuid;
    }

    @Override
    public void overduePush() {
        RemindOfPurchaseOrderCmd command = new RemindOfPurchaseOrderCmd();
        this.invoker.invoke(command);
    }

    @CacheEvict(value={"purchaseOrder"}, allEntries=true)
    public void deleteByExample(PurchaseOrderExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.purchaseOrderMapper.deleteByExample(example);
    }

    @CacheEvict(value={"purchaseOrder"}, allEntries=true)
    public void addAll(List<PurchaseOrder> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> record.setId(UUIDGenerator.generateUUID()));
        this.purchaseOrderMapper.insertBatch(list);
    }

    @Override
    @Transactional
    @CacheEvict(value={"purchaseOrder"}, allEntries=true)
    public void createPurOrder(PurchaseOrder purchaseOrder, Company purCompany, User purUser) {
        boolean isFree;
        boolean isReturn;
        Assert.isNotBlank((String)purchaseOrder.getPurchaseApplyNo(), (String)"\u91c7\u8d2d\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)purchaseOrder.getOrderNo(), (String)"\u91c7\u8d2d\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkSupplierData(purchaseOrder);
        this.setPurCompanyData(purchaseOrder, purCompany, purUser);
        purchaseOrder.setOrderStatus(PurchaseOrderConfirmStatusEnum.UNCONFIRM.getValue());
        purchaseOrder.setOrderSendStatus(PurchaseOrderSendStatusEnum.NOTSEND.getValue());
        purchaseOrder.setCreateTime(new Date());
        if (purchaseOrder.getAuditStatus() == null) {
            purchaseOrder.setAuditStatus(Constant.YES_INT);
        }
        if (StringUtils.isBlank((String)purchaseOrder.getIsAudit())) {
            purchaseOrder.setIsAudit("Y");
        }
        if (purchaseOrder.getDeliveryStatus() == null) {
            purchaseOrder.setDeliveryStatus(PurchaseOrderUtils.isAllItemFinish(purchaseOrder.getItems()));
        }
        if (purchaseOrder.getIsEnable() == null) {
            purchaseOrder.setIsEnable(PurchaseOrderUtils.isAllItemEnable(purchaseOrder.getItems()));
        }
        if (isReturn = purchaseOrder.getItems().stream().anyMatch(item -> "Y".equals(item.getReturnFlag()))) {
            purchaseOrder.setReturnFlag("Y");
        }
        if (isFree = purchaseOrder.getItems().stream().anyMatch(item -> "Y".equals(item.getFreeFlag()))) {
            purchaseOrder.setFreeFlag("Y");
        }
        this.purchaseOrderMapper.insertSelective(purchaseOrder);
        for (PurchaseOrderItem item2 : purchaseOrder.getItems()) {
            this.checkItemSupplierData(item2);
            this.init(item2, purchaseOrder);
            this.purchaseOrderItemService.addObj(item2);
            this.addItemExt(item2);
        }
        if (!"Y".equals(purchaseOrder.getReturnFlag())) {
            NoneJitPlanCreateCmd createDeliveryPlanCmd = new NoneJitPlanCreateCmd(purchaseOrder);
            createDeliveryPlanCmd.setPurCompany(purCompany);
            createDeliveryPlanCmd.setPurUser(purUser);
            this.invoker.invoke(createDeliveryPlanCmd);
        }
    }

    private void addItemExt(PurchaseOrderItem item) {
        PurOrderItemExt ext = new PurOrderItemExt();
        ext.setOrderId(item.getOrderId());
        ext.setOrderItemId(item.getId());
        ext.setOrderNo(item.getOrderNo());
        ext.setOrderItemNo(item.getOrderItemNo());
        ext.setDeliveredQuantity(BigDecimal.ZERO);
        ext.setOnwayQuantity(BigDecimal.ZERO);
        ext.setReceivedQuantity(BigDecimal.ZERO);
        ext.setReturnQuantity(BigDecimal.ZERO);
        this.purOrderItemExtService.addObj(ext);
    }

    private void init(PurchaseOrderItem item, PurchaseOrder order) {
        item.setOrderId(order.getId());
        item.setOrderNo(order.getOrderNo());
        item.setOrderStatus(PurchaseOrderConfirmStatusEnum.UNCONFIRM.getValue());
        item.setPurCompanyId(order.getPurCompanyId());
        item.setPurCompanyName(order.getPurCompanyName());
        item.setPurUserId(order.getPurUserId());
        item.setPurUserName(order.getPurUserName());
        item.setSupUserId(order.getSupUserId());
        item.setSupUserName(order.getSupUserName());
        item.setCurrency(order.getCurrency());
        item.setUpdateTime(new Date());
        item.setIsUpdated(Constant.NO_INT);
        item.setQuaWarehouseQuantity(BigDecimal.ZERO);
        item.setHaveChange(ChangeTypeEnum.ADD_ITEM.getValue());
        item.setOrderNoType(order.getOrderType());
        if (item.getOrderDate() == null) {
            item.setOrderDate(order.getOrderDate());
        }
        if (item.getFreezeQuantity() == null) {
            item.setFreezeQuantity(BigDecimal.ZERO);
        }
        if (item.getAlreadyApplyMoney() == null) {
            item.setAlreadyApplyMoney(BigDecimal.ZERO);
        }
        if (item.getTaxTotalPrice() == null) {
            item.setAvailableApplyMoney(BigDecimal.ZERO);
        } else {
            item.setAvailableApplyMoney(item.getTaxTotalPrice());
        }
        item.setIsCanDelivery(Constant.YES_INT);
        if (Constant.NO_INT.equals(item.getIsEnable())) {
            item.setIsCanDelivery(Constant.NO_INT);
        }
        if ("Y".equals(item.getFinishFlag())) {
            item.setIsCanDelivery(Constant.NO_INT);
        }
    }

    private void checkItemSupplierData(PurchaseOrderItem item) {
        Assert.isNotBlank((String)item.getSupCompanyId(), (String)"\u4f9b\u5e94\u5546ID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)item.getSupCompanyName(), (String)"\u4f9b\u5e94\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)item.getSupCompanySrmCode(), (String)"\u4f9b\u5e94\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private void checkSupplierData(PurchaseOrder purchaseOrder) {
        Assert.isNotBlank((String)purchaseOrder.getSupCompanyId(), (String)"\u4f9b\u5e94\u5546\u516c\u53f8ID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)purchaseOrder.getSupCompanyName(), (String)"\u4f9b\u5e94\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)purchaseOrder.getSupCompanySrmCode(), (String)"\u4f9b\u5e94\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)purchaseOrder.getSupplierTel(), (String)"\u4f9b\u5e94\u5546\u8054\u7cfb\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)purchaseOrder.getSupplierPerson(), (String)"\u4f9b\u5e94\u5546\u8054\u7cfb\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)purchaseOrder.getSupUserId(), (String)"\u4f9b\u5e94\u5546\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)purchaseOrder.getSupUserName(), (String)"\u4f9b\u5e94\u5546\u7528\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private void setPurCompanyData(PurchaseOrder purchaseOrder, Company purCompany, User purUser) {
        purchaseOrder.setPurCompanyId(purCompany.getId());
        purchaseOrder.setPurCompanyName(purCompany.getCompanyFullName());
        purchaseOrder.setPurCompanySapCode(purCompany.getCompanySapCode());
        purchaseOrder.setPurCompanySrmCode(purCompany.getCompanyCode());
        purchaseOrder.setPurPlanerId(purUser.getId());
        purchaseOrder.setPurPlanerName(purUser.getNickName());
        purchaseOrder.setPurPlanerWorkNum(purUser.getWorkNum());
        purchaseOrder.setPurUserId(purUser.getId());
        purchaseOrder.setPurUserName(purUser.getNickName());
    }
}

