/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.catalogue.service.impl;

import com.els.base.catalogue.dao.PurchaseCatalogueItemMapper;
import com.els.base.catalogue.entity.PurchaseCatalogueItem;
import com.els.base.catalogue.entity.PurchaseCatalogueItemExample;
import com.els.base.catalogue.service.PurchaseCatalogueItemService;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultPurchaseCatalogueItemService")
public class PurchaseCatalogueItemServiceImpl
implements PurchaseCatalogueItemService {
    @Resource
    protected PurchaseCatalogueItemMapper purchaseCatalogueItemMapper;

    @CacheEvict(value={"purchaseCatalogueItem"}, allEntries=true)
    public void addObj(PurchaseCatalogueItem t) {
        this.purchaseCatalogueItemMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"purchaseCatalogueItem"}, allEntries=true)
    public void addAll(List<PurchaseCatalogueItem> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.purchaseCatalogueItemMapper.insertBatch(list);
    }

    @CacheEvict(value={"purchaseCatalogueItem"}, allEntries=true)
    public void deleteObjById(String id) {
        this.purchaseCatalogueItemMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"purchaseCatalogueItem"}, allEntries=true)
    public void deleteByExample(PurchaseCatalogueItemExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.purchaseCatalogueItemMapper.deleteByExample(example);
    }

    @CacheEvict(value={"purchaseCatalogueItem"}, allEntries=true)
    public void modifyObj(PurchaseCatalogueItem t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.purchaseCatalogueItemMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"purchaseCatalogueItem"}, keyGenerator="redisKeyGenerator")
    public PurchaseCatalogueItem queryObjById(String id) {
        return this.purchaseCatalogueItemMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"purchaseCatalogueItem"}, keyGenerator="redisKeyGenerator")
    public List<PurchaseCatalogueItem> queryAllObjByExample(PurchaseCatalogueItemExample example) {
        return this.purchaseCatalogueItemMapper.selectByExample(example);
    }

    @Cacheable(value={"purchaseCatalogueItem"}, keyGenerator="redisKeyGenerator")
    public PageView<PurchaseCatalogueItem> queryObjByPage(PurchaseCatalogueItemExample example) {
        PageView<PurchaseCatalogueItem> pageView = example.getPageView();
        pageView.setQueryResult(this.purchaseCatalogueItemMapper.selectByExampleByPage(example));
        return pageView;
    }
}

