/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.catalogue.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.catalogue.entity.PurchaseCatalogueHead;
import com.els.base.catalogue.entity.PurchaseCatalogueHeadExample;
import com.els.base.catalogue.service.PurchaseCatalogueHeadService;
import com.els.base.catalogue.vo.PurchaseCatalogueVO;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.product.entity.PurchaseProductCatalogExample;
import com.els.base.product.service.PurchaseProductCatalogService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u91c7\u8d2d\u76ee\u5f55"})
@Controller
@RequestMapping(value={"purchaseCatalogueHead"})
public class PurchaseCatalogueHeadController {
    @Resource
    protected PurchaseCatalogueHeadService purchaseCatalogueHeadService;
    @Resource
    protected GenerateCodeService generateCodeService;
    @Resource
    protected PurchaseProductCatalogService purchaseProductCatalogService;

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u8bbe\u7f6e\u91c7\u8d2d\u76ee\u5f55\u72b6\u6001\u662f\u5426\u751f\u6548\u6216\u8005\u5931\u6548")
    @RequestMapping(value={"service/setting"})
    @ResponseBody
    public ResponseResult<String> setting(@RequestBody PurchaseCatalogueVO purchaseCatalogueVO) {
        Assert.isNotNull((Object)purchaseCatalogueVO, (String)"\u91c7\u8d2d\u76ee\u5f55\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List<String> ids = purchaseCatalogueVO.getIds();
        Assert.isNotEmpty(ids, (String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u6761\u91c7\u8d2d\u76ee\u5f55\u4fe1\u606f\uff01");
        Integer purchaseCatalogueStatus = purchaseCatalogueVO.getPurchaseCatalogueStatus();
        Assert.isNotNull((Object)purchaseCatalogueStatus, (String)"\u8bf7\u9009\u62e9\u8981\u8bbe\u7f6e\u7684\u72b6\u6001");
        PurchaseCatalogueHeadExample example = new PurchaseCatalogueHeadExample();
        example.createCriteria().andIdIn((List)ids);
        PurchaseCatalogueHead head = new PurchaseCatalogueHead();
        head.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
        head.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
        head.setUpdateTime(new Date());
        head.setPurchaseCatalogStatus(purchaseCatalogueStatus);
        this.purchaseCatalogueHeadService.updateByExampleSelective(head, example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u91c7\u8d2d\u76ee\u5f55")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody PurchaseCatalogueHead purchaseCatalogueHead) {
        Assert.isNotNull((Object)purchaseCatalogueHead, (String)"\u91c7\u8d2d\u76ee\u5f55\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String nextCode = this.generateCodeService.getNextCode("CATALOGUE_CODE");
        purchaseCatalogueHead.setPurchaseCatalogCode(nextCode);
        purchaseCatalogueHead.setCreateTime(new Date());
        purchaseCatalogueHead.setCreateUserId(SpringSecurityUtils.getLoginUserId());
        purchaseCatalogueHead.setCreateUserName(SpringSecurityUtils.getLoginUserName());
        this.purchaseCatalogueHeadService.addObj(purchaseCatalogueHead);
        return ResponseResult.success((Object)purchaseCatalogueHead.getId());
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u91c7\u8d2d\u76ee\u5f55")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody PurchaseCatalogueHead purchaseCatalogueHead) {
        Assert.isNotBlank((String)purchaseCatalogueHead.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        purchaseCatalogueHead.setUpdateTime(new Date());
        purchaseCatalogueHead.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
        purchaseCatalogueHead.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
        this.purchaseCatalogueHeadService.modifyObj(purchaseCatalogueHead);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u91c7\u8d2d\u76ee\u5f55")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        PurchaseCatalogueHeadExample example = new PurchaseCatalogueHeadExample();
        example.createCriteria().andIdIn((List)ids);
        this.purchaseCatalogueHeadService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u8be2\u91c7\u8d2d\u76ee\u5f55\u8be6\u60c5")
    @RequestMapping(value={"service/findById"})
    @ResponseBody
    public ResponseResult<PurchaseCatalogueHead> findById(@RequestParam String id) {
        Assert.isNotBlank((String)id, (String)"\u67e5\u8be2\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        PurchaseCatalogueHead purchaseCatalogueHead = (PurchaseCatalogueHead)this.purchaseCatalogueHeadService.queryObjById(id);
        return ResponseResult.success((Object)purchaseCatalogueHead);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u91c7\u8d2d\u76ee\u5f55")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseCatalogueHead", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseCatalogueHead>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        PageView pageData;
        List queryResult;
        PurchaseCatalogueHeadExample example = new PurchaseCatalogueHeadExample();
        example.setPageView((PageView<PurchaseCatalogueHead>)new PageView(pageNo, pageSize));
        PurchaseCatalogueHeadExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        if (CollectionUtils.isNotEmpty((Collection)(queryResult = (pageData = this.purchaseCatalogueHeadService.queryObjByPage((IExample)example)).getQueryResult()))) {
            for (PurchaseCatalogueHead purchaseCatalogueHead : queryResult) {
                PurchaseProductCatalogExample example1 = new PurchaseProductCatalogExample();
                example1.createCriteria().andPurchaseCatalogIdEqualTo(purchaseCatalogueHead.getId());
                int i = this.purchaseProductCatalogService.countByExample(example1);
                purchaseCatalogueHead.setProductNum(i);
            }
        }
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u5168\u90e8\u91c7\u8d2d\u76ee\u5f55")
    @ApiImplicitParams(value={@ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseCatalogueHead", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findAll"})
    @ResponseBody
    public ResponseResult<List<PurchaseCatalogueHead>> findAll(@RequestBody(required=false) QueryParamWapper wapper) {
        List pageData;
        PurchaseCatalogueHeadExample example = new PurchaseCatalogueHeadExample();
        PurchaseCatalogueHeadExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        if (CollectionUtils.isNotEmpty((Collection)(pageData = this.purchaseCatalogueHeadService.queryAllObjByExample((IExample)example)))) {
            for (PurchaseCatalogueHead purchaseCatalogueHead : pageData) {
                PurchaseProductCatalogExample example1 = new PurchaseProductCatalogExample();
                example1.createCriteria().andPurchaseCatalogIdEqualTo(purchaseCatalogueHead.getId());
                int i = this.purchaseProductCatalogService.countByExample(example1);
                purchaseCatalogueHead.setProductNum(i);
            }
        }
        return ResponseResult.success((Object)pageData);
    }
}

