/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.delivery.command;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.exception.CommonException;
import com.els.base.delivery.command.ViewDeliveryOrderDetailCmd;
import com.els.base.delivery.entity.DeliveryOrder;
import com.els.base.delivery.service.DeliveryOrderWriteBackService;
import com.els.base.utils.SpringContextHolder;

public class WriteBackToErpCommand
extends AbstractCommand<String> {
    private static final long serialVersionUID = 1L;
    private static DeliveryOrderWriteBackService writeBackService;
    private String deliveryId;
    private WriteBackType writeBackType;
    private DeliveryOrder deliveryOrder;

    public WriteBackToErpCommand(DeliveryOrder deliveryOrder) {
        this.deliveryOrder = deliveryOrder;
        this.writeBackType = WriteBackType.PART_OR_ORDER;
    }

    public WriteBackToErpCommand(String deliveryId) {
        this.deliveryId = deliveryId;
        this.writeBackType = WriteBackType.WHOLE_ORDER;
    }

    @Override
    public String execute(ICommandInvoker context) {
        switch (this.writeBackType) {
            case PART_OR_ORDER: {
                this.writBack(this.deliveryOrder);
                break;
            }
            case WHOLE_ORDER: {
                this.writBack(this.deliveryId);
                break;
            }
        }
        return null;
    }

    private void writBack(DeliveryOrder deliveryOrder) {
        DeliveryOrderWriteBackService writeBackService = this.getWriteBackService();
        try {
            writeBackService.writeBack(deliveryOrder, this.writeBackType);
        }
        catch (Exception e) {
            String errorMsg = String.format("\u9001\u8d27\u5355[%s] \u56de\u5199\u5931\u8d25:%s", deliveryOrder.getDeliveryOrderNo(), e.getMessage());
            this.logger.error(errorMsg, (Throwable)e);
            throw new CommonException(errorMsg);
        }
    }

    private void writBack(String deliveryId) {
        DeliveryOrderWriteBackService writeBackService = this.getWriteBackService();
        ViewDeliveryOrderDetailCmd viewDeliveryOrderDetailCmd = new ViewDeliveryOrderDetailCmd(deliveryId);
        DeliveryOrder deliveryOrder = this.context.invoke(viewDeliveryOrderDetailCmd);
        try {
            writeBackService.writeBack(deliveryOrder, this.writeBackType);
        }
        catch (Exception e) {
            String errorMsg = String.format("\u9001\u8d27\u5355[%s] \u56de\u5199\u5931\u8d25:%s", deliveryOrder.getDeliveryOrderNo(), e.getMessage());
            this.logger.error(errorMsg, (Throwable)e);
            throw new CommonException(errorMsg);
        }
    }

    private DeliveryOrderWriteBackService getWriteBackService() {
        if (writeBackService == null) {
            writeBackService = (DeliveryOrderWriteBackService)SpringContextHolder.getOneBean(DeliveryOrderWriteBackService.class);
        }
        if (writeBackService == null) {
            throw new CommonException("\u7cfb\u7edf\u7f3a\u5c11\u56de\u5199\u9001\u8d27\u5355\u7684service\u5b9e\u73b0");
        }
        return writeBackService;
    }

    public static enum WriteBackType {
        WHOLE_ORDER,
        PART_OR_ORDER;

    }
}

