/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.delivery.service.impl;

import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.delivery.dao.DeliveryOrderAddressMapper;
import com.els.base.delivery.entity.DeliveryOrderAddress;
import com.els.base.delivery.entity.DeliveryOrderAddressExample;
import com.els.base.delivery.service.DeliveryOrderAddressService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultDeliveryOrderAddressService")
public class DeliveryOrderAddressServiceImpl
implements DeliveryOrderAddressService {
    @Resource
    protected DeliveryOrderAddressMapper deliveryOrderAddressMapper;

    @CacheEvict(value={"deliveryOrderAddress"}, allEntries=true)
    public void addObj(DeliveryOrderAddress t) {
        this.deliveryOrderAddressMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"deliveryOrderAddress"}, allEntries=true)
    public void addAll(List<DeliveryOrderAddress> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.deliveryOrderAddressMapper.insertBatch(list);
    }

    @CacheEvict(value={"deliveryOrderAddress"}, allEntries=true)
    public void deleteObjById(String id) {
        this.deliveryOrderAddressMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"deliveryOrderAddress"}, allEntries=true)
    public void deleteByExample(DeliveryOrderAddressExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.deliveryOrderAddressMapper.deleteByExample(example);
    }

    @CacheEvict(value={"deliveryOrderAddress"}, allEntries=true)
    public void modifyObj(DeliveryOrderAddress t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.deliveryOrderAddressMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"deliveryOrderAddress"}, keyGenerator="redisKeyGenerator")
    public DeliveryOrderAddress queryObjById(String id) {
        return this.deliveryOrderAddressMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"deliveryOrderAddress"}, keyGenerator="redisKeyGenerator")
    public List<DeliveryOrderAddress> queryAllObjByExample(DeliveryOrderAddressExample example) {
        return this.deliveryOrderAddressMapper.selectByExample(example);
    }

    @Cacheable(value={"deliveryOrderAddress"}, keyGenerator="redisKeyGenerator")
    public PageView<DeliveryOrderAddress> queryObjByPage(DeliveryOrderAddressExample example) {
        PageView<DeliveryOrderAddress> pageView = example.getPageView();
        pageView.setQueryResult(this.deliveryOrderAddressMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"deliveryOrderAddress"}, allEntries=true)
    public void insertObj(DeliveryOrderAddress deliveryOrderAddress, User loginUser, Company purCompany) {
        this.chcekData(deliveryOrderAddress);
        DeliveryOrderAddressExample example = new DeliveryOrderAddressExample();
        example.createCriteria().andDepartIdEqualTo(deliveryOrderAddress.getDepartId()).andAddressEqualTo(deliveryOrderAddress.getAddress());
        if (this.deliveryOrderAddressMapper.countByExample(example) > 0) {
            throw new CommonException("\u540c\u4e00\u4e2a\u90e8\u95e8\u4e0d\u80fd\u521b\u5efa\u4e24\u4e2a\u76f8\u540c\u7684\u6536\u8d27\u5730\u5740");
        }
        deliveryOrderAddress.setPurCompanyCode(purCompany.getCompanyCode());
        deliveryOrderAddress.setPurCompanyName(purCompany.getCompanyFullName());
        deliveryOrderAddress.setCreater(loginUser.getNickName());
        deliveryOrderAddress.setCreateTime(new Date());
        deliveryOrderAddress.setIsEnble(Constant.YES_INT);
        this.deliveryOrderAddressMapper.insertSelective(deliveryOrderAddress);
    }

    private void chcekData(DeliveryOrderAddress deliveryOrderAddress) {
        Assert.isNotBlank((String)deliveryOrderAddress.getDepartId(), (String)"\u90e8\u95e8ID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)deliveryOrderAddress.getDepartName(), (String)"\u90e8\u95e8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)deliveryOrderAddress.getAddress(), (String)"\u6536\u8d27\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)deliveryOrderAddress.getInstitutionsId(), (String)"\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)deliveryOrderAddress.getConsignee(), (String)"\u6536\u8d27\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)deliveryOrderAddress.getPurchasePhone(), (String)"\u6536\u8d27\u4eba\u8054\u7cfb\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)deliveryOrderAddress.getAccountSetId(), (String)"\u8d26\u5957ID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)deliveryOrderAddress.getConsigneeId(), (String)"\u6536\u8d27\u4ebaID\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Override
    @CacheEvict(value={"deliveryOrderAddress"}, allEntries=true)
    public void modifyAddress(DeliveryOrderAddress deliveryOrderAddress, User loginUser) {
        this.chcekData(deliveryOrderAddress);
        DeliveryOrderAddressExample example = new DeliveryOrderAddressExample();
        example.createCriteria().andDepartIdEqualTo(deliveryOrderAddress.getDepartId()).andAddressEqualTo(deliveryOrderAddress.getAddress());
        if (this.deliveryOrderAddressMapper.countByExample(example) > 0) {
            throw new CommonException("\u540c\u4e00\u4e2a\u90e8\u95e8\u4e0d\u80fd\u521b\u5efa\u4e24\u4e2a\u76f8\u540c\u7684\u6536\u8d27\u5730\u5740");
        }
        deliveryOrderAddress.setUpdataUser(loginUser.getNickName());
        deliveryOrderAddress.setUpdateTime(new Date());
        this.deliveryOrderAddressMapper.updateByPrimaryKeySelective(deliveryOrderAddress);
    }
}

